/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.DirectoryHolder;
import java.io.File;
import java.util.Set;
import javax.swing.Icon;

public abstract class AbstractDirectoryHolder
implements DirectoryHolder {
    Set<File> _hideFiles;

    @Override
    public File[] getFiles() {
        this._hideFiles = TorrentUtil.getIgnorableFiles();
        File[] fileArray = this.getDirectory().listFiles(this);
        return fileArray != null ? fileArray : new File[]{};
    }

    @Override
    public boolean accept(File file) {
        if (this._hideFiles != null && (this._hideFiles.contains(file) || !this.isFileVisible(file) || file.getName().toLowerCase().equals(".ds_store"))) {
            return false;
        }
        File file2 = file.getParentFile();
        return file2 != null && file2.equals(this.getDirectory());
    }

    protected boolean isFileVisible(File file) {
        return file != null && file.exists() && file.canRead() && !file.isHidden();
    }

    @Override
    public String getName() {
        return this.getDirectory().getName();
    }

    @Override
    public String getDescription() {
        return this.getDirectory().getAbsolutePath();
    }

    @Override
    public int size() {
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return 0;
        }
        return fileArray.length;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

