/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

abstract class AbstractLibraryTableMediator<T extends DataLineModel<E, I>, E extends AbstractLibraryTableDataLine<I>, I>
extends AbstractTableMediator<T, E, I> {
    private MediaType mediaType;
    protected Action SEND_TO_FRIEND_ACTION;
    protected Action OPTIONS_ACTION;
    private int needToScrollTo;
    private AdjustmentListener adjustmentListener;

    protected AbstractLibraryTableMediator(String string) {
        super(string);
        GUIMediator.addRefreshListener(this);
        this.mediaType = MediaType.getAnyTypeMediaType();
        this.needToScrollTo = -1;
    }

    @Override
    protected void setupConstants() {
    }

    public List<AbstractLibraryTableDataLine<I>> getSelectedLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList<AbstractLibraryTableDataLine<I>> arrayList = new ArrayList<AbstractLibraryTableDataLine<I>>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((AbstractLibraryTableDataLine<I>)this.DATA_MODEL.get(nArray[i]));
        }
        return arrayList;
    }

    public I getItemAt(int n) {
        try {
            return (I)((AbstractLibraryTableDataLine)this.DATA_MODEL.get(n)).getInitializeObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean setItemSelected(I i) {
        int n = this.DATA_MODEL.getRow(i);
        if (n != -1) {
            this.TABLE.setSelectedRow(n);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    public boolean selectItemAt(int n) {
        return this.setItemSelected(this.getItemAt(n));
    }

    @Override
    protected JComponent getScrolledTablePane() {
        JComponent jComponent = super.getScrolledTablePane();
        if (this.adjustmentListener == null) {
            this.adjustmentListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    AbstractLibraryTableMediator.this.adjustmentListener_adjustmentValueChanged(adjustmentEvent);
                }
            };
            this.SCROLL_PANE.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
        }
        return jComponent;
    }

    public abstract List<AudioSource> getFileView();

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.SEND_TO_FRIEND_ACTION = new SendToFriendAction();
        this.OPTIONS_ACTION = new ConfigureOptionsAction("OPTIONS_LIBRARY_MAIN_TITLE", I18n.tr("Options"), I18n.tr("You can configure the folders you share in FrostWire's Options."));
    }

    protected SkinMenu createAddToPlaylistSubMenu() {
        SkinMenu skinMenu = new SkinMenu(I18n.tr("Add to playlist"));
        skinMenu.add(new SkinMenuItem(new CreateNewPlaylistAction()));
        Library library = LibraryMediator.getLibrary();
        List<Playlist> list = library.getPlaylists();
        Playlist playlist = LibraryMediator.instance().getSelectedPlaylist();
        if (list.size() > 0) {
            skinMenu.addSeparator();
            for (Playlist playlist2 : library.getPlaylists()) {
                if (playlist != null && playlist.equals(playlist2)) continue;
                skinMenu.add(new SkinMenuItem(new AddToPlaylistAction(playlist2)));
            }
        }
        return skinMenu;
    }

    private void adjustmentListener_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        try {
            int n = this.needToScrollTo;
            if (n >= 0 && this.SCROLL_PANE.getVerticalScrollBar().getMaximum() >= n) {
                if (n >= 0) {
                    this.SCROLL_PANE.getVerticalScrollBar().setValue(n);
                    Toolkit.getDefaultToolkit().sync();
                }
                this.needToScrollTo = -1;
            }
        }
        catch (Exception exception) {
            this.needToScrollTo = -1;
        }
    }

    void scrollTo(int n) {
        this.needToScrollTo = n;
    }

    int getScrollbarValue() {
        if (this.SCROLL_PANE != null && this.SCROLL_PANE.getVerticalScrollBar() != null) {
            return this.SCROLL_PANE.getVerticalScrollBar().getValue();
        }
        return 0;
    }

    public void playCurrentSelection() {
        AbstractLibraryTableDataLine abstractLibraryTableDataLine = (AbstractLibraryTableDataLine)this.DATA_MODEL.get(this.TABLE.getSelectedRow());
        if (abstractLibraryTableDataLine == null) {
            return;
        }
        try {
            AudioSource audioSource = this.createAudioSource(abstractLibraryTableDataLine);
            if (audioSource != null) {
                AudioPlayer.instance().asyncLoadSong(audioSource, true, false, null, this.getFileView());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract AudioSource createAudioSource(E var1);

    @Override
    public void removeSelection() {
        super.removeSelection();
        LibraryMediator.instance().clearDirectoryHolderCaches();
    }

    static class SendToFriendAction
    extends AbstractAction {
        private static final long serialVersionUID = 1329472129818371471L;

        public SendToFriendAction() {
            super(I18n.tr("Send to friend"));
            this.putValue("LimeShortName", I18n.tr("Send"));
            this.putValue("LongDescription", I18n.tr("Send to friend"));
            this.putValue("SmallIcon", GUIMediator.getThemeImage("share"));
            this.putValue("LimeIconName", "LIBRARY_SEND");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = LibraryMediator.instance().getSelectedFile();
            if (file == null) {
                return;
            }
            int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("Do you want to send this file to a friend?") + "\n\n\"" + file.getName() + "\"", I18n.tr("Send files with FrostWire"), 0, 3);
            if (n == 0) {
                new SendFileProgressDialog(GUIMediator.getAppFrame(), file).setVisible(true);
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        }
    }

    private final class AddToPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 4658698262279334616L;
        private Playlist playlist;

        public AddToPlaylistAction(Playlist playlist) {
            super(playlist.getName());
            this.putValue("LongDescription", I18n.tr("Add to playlist ") + "\"" + playlist.getName() + "\"");
            this.playlist = playlist;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryUtils.asyncAddToPlaylist(this.playlist, AbstractLibraryTableMediator.this.getSelectedLines());
        }
    }

    private class CreateNewPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 3460908036485828909L;

        public CreateNewPlaylistAction() {
            super(I18n.tr("Create New Playlist"));
            this.putValue("LongDescription", I18n.tr("Create and add to a new playlist"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryUtils.createNewPlaylist(AbstractLibraryTableMediator.this.getSelectedLines());
        }
    }
}

