/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.mp3.ID3v2;
import com.frostwire.mp3.Mp3File;
import com.frostwire.mplayer.MPlayer;
import java.io.File;
import java.util.Map;
import org.limewire.util.FilenameUtils;
import org.limewire.util.StringUtils;

public class AudioMetaData {
    private String title;
    private float durationInSecs;
    private String artist;
    private String album;
    private String bitrate;
    private String comment;
    private String genre;
    private String track;
    private String year;

    public AudioMetaData(File file) {
        this.readUsingMPlayer(file);
        if (file.getName().endsWith("mp3")) {
            this.readUsingMP3Tags(file);
        }
        this.sanitizeData(file);
    }

    public String getTitle() {
        return this.title;
    }

    public float getDurationInSecs() {
        return this.durationInSecs;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getBitrate() {
        return this.bitrate;
    }

    public String getComment() {
        return this.comment;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getTrack() {
        return this.track;
    }

    public String getYear() {
        return this.year;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUsingMPlayer(File file) {
        MPlayer mPlayer = new MPlayer();
        try {
            Map<String, String> map = mPlayer.getProperties(file.getAbsolutePath());
            this.title = map.get("Title");
            this.durationInSecs = this.parseDurationInSecs(map.get("ID_LENGTH"));
            this.artist = map.get("Artist");
            this.album = map.get("Album");
            this.bitrate = this.parseBitrate(map.get("ID_AUDIO_BITRATE"));
            this.comment = map.get("Comment");
            this.genre = map.get("Genre");
            this.track = map.get("Track");
            this.year = map.get("Year");
        }
        finally {
            mPlayer.dispose();
        }
    }

    private void readUsingMP3Tags(File file) {
        try {
            Mp3File mp3File = new Mp3File(file.getAbsolutePath());
            if (mp3File.hasId3v2Tag()) {
                ID3v2 iD3v2 = mp3File.getId3v2Tag();
                if (!StringUtils.isNullOrEmpty(iD3v2.getTitle(), true)) {
                    this.title = iD3v2.getTitle();
                }
                if (!StringUtils.isNullOrEmpty(iD3v2.getArtist(), true)) {
                    this.artist = iD3v2.getArtist();
                }
                if (!StringUtils.isNullOrEmpty(iD3v2.getAlbum(), true)) {
                    this.album = iD3v2.getAlbum();
                }
                if (!StringUtils.isNullOrEmpty(iD3v2.getComment(), true) || this.comment.startsWith("0")) {
                    this.comment = iD3v2.getComment();
                }
                if (!StringUtils.isNullOrEmpty(iD3v2.getGenreDescription(), true) || this.genre.trim().equals("Unknown")) {
                    this.genre = iD3v2.getGenreDescription();
                }
                if (!StringUtils.isNullOrEmpty(iD3v2.getTrack(), true)) {
                    this.track = iD3v2.getTrack();
                }
                if (!StringUtils.isNullOrEmpty(iD3v2.getYear(), true)) {
                    this.year = iD3v2.getYear();
                }
                this.durationInSecs = mp3File.getLengthInSeconds();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sanitizeData(File file) {
        if (StringUtils.isNullOrEmpty(this.title, true)) {
            this.title = FilenameUtils.getBaseName(file.getAbsolutePath());
        }
        if (this.durationInSecs < 0.0f) {
            this.durationInSecs = 0.0f;
        }
        if (this.artist == null) {
            this.artist = "";
        }
        if (this.album == null) {
            this.album = "";
        }
        if (this.bitrate == null) {
            this.bitrate = "";
        }
        if (this.comment == null) {
            this.comment = "";
        }
        if (this.genre == null) {
            this.genre = "";
        }
        if (this.track == null) {
            this.track = "";
        } else {
            int n = -1;
            n = this.track.indexOf(47);
            if (n != -1) {
                this.track = this.track.substring(0, n);
            }
        }
        if (this.year == null) {
            this.year = "";
        }
    }

    private String parseBitrate(String string) {
        if (string == null) {
            return "";
        }
        try {
            return Integer.parseInt(string) / 1000 + " kbps";
        }
        catch (Exception exception) {
            return string;
        }
    }

    public float parseDurationInSecs(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }
}

