/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.HttpFetcher;
import com.frostwire.HttpFetcherListener;
import com.frostwire.JsonEngine;
import com.frostwire.gui.library.DesktopUploadRequest;
import com.frostwire.gui.library.DeviceUploadDialog;
import com.frostwire.gui.library.DeviceUploadTask;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.FileDescriptorList;
import com.frostwire.gui.library.Finger;
import com.frostwire.gui.library.ProgressFileEntity;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.util.EncodingUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.NetworkUtils;

public class Device {
    private static final Log LOG = LogFactory.getLog(Device.class);
    private static final ExecutorService executor = ExecutorsHelper.newFixedSizeThreadPool(3, "UploadToDeviceExecutor");
    public static int ACTION_BROWSE = 0;
    public static int ACTION_DOWNLOAD = 1;
    public static int ACTION_UPLOAD = 2;
    private static JsonEngine JSON_ENGINE = new JsonEngine();
    private InetAddress _address;
    private int _port;
    private Finger finger;
    private boolean _tokenAuthorized;
    private OnActionFailedListener _listener;
    private long timestamp;

    public Device(InetAddress inetAddress, int n, Finger finger) {
        this._address = inetAddress;
        this._port = n;
        this.finger = finger;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetAddress inetAddress) {
        this._address = inetAddress;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public Finger getFinger() {
        return this.finger;
    }

    public void setFinger(Finger finger) {
        this.finger = finger;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public String getName() {
        return this.finger.nickname;
    }

    public String getKey() {
        return this._address.getHostAddress() + ":" + this._port;
    }

    public int getTotalShared() {
        return this.finger.numSharedApplicationFiles + this.finger.numSharedDocumentFiles + this.finger.numSharedPictureFiles + this.finger.numSharedVideoFiles + this.finger.numSharedRingtoneFiles + this.finger.numSharedAudioFiles;
    }

    public boolean isTokenAuthorized() {
        return this._tokenAuthorized;
    }

    public void setTokenAuthorized(boolean bl) {
        this._tokenAuthorized = bl;
    }

    public OnActionFailedListener getOnActionFailedListener() {
        return this._listener;
    }

    public void setOnActionFailedListener(OnActionFailedListener onActionFailedListener) {
        this._listener = onActionFailedListener;
    }

    public List<FileDescriptor> browse(byte by) {
        try {
            URI uRI = new URI("http://" + this._address.getHostAddress() + ":" + this._port + "/browse?type=" + by);
            HttpFetcher httpFetcher = new HttpFetcher(uRI, 10000);
            byte[] byArray = (byte[])httpFetcher.fetch(true)[0];
            if (byArray == null) {
                this.notifyOnActionFailed(ACTION_BROWSE, null);
                return new ArrayList<FileDescriptor>();
            }
            this.setTimestamp(System.currentTimeMillis());
            String string = new String(byArray);
            FileDescriptorList fileDescriptorList = JSON_ENGINE.toObject(string, FileDescriptorList.class);
            return fileDescriptorList.files;
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_BROWSE, exception);
            return new ArrayList<FileDescriptor>();
        }
    }

    public URL getDownloadURL(int n, int n2) {
        try {
            return new URL("http://" + this._address.getHostAddress() + ":" + this._port + "/download?type=" + n + "&id=" + n2);
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_DOWNLOAD, exception);
            return null;
        }
    }

    public String getDownloadURL(FileDescriptor fileDescriptor) {
        return "http://" + this._address.getHostAddress() + ":" + this._port + "/download?type=" + fileDescriptor.fileType + "&id=" + fileDescriptor.id;
    }

    public byte[] download(int n, int n2) {
        try {
            URI uRI = this.getDownloadURL(n, n2).toURI();
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            byte[] byArray = httpFetcher.fetch();
            if (byArray == null) {
                this.notifyOnActionFailed(ACTION_DOWNLOAD, null);
                return null;
            }
            this.setTimestamp(System.currentTimeMillis());
            return byArray;
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_DOWNLOAD, exception);
            return null;
        }
    }

    public void upload(File[] fileArray) {
        try {
            final DesktopUploadRequest desktopUploadRequest = new DesktopUploadRequest();
            desktopUploadRequest.address = NetworkUtils.getLocalAddress().getHostAddress();
            desktopUploadRequest.computerName = NetworkUtils.getLocalAddress().getHostName();
            desktopUploadRequest.files = new ArrayList<FileDescriptor>();
            for (File object2 : Device.flatFiles(fileArray)) {
                for (File file : Device.getFiles(object2, 3)) {
                    FileDescriptor fileDescriptor = new FileDescriptor();
                    fileDescriptor.filePath = file.getAbsolutePath();
                    fileDescriptor.fileSize = file.length();
                    desktopUploadRequest.files.add(fileDescriptor);
                }
            }
            HttpFetcher httpFetcher = new HttpFetcher("http://" + this._address.getHostAddress() + ":" + this._port + "/dekstop-upload-request", 60000);
            String string = new JsonEngine().toJson(desktopUploadRequest);
            final DeviceUploadDialog deviceUploadDialog = new DeviceUploadDialog(GUIMediator.getAppFrame());
            httpFetcher.asyncPostJSON(string, new HttpFetcherListener(){

                @Override
                public void onSuccess(final byte[] byArray) {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (deviceUploadDialog.isVisible()) {
                                deviceUploadDialog.setVisible(false);
                                try {
                                    String string = new String(byArray, "UTF-8");
                                    executor.execute(new DeviceUploadTask(Device.this, desktopUploadRequest.files.toArray(new FileDescriptor[0]), string));
                                }
                                catch (Throwable throwable) {
                                    LOG.error("Error uploading files to device", throwable);
                                }
                            }
                        }
                    });
                }

                @Override
                public void onError(Throwable throwable) {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (deviceUploadDialog.isVisible()) {
                                deviceUploadDialog.setVisible(false);
                                JOptionPane.showMessageDialog(GUIMediator.getAppFrame(), I18n.tr("The device is busy with another transfer or did not authorize your request"), I18n.tr("Transfer failed"), 1);
                            }
                        }
                    });
                }
            });
            deviceUploadDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            LOG.error("Error uploading files to device", throwable);
        }
    }

    public void upload(File file, String string, ProgressFileEntity.ProgressFileEntityListener progressFileEntityListener) {
        URI uRI = null;
        try {
            uRI = new URI("http://" + this._address.getHostAddress() + ":" + this._port + "/desktop-upload?filePath=" + EncodingUtils.encode(file.getAbsolutePath()) + "&token=" + EncodingUtils.encode(string));
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            ProgressFileEntity progressFileEntity = new ProgressFileEntity(file);
            progressFileEntity.setProgressFileEntityListener(progressFileEntityListener);
            httpFetcher.post(progressFileEntity);
        }
        catch (Exception exception) {
            this.notifyOnActionFailed(ACTION_UPLOAD, exception);
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Device)) {
            return false;
        }
        return this.hashCode() == ((Device)object).hashCode();
    }

    public String toString() {
        return this._address + ":" + this._port + ", " + this.finger;
    }

    protected void notifyOnActionFailed(int n, Exception exception) {
        if (this._listener != null) {
            this._listener.onActionFailed(this, n, exception);
        }
    }

    private static List<File> flatFiles(File[] fileArray) {
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : fileArray) {
            for (File file2 : Device.getFiles(file, 3)) {
                if (hashSet.contains(file2)) continue;
                hashSet.add(file2);
            }
        }
        return new ArrayList<File>(hashSet);
    }

    private static List<File> getFiles(File file, int n) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file == null) {
            return arrayList;
        }
        if (!file.isDirectory()) {
            arrayList.add(file);
            return arrayList;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) {
                arrayList.add(file2);
                continue;
            }
            if (n <= 0) continue;
            arrayList.addAll(Device.getFiles(file2, n - 1));
        }
        return arrayList;
    }

    public static interface OnActionFailedListener {
        public void onActionFailed(Device var1, int var2, Exception var3);
    }
}

