/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.HttpFetcher;
import com.frostwire.JsonEngine;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.Finger;
import com.frostwire.gui.library.LibraryMediator;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.NetworkUtils;

public class DeviceDiscoveryClerk {
    private static final Log LOG = LogFactory.getLog(DeviceDiscoveryClerk.class);
    private static final long STALE_DEVICE_TIMEOUT = 14000L;
    private Map<String, Device> deviceCache = Collections.synchronizedMap(new HashMap());
    private JsonEngine jsonEngine = new JsonEngine();

    public void start() {
        try {
            this.startBroadcast();
        }
        catch (Throwable throwable) {
            LOG.error("Error starting broadcast", throwable);
        }
        try {
            this.startMulticast();
        }
        catch (Exception exception) {
            LOG.error("Error starting multicast", exception);
        }
        new Thread((Runnable)new CleanStaleDevices(), "CleanStaleDevices").start();
    }

    private void startBroadcast() throws Exception {
        final DatagramSocket datagramSocket = new DatagramSocket(null);
        datagramSocket.setReuseAddress(true);
        datagramSocket.setBroadcast(true);
        datagramSocket.setSoTimeout(60000);
        datagramSocket.bind(new InetSocketAddress(65456));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        byte[] byArray = new byte[65535];
                        while (true) {
                            try {
                                while (true) {
                                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                                    datagramSocket.receive(datagramPacket);
                                    DeviceDiscoveryClerk.this.handleDatagramPacket(datagramPacket, false);
                                }
                            }
                            catch (InterruptedIOException interruptedIOException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error("Error receiving broadcast", throwable);
                        datagramSocket.close();
                        datagramSocket.disconnect();
                    }
                }
                catch (Throwable throwable) {
                    datagramSocket.close();
                    datagramSocket.disconnect();
                    throw throwable;
                }
            }
        }, "BroadcastClerk").start();
    }

    private void startMulticast() throws Exception {
        InetAddress inetAddress = InetAddress.getByAddress(new byte[]{-32, 0, 1, 16});
        final MulticastSocket multicastSocket = new MulticastSocket(65440);
        multicastSocket.setSoTimeout(60000);
        multicastSocket.setTimeToLive(254);
        multicastSocket.setReuseAddress(true);
        InetAddress inetAddress2 = null;
        inetAddress2 = !ConnectionSettings.CUSTOM_INETADRESS.isDefault() ? InetAddress.getByName(ConnectionSettings.CUSTOM_INETADRESS.getValue()) : NetworkUtils.getLocalAddress();
        multicastSocket.setNetworkInterface(NetworkInterface.getByInetAddress(inetAddress2));
        multicastSocket.joinGroup(inetAddress);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        byte[] byArray = new byte[65535];
                        while (true) {
                            try {
                                while (true) {
                                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                                    multicastSocket.receive(datagramPacket);
                                    DeviceDiscoveryClerk.this.handleDatagramPacket(datagramPacket, true);
                                }
                            }
                            catch (InterruptedIOException interruptedIOException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error("Error receiving broadcast", throwable);
                        multicastSocket.close();
                        multicastSocket.disconnect();
                    }
                }
                catch (Throwable throwable) {
                    multicastSocket.close();
                    multicastSocket.disconnect();
                    throw throwable;
                }
            }
        }, "MulticastClerk").start();
    }

    private void handleDatagramPacket(DatagramPacket datagramPacket, boolean bl) {
        InetAddress inetAddress = datagramPacket.getAddress();
        byte[] byArray = datagramPacket.getData();
        int n = ((byArray[30] & 0xFF) << 8) + (byArray[31] & 0xFF);
        boolean bl2 = (byArray[51] & 0xFF) != 0;
        this.handleDeviceState(inetAddress, n, bl2);
    }

    private void handleDeviceState(InetAddress inetAddress, int n, boolean bl) {
        String string = inetAddress.getHostAddress() + ":" + n;
        if (!bl) {
            this.retrieveFinger(string, inetAddress, n);
        } else if (this.deviceCache.containsKey(string)) {
            Device device = this.deviceCache.get(string);
            this.handleDeviceStale(string, device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retrieveFinger(final String string, InetAddress inetAddress, int n) {
        try {
            URI uRI = new URI("http://" + string + "/finger");
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            byte[] byArray = httpFetcher.fetch();
            if (byArray == null) {
                LOG.error("Failed to connnect to " + uRI);
                return false;
            }
            String string2 = new String(byArray);
            Finger finger = this.jsonEngine.toObject(string2, Finger.class);
            Map<String, Device> map = this.deviceCache;
            synchronized (map) {
                if (this.deviceCache.containsKey(string)) {
                    Device device = this.deviceCache.get(string);
                    device.setFinger(finger);
                    this.handleDeviceAlive(string, device);
                } else {
                    Device device = new Device(inetAddress, n, finger);
                    device.setOnActionFailedListener(new Device.OnActionFailedListener(){

                        @Override
                        public void onActionFailed(Device device, int n, Exception exception) {
                            DeviceDiscoveryClerk.this.handleDeviceStale(string, device);
                        }
                    });
                    this.handleDeviceNew(string, device);
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            LOG.error("Failed to connnect to " + string);
            return false;
        }
    }

    private void handleDeviceNew(String string, final Device device) {
        this.deviceCache.put(string, device);
        device.setTimestamp(System.currentTimeMillis());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.instance().handleDeviceNew(device);
            }
        });
    }

    private void handleDeviceAlive(String string, final Device device) {
        device.setTimestamp(System.currentTimeMillis());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.instance().handleDeviceAlive(device);
            }
        });
    }

    private void handleDeviceStale(String string, final Device device) {
        this.deviceCache.remove(string);
        LOG.info("Device Slate: " + device);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.instance().handleDeviceStale(device);
            }
        });
    }

    private final class CleanStaleDevices
    implements Runnable {
        private CleanStaleDevices() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    long l = System.currentTimeMillis();
                    for (Device device : new ArrayList(DeviceDiscoveryClerk.this.deviceCache.values())) {
                        if (device.getTimestamp() + 14000L >= l || DeviceDiscoveryClerk.this.retrieveFinger(device.getKey(), device.getAddress(), device.getPort())) continue;
                        DeviceDiscoveryClerk.this.handleDeviceStale(device.getKey(), device);
                    }
                }
                catch (Throwable throwable) {
                    LOG.error("Error performing clean device stale routine", throwable);
                }
                try {
                    Thread.sleep(14000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

