/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.UITool;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import javax.swing.Icon;

public class DeviceFileTypeTreeNode
extends LibraryNode {
    private static final long serialVersionUID = 1664082200849026954L;
    private static final Icon applications = NamedMediaType.getFromMediaType(MediaType.getProgramMediaType()).getIcon();
    private static final Icon documents = NamedMediaType.getFromMediaType(MediaType.getDocumentMediaType()).getIcon();
    private static final Icon pictures = NamedMediaType.getFromMediaType(MediaType.getImageMediaType()).getIcon();
    private static final Icon videos = NamedMediaType.getFromMediaType(MediaType.getVideoMediaType()).getIcon();
    private static final Icon ringtones;
    private static final Icon audio;
    private final Device device;
    private final byte fileType;

    public DeviceFileTypeTreeNode(Device device, byte by) {
        super(UITool.getFileTypeAsString(by));
        this.device = device;
        this.fileType = by;
        this.updateText();
    }

    public Device getDevice() {
        return this.device;
    }

    public byte getFileType() {
        return this.fileType;
    }

    public Icon getIcon() {
        switch (this.fileType) {
            case 4: {
                return applications;
            }
            case 3: {
                return documents;
            }
            case 1: {
                return pictures;
            }
            case 2: {
                return videos;
            }
            case 5: {
                return ringtones;
            }
            case 0: {
                return audio;
            }
        }
        return null;
    }

    public void updateText() {
        String string = UITool.getFileTypeAsString(this.fileType) + " (" + UITool.getNumSharedFiles(this.device.getFinger(), this.fileType) + ")";
        this.setUserObject(string);
    }

    static {
        audio = NamedMediaType.getFromMediaType(MediaType.getAudioMediaType()).getIcon();
        ringtones = GUIMediator.getThemeImage("speaker");
    }
}

