/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.ScreenMetrics;
import com.limegroup.gnutella.gui.GUIMediator;
import javax.swing.Icon;

public class DeviceNode
extends LibraryNode {
    private static final long serialVersionUID = 2733848224018434257L;
    private static final Icon phonePlusDevices = GUIMediator.getThemeImage("phone_small_plus");
    private static final Icon phoneMinusDevices = GUIMediator.getThemeImage("phone_small");
    private static final Icon tabletPlusDevices = GUIMediator.getThemeImage("tablet_small_plus");
    private static final Icon tabletMinusDevices = GUIMediator.getThemeImage("tablet_small");
    private static final Icon tvPlusDevices = GUIMediator.getThemeImage("tv_small_plus");
    private static final Icon tvMinusDevices = GUIMediator.getThemeImage("tv_small");
    private final Device device;

    public DeviceNode(Device device) {
        super(device.getFinger().nickname);
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    public Icon getPlusIcon() {
        return this.getIcon(true);
    }

    public Icon getMinusIcon() {
        return this.getIcon(false);
    }

    private Icon getIcon(boolean bl) {
        switch (this.getType()) {
            case PHONE: {
                return bl ? phonePlusDevices : phoneMinusDevices;
            }
            case TABLET: {
                return bl ? tabletPlusDevices : tabletMinusDevices;
            }
            case TV: {
                return bl ? tvPlusDevices : tvMinusDevices;
            }
        }
        return bl ? phonePlusDevices : phoneMinusDevices;
    }

    private DeviceType getType() {
        ScreenMetrics screenMetrics = this.device.getFinger().deviceScreen;
        if (screenMetrics == null) {
            return DeviceType.PHONE;
        }
        if (screenMetrics.widthPixels > 1000 || screenMetrics.heightPixels > 1000) {
            return DeviceType.TABLET;
        }
        return DeviceType.PHONE;
    }

    private static enum DeviceType {
        PHONE,
        TABLET,
        TV;

    }
}

