/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import java.util.ArrayList;
import java.util.List;

public abstract class DeviceTask
implements Runnable {
    private List<OnChangedListener> listeners = new ArrayList<OnChangedListener>();
    private int progress;
    private boolean running = true;

    public List<OnChangedListener> getOnChangedListeners() {
        return this.listeners;
    }

    public void addOnChangedListener(OnChangedListener onChangedListener) {
        this.listeners.add(onChangedListener);
    }

    public int getProgress() {
        return this.progress;
    }

    protected void setProgress(int n) {
        if (n < 0 || n > 100) {
            return;
        }
        n = n < 0 ? 0 : n;
        this.progress = n = n > 100 ? 100 : n;
        this.onProgress(n);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }

    protected void onProgress(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            OnChangedListener onChangedListener = this.listeners.get(i);
            if (onChangedListener == null) continue;
            onChangedListener.onProgress(this, n);
        }
    }

    protected void onError(Throwable throwable) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            OnChangedListener onChangedListener = this.listeners.get(i);
            if (onChangedListener == null) continue;
            onChangedListener.onError(this, throwable);
        }
    }

    public static interface OnChangedListener {
        public void onProgress(DeviceTask var1, int var2);

        public void onError(DeviceTask var1, Throwable var2);
    }
}

