/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.DeviceTask;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.ProgressFileEntity;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import org.limewire.util.FilenameUtils;

public class DeviceUploadTask
extends DeviceTask {
    private final Device device;
    private final FileDescriptor[] fds;
    private final String token;
    private FileDescriptor currentFD;
    private long totalBytes;
    private long totalWritten;

    public DeviceUploadTask(Device device, FileDescriptor[] fileDescriptorArray, String string) {
        this.device = device;
        this.fds = fileDescriptorArray;
        this.token = string;
    }

    public FileDescriptor getCurrentFD() {
        return this.currentFD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block8: {
            if (!this.isRunning()) {
                return;
            }
            try {
                this.setProgress(0);
                this.totalBytes = this.getTotalBytes();
                this.totalWritten = 0L;
                for (int i = 0; i < this.fds.length; ++i) {
                    if (this.isRunning()) {
                        this.currentFD = this.fds[i];
                        final String string = FilenameUtils.getName(this.currentFD.filePath);
                        GUIMediator.safeInvokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LibraryMediator.instance().getLibrarySearch().pushStatus(String.format("%s to %s - %s", I18n.tr("Uploading"), DeviceUploadTask.this.device.getName(), string));
                            }
                        });
                        this.device.upload(new File(this.currentFD.filePath), this.token, new ProgressFileEntity.ProgressFileEntityListener(){

                            @Override
                            public void onWrite(ProgressFileEntity progressFileEntity, int n) {
                                DeviceUploadTask.this.totalWritten += n;
                                DeviceUploadTask.this.setProgress((int)(DeviceUploadTask.this.totalWritten * 100L / DeviceUploadTask.this.totalBytes));
                                if (DeviceUploadTask.this.getProgress() % 5 == 0) {
                                    GUIMediator.safeInvokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            String string = String.format("%d%% %s to %s - %s", DeviceUploadTask.this.getProgress(), I18n.tr("Uploading"), DeviceUploadTask.this.device.getName(), string);
                                            LibraryMediator.instance().getLibrarySearch().pushStatus(string);
                                        }
                                    });
                                }
                            }

                            @Override
                            public boolean isRunning() {
                                return DeviceUploadTask.this.isRunning();
                            }
                        });
                        continue;
                    }
                    break block8;
                }
                this.setProgress(100);
            }
            catch (Throwable throwable) {
                try {
                    this.onError(throwable);
                }
                catch (Throwable throwable2) {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryMediator.instance().getLibrarySearch().revertStatus();
                        }
                    });
                    throw throwable2;
                }
                GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
            this.stop();
            return;
        }
        GUIMediator.safeInvokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private long getTotalBytes() {
        long l = 0L;
        for (FileDescriptor fileDescriptor : this.fds) {
            l += fileDescriptor.fileSize;
        }
        return l;
    }
}

