/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.jpeg.JPEGImageIO;
import com.frostwire.mp3.ID3v2;
import com.frostwire.mp3.Mp3File;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LibraryCoverArt
extends JPanel
implements ThemeObserver {
    private static final long serialVersionUID = 4302859512245078593L;
    private static final Log LOG = LogFactory.getLog(LibraryCoverArt.class);
    private final BufferedImage background = new BufferedImage(350, 350, 2);
    private final Image defaultCoverArt = GUIMediator.getThemeImage("default_cover_art").getImage();
    private Image coverArtImage;
    private File file;

    public LibraryCoverArt() {
        this.setFile(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LibraryCoverArt.this.updateTheme();
            }
        });
        ThemeMediator.addThemeObserver(this);
    }

    public void setFile(final File file) {
        if (this.file != null && file != null && this.file.equals(file)) {
            return;
        }
        this.file = file;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Image image = LibraryCoverArt.this.retrieveImage(file);
                if (file != null && file.equals(LibraryCoverArt.this.file)) {
                    LibraryCoverArt.this.setPrivateImage(image);
                }
            }
        }, "Cover Art extract");
        thread.setDaemon(true);
        thread.start();
    }

    public void setDefault() {
        this.file = null;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Image image = LibraryCoverArt.this.retrieveImage(LibraryCoverArt.this.file);
                LibraryCoverArt.this.setPrivateImage(image);
            }
        }).start();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.drawImage(this.background, 0, 0, null);
    }

    private Image retrieveImage(File file) {
        if (file == null) {
            return this.defaultCoverArt;
        }
        String string = file.getAbsolutePath();
        Image image = null;
        if (string.toLowerCase().endsWith(".mp3")) {
            image = this.retrieveImageFromMP3(string);
        } else if (string.toLowerCase().endsWith(".m4a")) {
            image = this.retrieveImageFromM4A(string);
        }
        return image;
    }

    private void setPrivateImage(Image image) {
        this.coverArtImage = image;
        if (this.coverArtImage == null) {
            this.coverArtImage = this.defaultCoverArt;
        }
        Graphics2D graphics2D = this.background.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setBackground(new Color(255, 255, 255, 0));
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.drawImage(this.coverArtImage, 0, 0, this.getWidth(), this.getHeight(), null);
        graphics2D.dispose();
        this.repaint();
        this.getToolkit().sync();
    }

    private Image retrieveImageFromMP3(String string) {
        try {
            Mp3File mp3File = new Mp3File(string);
            if (mp3File.hasId3v2Tag()) {
                ID3v2 iD3v2 = mp3File.getId3v2Tag();
                byte[] byArray = iD3v2.getAlbumImage();
                try {
                    return ImageIO.read(new ByteArrayInputStream(byArray, 0, byArray.length));
                }
                catch (IIOException iIOException) {
                    return JPEGImageIO.read(new ByteArrayInputStream(byArray, 0, byArray.length));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Image retrieveImageFromM4A(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void updateTheme() {
        this.setPrivateImage(this.coverArtImage);
    }
}

