/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.LibraryDeviceTableModel;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableIconCell;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Icon;
import org.limewire.util.StringUtils;

public final class LibraryDeviceTableDataLine
extends AbstractLibraryTableDataLine<FileDescriptor> {
    static final int ICON_IDX = 0;
    private static final LimeTableColumn ICON_COLUMN = new LimeTableColumn(0, "DEVICE_TABLE_ICON", I18n.tr("Icon"), 20, true, false, false, PlayableIconCell.class);
    static final int TITLE_IDX = 1;
    private static final LimeTableColumn TITLE_COLUMN = new LimeTableColumn(1, "DEVICE_TABLE_TITLE", I18n.tr("Title"), 80, true, LibraryNameHolder.class);
    static final int ARTIST_IDX = 2;
    private static final LimeTableColumn ARTIST_COLUMN = new LimeTableColumn(2, "DEVICE_TABLE_ARTIST", I18n.tr("Artist"), 80, true, PlayableCell.class);
    static final int ALBUM_IDX = 3;
    private static final LimeTableColumn ALBUM_COLUMN = new LimeTableColumn(3, "DEVICE_TABLE_ALBUM", I18n.tr("Album"), 120, true, PlayableCell.class);
    static final int YEAR_IDX = 4;
    private static final LimeTableColumn YEAR_COLUMN = new LimeTableColumn(4, "DEVICE_TABLE_YEAR", I18n.tr("Year"), 30, false, PlayableCell.class);
    static final int SIZE_IDX = 5;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(5, "DEVICE_TABLE_SIZE", I18n.tr("Size"), 80, false, PlayableCell.class);
    static final int DATE_ADDED_IDX = 6;
    private static final LimeTableColumn DATE_ADDED_COLUMN = new LimeTableColumn(6, "DEVICE_TABLE_DATE_ADDED", I18n.tr("Date Added"), 80, true, PlayableCell.class);
    static final int DATE_MODIFIED_IDX = 7;
    private static final LimeTableColumn DATE_MODIFIED_COLUMN = new LimeTableColumn(7, "DEVICE_TABLE_DATE_MODIFIED", I18n.tr("Date Modified"), 80, false, PlayableCell.class);
    static final int NUMBER_OF_COLUMNS = 8;
    private SizeHolder sizeHolder;
    private final LibraryDeviceTableModel model;
    private final Device device;
    private boolean _iconLoaded = false;
    private boolean _iconScheduledForLoad = false;

    @Override
    public int getColumnCount() {
        return 8;
    }

    public LibraryDeviceTableDataLine(LibraryDeviceTableModel libraryDeviceTableModel) {
        this.model = libraryDeviceTableModel;
        this.device = libraryDeviceTableModel.getDevice();
    }

    @Override
    public void initialize(FileDescriptor fileDescriptor) {
        super.initialize(fileDescriptor);
        this.sizeHolder = new SizeHolder(fileDescriptor.fileSize);
    }

    @Override
    public Object getValueAt(int n) {
        boolean bl = this.isPlaying();
        switch (n) {
            case 0: {
                return new PlayableIconCell(this.getIcon(), bl);
            }
            case 1: {
                return new LibraryNameHolder(this, ((FileDescriptor)this.initializer).title, bl, true, n);
            }
            case 2: {
                return new PlayableCell(this, this.filterUnknown(((FileDescriptor)this.initializer).artist), bl, n);
            }
            case 3: {
                return new PlayableCell(this, this.filterUnknown(((FileDescriptor)this.initializer).album), bl, n);
            }
            case 4: {
                return new PlayableCell(this, this.filterUnknown(((FileDescriptor)this.initializer).year), bl, n);
            }
            case 5: {
                return new PlayableCell(this, this.sizeHolder.toString(), bl, n);
            }
            case 6: {
                return new PlayableCell(this, new Date(((FileDescriptor)this.initializer).dateAdded * 1000L), bl, n);
            }
            case 7: {
                return new PlayableCell(this, new Date(((FileDescriptor)this.initializer).dateModified * 1000L), bl, n);
            }
        }
        return null;
    }

    private boolean isPlaying() {
        if (this.initializer != null) {
            String string = this.device.getDownloadURL((FileDescriptor)this.initializer);
            return AudioPlayer.instance().isThisBeingPlayed(string);
        }
        return false;
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        switch (n) {
            case 0: {
                return ICON_COLUMN;
            }
            case 1: {
                return TITLE_COLUMN;
            }
            case 2: {
                return ARTIST_COLUMN;
            }
            case 3: {
                return ALBUM_COLUMN;
            }
            case 4: {
                return YEAR_COLUMN;
            }
            case 5: {
                return SIZE_COLUMN;
            }
            case 6: {
                return DATE_ADDED_COLUMN;
            }
            case 7: {
                return DATE_MODIFIED_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int n) {
        switch (n) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public String[] getToolTipArray(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty(((FileDescriptor)this.initializer).title, true)) {
            arrayList.add(I18n.tr("Title") + ": " + ((FileDescriptor)this.initializer).title);
        }
        if (!StringUtils.isNullOrEmpty(this.filterUnknown(((FileDescriptor)this.initializer).artist), true)) {
            arrayList.add(I18n.tr("Artist") + ": " + ((FileDescriptor)this.initializer).artist);
        }
        if (!StringUtils.isNullOrEmpty(this.filterUnknown(((FileDescriptor)this.initializer).album), true)) {
            arrayList.add(I18n.tr("Album") + ": " + ((FileDescriptor)this.initializer).album);
        }
        if (!StringUtils.isNullOrEmpty(this.filterUnknown(((FileDescriptor)this.initializer).year), true)) {
            arrayList.add(I18n.tr("Year") + ": " + ((FileDescriptor)this.initializer).year);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public File getFile() {
        return null;
    }

    private String filterUnknown(String string) {
        return string != null && string.contains("<unknown>") ? "" : string;
    }

    private Icon getIcon() {
        final File file = new File(((FileDescriptor)this.initializer).filePath);
        boolean bl = IconManager.instance().isIconForFileAvailable(file);
        if (!bl && !this._iconScheduledForLoad) {
            this._iconScheduledForLoad = true;
            BackgroundExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            IconManager.instance().getIconForFile(file);
                            LibraryDeviceTableDataLine.this._iconLoaded = true;
                            LibraryDeviceTableDataLine.this.model.refresh();
                        }
                    });
                }
            });
            return null;
        }
        if (this._iconLoaded || bl) {
            return IconManager.instance().getIconForFile(file);
        }
        return null;
    }
}

