/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.filters.TableLineFilter;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.DownloadTask;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.LibraryDeviceTableDataLine;
import com.frostwire.gui.library.LibraryDeviceTableModel;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.LibraryNameHolderEditor;
import com.frostwire.gui.library.LibraryNameHolderRenderer;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableCellRenderer;
import com.frostwire.gui.library.PlayableIconCell;
import com.frostwire.gui.library.PlayableIconCellRenderer;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.DeviceAudioSource;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.util.FilenameUtils;
import org.limewire.util.StringUtils;

public class LibraryDeviceTableMediator
extends AbstractLibraryTableMediator<LibraryDeviceTableModel, LibraryDeviceTableDataLine, FileDescriptor> {
    private static final Log LOG = LogFactory.getLog(LibraryDeviceTableMediator.class);
    public static Action LAUNCH_ACTION;
    private Action saveToAction;
    private Device device;
    private byte fileType;
    private FileDescriptorFilter FILE_DESCRIPTOR_FILTER;
    private static LibraryDeviceTableMediator INSTANCE;

    public static LibraryDeviceTableMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryDeviceTableMediator();
        }
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        this.saveToAction = new SaveToAction();
    }

    @Override
    protected void setupConstants() {
        super.setupConstants();
        this.MAIN_PANEL = new PaddedPanel();
        this.FILE_DESCRIPTOR_FILTER = new FileDescriptorFilter();
        this.DATA_MODEL = new LibraryDeviceTableModel(this.FILE_DESCRIPTOR_FILTER);
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        Action[] actionArray = new Action[]{LAUNCH_ACTION, this.saveToAction, this.OPTIONS_ACTION};
        this.BUTTON_ROW = new ButtonRow(actionArray, 0, 14);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        skinPopupMenu.add(new SkinMenuItem(LAUNCH_ACTION));
        skinPopupMenu.add(new SkinMenuItem(this.saveToAction));
        int[] nArray = this.TABLE.getSelectedRows();
        ((JPopupMenu)skinPopupMenu).addSeparator();
        LibraryDeviceTableDataLine libraryDeviceTableDataLine = (LibraryDeviceTableDataLine)((LibraryDeviceTableModel)this.DATA_MODEL).get(nArray[0]);
        skinPopupMenu.add(this.createSearchSubMenu(libraryDeviceTableDataLine));
        return skinPopupMenu;
    }

    private JMenu createSearchSubMenu(LibraryDeviceTableDataLine libraryDeviceTableDataLine) {
        String string;
        String string2;
        SkinMenu skinMenu = new SkinMenu(I18n.tr("Search"));
        if (libraryDeviceTableDataLine != null && (string2 = QueryUtils.createQueryString(string = this.buildQueryString((FileDescriptor)libraryDeviceTableDataLine.getInitializeObject()))).length() > 0) {
            skinMenu.add(new SkinMenuItem(new SearchAction(string2)));
        }
        if (skinMenu.getItemCount() == 0) {
            skinMenu.setEnabled(false);
        }
        return skinMenu;
    }

    private String buildQueryString(FileDescriptor fileDescriptor) {
        String string = FilenameUtils.getBaseName(fileDescriptor.filePath);
        if (fileDescriptor.album != null && !fileDescriptor.album.toLowerCase().contains("unknown")) {
            string = string + " " + fileDescriptor.album;
        }
        if (fileDescriptor.artist != null && !fileDescriptor.artist.toLowerCase().contains("unknown")) {
            string = string + " " + fileDescriptor.artist;
        }
        return string;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryDeviceTableMediator() {
        super("LIBRARY_DEVICE_TABLE");
        this.setMediaType(MediaType.getAnyTypeMediaType());
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setDropMode(DropMode.INSERT_ROWS);
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(PlayableIconCell.class, new PlayableIconCellRenderer());
        this.TABLE.setDefaultRenderer(PlayableCell.class, new PlayableCellRenderer());
        this.TABLE.setDefaultRenderer(LibraryNameHolder.class, new LibraryNameHolderRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new LibraryNameHolderEditor());
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.TABLE.addMouseListener(mouseInputListener);
        this.TABLE.addMouseMotionListener(mouseInputListener);
    }

    @Override
    public void handleMouseDoubleClick(MouseEvent mouseEvent) {
        super.handleMouseDoubleClick(mouseEvent);
        if (LAUNCH_ACTION.isEnabled()) {
            LAUNCH_ACTION.actionPerformed(null);
        } else if (this.saveToAction.isEnabled()) {
            this.saveToAction.actionPerformed(null);
        }
    }

    void updateTableFiles(final Device device, final byte by) {
        this.clearTable();
        this.device = device;
        this.fileType = by;
        ((LibraryDeviceTableModel)this.DATA_MODEL).setDevice(device);
        BackgroundExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                List<FileDescriptor> list = device.browse(by);
                if (!LibraryDeviceTableMediator.this.device.equals(device) || LibraryDeviceTableMediator.this.fileType != by) {
                    return;
                }
                for (int i = 0; i < list.size(); ++i) {
                    LibraryDeviceTableMediator.this.addUnsorted(list.get(i));
                }
                LibraryDeviceTableMediator.this.forceResort();
                LibraryMediator.instance().getLibraryExplorer().executePendingRunnables();
            }
        });
    }

    File getFile(int n) {
        return ((LibraryDeviceTableModel)this.DATA_MODEL).getFile(n);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    LibraryDeviceTableDataLine[] getSelectedLibraryLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        LibraryDeviceTableDataLine[] libraryDeviceTableDataLineArray = new LibraryDeviceTableDataLine[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            libraryDeviceTableDataLineArray[i] = (LibraryDeviceTableDataLine)((LibraryDeviceTableModel)this.DATA_MODEL).get(nArray[i]);
        }
        return libraryDeviceTableDataLineArray;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    @Override
    public void handleActionKey() {
        if (this.fileType == 0 || this.fileType == 5) {
            this.playSong();
        }
    }

    private void playSong() {
        LibraryDeviceTableDataLine libraryDeviceTableDataLine = (LibraryDeviceTableDataLine)((LibraryDeviceTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (libraryDeviceTableDataLine == null) {
            return;
        }
        try {
            String string = this.device.getDownloadURL((FileDescriptor)libraryDeviceTableDataLine.getInitializeObject());
            DeviceAudioSource deviceAudioSource = new DeviceAudioSource(string, this.device, (FileDescriptor)libraryDeviceTableDataLine.getInitializeObject());
            if (AudioPlayer.isPlayableFile(deviceAudioSource)) {
                AudioPlayer.instance().asyncLoadSong(deviceAudioSource, true, true, null, this.getFileView());
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error loading the streaming", throwable);
        }
    }

    @Override
    public void handleSelection(int n) {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            this.handleNoSelection();
            return;
        }
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        FileDescriptor fileDescriptor = (FileDescriptor)((LibraryDeviceTableDataLine)((LibraryDeviceTableModel)this.DATA_MODEL).get(nArray[0])).getInitializeObject();
        LAUNCH_ACTION.setEnabled(nArray.length == 1 && (this.fileType == 0 || this.fileType == 5) && AudioPlayer.isPlayableFile(fileDescriptor.filePath));
        this.saveToAction.setEnabled(true);
        if (nArray.length == 1) {
            LibraryMediator.instance().getLibraryCoverArt().setDefault();
        }
    }

    @Override
    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        this.saveToAction.setEnabled(false);
    }

    public void setPlayerEnabled(boolean bl) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    private void downloadSelectedItems() {
        List list = this.getSelectedLines();
        ArrayList arrayList = new ArrayList(list.size());
        for (AbstractLibraryTableDataLine abstractLibraryTableDataLine : list) {
            arrayList.add(abstractLibraryTableDataLine.getInitializeObject());
        }
        ThreadExecutor.startThread(new DownloadTask(LibrarySettings.LIBRARY_FROM_DEVICE_DATA_DIR_SETTING.getValue(), this.device, arrayList.toArray(new FileDescriptor[0])), "DownloadFromDevice");
    }

    @Override
    public List<AudioSource> getFileView() {
        int n = ((LibraryDeviceTableModel)this.DATA_MODEL).getRowCount();
        ArrayList<AudioSource> arrayList = new ArrayList<AudioSource>(n);
        for (int i = 0; i < n; ++i) {
            try {
                String string = this.device.getDownloadURL((FileDescriptor)((LibraryDeviceTableDataLine)((LibraryDeviceTableModel)this.DATA_MODEL).get(i)).getInitializeObject());
                arrayList.add(new DeviceAudioSource(string, this.device, (FileDescriptor)((LibraryDeviceTableDataLine)((LibraryDeviceTableModel)this.DATA_MODEL).get(i)).getInitializeObject()));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    protected void sortAndMaintainSelection(int n) {
        super.sortAndMaintainSelection(n);
        this.resetAudioPlayerFileView();
    }

    private void resetAudioPlayerFileView() {
    }

    @Override
    protected AudioSource createAudioSource(LibraryDeviceTableDataLine libraryDeviceTableDataLine) {
        return null;
    }

    public void filter(String string) {
        this.FILE_DESCRIPTOR_FILTER.setQuery(string);
        ((LibraryDeviceTableModel)this.DATA_MODEL).filtersChanged();
    }

    @Override
    public void clearTable() {
        super.clearTable();
        this.FILE_DESCRIPTOR_FILTER.setQuery(null);
    }

    class FileDescriptorFilter
    implements TableLineFilter<LibraryDeviceTableDataLine> {
        private String query;
        private Set<String> tokens;

        FileDescriptorFilter() {
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String string) {
            if (StringUtils.isNullOrEmpty(string, true) || string.equals(".")) {
                this.query = null;
                this.tokens = null;
            } else {
                this.query = StringUtils.removeDoubleSpaces(string);
                this.tokens = new HashSet<String>(Arrays.asList(this.query.toLowerCase().split(" ")));
            }
        }

        @Override
        public boolean allow(LibraryDeviceTableDataLine libraryDeviceTableDataLine) {
            if (this.tokens == null) {
                return true;
            }
            FileDescriptor fileDescriptor = (FileDescriptor)libraryDeviceTableDataLine.getInitializeObject();
            String string = (fileDescriptor.title + " " + fileDescriptor.artist + " " + fileDescriptor.album + " " + fileDescriptor.year).toLowerCase();
            boolean bl = true;
            for (String string2 : this.tokens) {
                if (string.contains(string2)) continue;
                bl = false;
                break;
            }
            return bl;
        }
    }

    private final class SaveToAction
    extends AbstractAction {
        private static final long serialVersionUID = 8400749433148927596L;

        public SaveToAction() {
            this.putValue("Name", I18n.tr("Save"));
            this.putValue("LimeShortName", I18n.tr("Save"));
            this.putValue("ShortDescription", I18n.tr("Save Selected Files To Folder"));
            this.putValue("LimeIconName", "DEVICE_SAVE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryDeviceTableMediator.this.downloadSelectedItems();
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392591L;

        public LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryDeviceTableMediator.this.playSong();
        }
    }
}

