/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.filters.TableLineFilter;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.LibraryDeviceTableDataLine;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.HashBasedDataLineModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class LibraryDeviceTableModel
extends HashBasedDataLineModel<LibraryDeviceTableDataLine, FileDescriptor> {
    private static final long serialVersionUID = 2859783399965055446L;
    private Device device;
    private final TableLineFilter<LibraryDeviceTableDataLine> FILTER;
    protected final List<LibraryDeviceTableDataLine> HIDDEN;

    LibraryDeviceTableModel(TableLineFilter<LibraryDeviceTableDataLine> tableLineFilter) {
        super(LibraryDeviceTableDataLine.class);
        if (tableLineFilter == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = tableLineFilter;
        this.HIDDEN = new ArrayList<LibraryDeviceTableDataLine>();
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public LibraryDeviceTableDataLine createDataLine() {
        return new LibraryDeviceTableDataLine(this);
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    @Override
    public int add(LibraryDeviceTableDataLine libraryDeviceTableDataLine, int n) {
        if (!this.allow(libraryDeviceTableDataLine)) {
            this.HIDDEN.add(libraryDeviceTableDataLine);
            return -1;
        }
        return super.add(libraryDeviceTableDataLine, n);
    }

    void reinitialize(File file) {
        if (this.contains(file)) {
            // empty if block
        }
    }

    void reinitialize(File file, File file2) {
        if (this.contains(file)) {
            // empty if block
        }
    }

    File getFile(int n) {
        return new File(((FileDescriptor)((LibraryDeviceTableDataLine)this.get(n)).getInitializeObject()).filePath);
    }

    @Override
    public void clear() {
        super.clear();
        this.HIDDEN.clear();
    }

    private boolean allow(LibraryDeviceTableDataLine libraryDeviceTableDataLine) {
        return this.FILTER.allow(libraryDeviceTableDataLine);
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    private void rebuild() {
        int n;
        ArrayList arrayList = new ArrayList(this._list);
        ArrayList<LibraryDeviceTableDataLine> arrayList2 = new ArrayList<LibraryDeviceTableDataLine>(this.HIDDEN);
        this.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            this.addSorted((DataLine)arrayList.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            LibraryDeviceTableDataLine libraryDeviceTableDataLine = (LibraryDeviceTableDataLine)arrayList2.get(n);
            this.addSorted(libraryDeviceTableDataLine);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }
}

