/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.AbstractLibraryListPanel;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.DeviceFileTypeTreeNode;
import com.frostwire.gui.library.DeviceNode;
import com.frostwire.gui.library.DevicesNode;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.InternetRadioDirectoryHolder;
import com.frostwire.gui.library.LibraryFilesTransferHandler;
import com.frostwire.gui.library.LibraryIconTree;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.NodeRenderer;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.library.TextNode;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.frostwire.gui.library.TreeMouseObserver;
import com.frostwire.gui.library.UITool;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryExplorer
extends AbstractLibraryListPanel {
    private static final long serialVersionUID = -5354238047697767760L;
    private DefaultTreeModel model;
    private JTree tree;
    private TextNode root;
    private DevicesNode devicesNode;
    private Action refreshAction = new RefreshAction();
    private Action exploreAction = new ExploreAction();
    private TreeSelectionListener treeSelectionListener;

    public LibraryExplorer() {
        this.setupUI();
    }

    @Override
    public void refresh() {
        this.tree.repaint();
    }

    public void handleDeviceNew(Device device) {
        DeviceNode deviceNode = new DeviceNode(device);
        this.devicesNode.add(deviceNode);
        this.model.insertNodeInto(deviceNode, this.devicesNode, this.devicesNode.getChildCount() - 1);
        this.tree.expandPath(new TreePath(this.devicesNode.getPath()));
        System.out.println("New Device: " + device);
        this.refreshDeviceNode(device);
    }

    public void handleDeviceAlive(Device device) {
        this.refreshDeviceNode(device);
    }

    public void handleDeviceStale(Device device) {
        DeviceNode deviceNode = this.findNode(device);
        if (deviceNode != null) {
            this.model.removeNodeFromParent(deviceNode);
            Device device2 = this.getSelectedDeviceFiles();
            DirectoryHolder directoryHolder = this.getSelectedDirectoryHolder();
            if (device2 == null && directoryHolder == null) {
                LibraryMediator.instance().clearLibraryTable();
            }
        }
    }

    public void refreshSelection(boolean bl) {
        Object object;
        LibraryNode libraryNode = (LibraryNode)this.tree.getLastSelectedPathComponent();
        if (libraryNode == null) {
            return;
        }
        if (libraryNode instanceof DeviceFileTypeTreeNode) {
            object = (DeviceFileTypeTreeNode)libraryNode;
            LibraryMediator.instance().updateTableFiles(((DeviceFileTypeTreeNode)object).getDevice(), ((DeviceFileTypeTreeNode)object).getFileType());
        } else {
            LibraryMediator.instance().clearLibraryTable();
        }
        object = this.getSelectedDirectoryHolder();
        if (object instanceof StarredDirectoryHolder) {
            Playlist playlist = LibraryMediator.getLibrary().getStarredPlaylist();
            LibraryMediator.instance().updateTableItems(playlist);
            String string = LibraryUtils.getPlaylistDurationInDDHHMMSS(playlist) + ", " + playlist.getItems().size() + " " + I18n.tr("tracks");
            LibraryMediator.instance().getLibrarySearch().setStatus(string);
        } else if (object instanceof InternetRadioDirectoryHolder) {
            List<InternetRadioStation> list = LibraryMediator.getLibrary().getInternetRadioStations();
            LibraryMediator.instance().showInternetRadioStations(list);
        } else if (object instanceof TorrentDirectoryHolder) {
            LibraryMediator.instance().updateTableFiles((DirectoryHolder)object);
        } else if (object instanceof SavedFilesDirectoryHolder) {
            if (bl) {
                ((SavedFilesDirectoryHolder)object).clearCache();
            }
            LibraryMediator.instance().updateTableFiles((DirectoryHolder)object);
        } else if (object instanceof MediaTypeSavedFilesDirectoryHolder) {
            MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirectoryHolder = (MediaTypeSavedFilesDirectoryHolder)object;
            if (bl) {
                mediaTypeSavedFilesDirectoryHolder.clearCache();
            }
            LibraryMediator.instance().updateTableFiles((DirectoryHolder)object);
            BackgroundExecutorService.schedule(new SearchByMediaTypeRunnable(mediaTypeSavedFilesDirectoryHolder));
        }
        LibraryMediator.instance().getLibrarySearch().clear();
        LibraryMediator.instance().getLibrarySearch().setSearchPrompt(libraryNode.toString());
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        GUIMediator.addRefreshListener(this);
        this.setupModel();
        this.setupTree();
        this.add(new JScrollPane(this.tree));
    }

    private void setupModel() {
        this.root = new TextNode("root");
        this.addNodesPerMediaType(this.root);
        this.root.add(new DirectoryHolderNode(new InternetRadioDirectoryHolder()));
        this.root.add(new DirectoryHolderNode(new StarredDirectoryHolder()));
        this.root.add(new DirectoryHolderNode(new TorrentDirectoryHolder()));
        this.root.add(new DirectoryHolderNode(new SavedFilesDirectoryHolder(SharingSettings.TORRENT_DATA_DIR_SETTING, I18n.tr("Finished Downloads"))));
        this.devicesNode = new DevicesNode(I18n.tr("Devices"));
        this.root.add(this.devicesNode);
        this.model = new DefaultTreeModel(this.root);
    }

    private void setupTree() {
        this.tree = new LibraryIconTree(this.model);
        this.tree.setRowHeight(TableSettings.DEFAULT_TABLE_ROW_HEIGHT.getValue());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new NodeRenderer());
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new LibraryFilesTransferHandler(this.tree));
        ((BasicTreeUI)this.tree.getUI()).setExpandedIcon(null);
        ((BasicTreeUI)this.tree.getUI()).setCollapsedIcon(null);
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        skinPopupMenu.add(new SkinMenuItem(this.refreshAction));
        skinPopupMenu.add(new SkinMenuItem(this.exploreAction));
        skinPopupMenu.add(new SkinMenuItem(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", I18n.tr("Configure Options"), I18n.tr("You can configure the FrostWire's Options."))));
        this.tree.addMouseListener(new DefaultMouseListener(new TreeMouseObserver(this.tree, skinPopupMenu)));
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (LibraryUtils.isRefreshKeyEvent(keyEvent)) {
                    LibraryExplorer.this.refreshSelection(true);
                }
            }
        });
        this.treeSelectionListener = new LibraryExplorerTreeSelectionListener();
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    private void addNodesPerMediaType(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addNodePerMediaType(defaultMutableTreeNode, NamedMediaType.getFromMediaType(MediaType.getAudioMediaType()));
        this.addNodePerMediaType(defaultMutableTreeNode, NamedMediaType.getFromMediaType(MediaType.getVideoMediaType()));
        this.addNodePerMediaType(defaultMutableTreeNode, NamedMediaType.getFromMediaType(MediaType.getImageMediaType()));
        this.addNodePerMediaType(defaultMutableTreeNode, NamedMediaType.getFromMediaType(MediaType.getProgramMediaType()));
        this.addNodePerMediaType(defaultMutableTreeNode, NamedMediaType.getFromMediaType(MediaType.getDocumentMediaType()));
    }

    private void addNodePerMediaType(DefaultMutableTreeNode defaultMutableTreeNode, NamedMediaType namedMediaType) {
        MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirectoryHolder = new MediaTypeSavedFilesDirectoryHolder(namedMediaType.getMediaType());
        DirectoryHolderNode directoryHolderNode = new DirectoryHolderNode(mediaTypeSavedFilesDirectoryHolder);
        defaultMutableTreeNode.add(directoryHolderNode);
    }

    private DeviceNode findNode(Device device) {
        DeviceNode deviceNode = null;
        for (int i = 0; i < this.devicesNode.getChildCount() && deviceNode == null; ++i) {
            TreeNode treeNode = this.devicesNode.getChildAt(i);
            if (!(treeNode instanceof DeviceNode) || !((DeviceNode)treeNode).getDevice().equals(device)) continue;
            deviceNode = (DeviceNode)treeNode;
        }
        return deviceNode;
    }

    private DeviceFileTypeTreeNode findNode(DeviceNode deviceNode, byte by) {
        DeviceFileTypeTreeNode deviceFileTypeTreeNode = null;
        for (int i = 0; i < deviceNode.getChildCount() && deviceFileTypeTreeNode == null; ++i) {
            TreeNode treeNode = deviceNode.getChildAt(i);
            if (!(treeNode instanceof DeviceFileTypeTreeNode) || ((DeviceFileTypeTreeNode)treeNode).getFileType() != by) continue;
            deviceFileTypeTreeNode = (DeviceFileTypeTreeNode)treeNode;
        }
        return deviceFileTypeTreeNode;
    }

    private void refreshDeviceNode(Device device) {
        DeviceNode deviceNode = this.findNode(device);
        if (deviceNode == null) {
            return;
        }
        this.refreshDeviceFileTypeNode(deviceNode, (byte)0);
        this.refreshDeviceFileTypeNode(deviceNode, (byte)1);
        this.refreshDeviceFileTypeNode(deviceNode, (byte)2);
        this.refreshDeviceFileTypeNode(deviceNode, (byte)3);
        this.refreshDeviceFileTypeNode(deviceNode, (byte)4);
        this.refreshDeviceFileTypeNode(deviceNode, (byte)5);
    }

    private void refreshDeviceFileTypeNode(DeviceNode deviceNode, byte by) {
        DeviceFileTypeTreeNode deviceFileTypeTreeNode = this.findNode(deviceNode, by);
        if (deviceFileTypeTreeNode == null) {
            if (UITool.getNumSharedFiles(deviceNode.getDevice().getFinger(), by) > 0) {
                deviceFileTypeTreeNode = new DeviceFileTypeTreeNode(deviceNode.getDevice(), by);
                this.model.insertNodeInto(deviceFileTypeTreeNode, deviceNode, 0);
                this.tree.expandPath(new TreePath(deviceNode.getPath()));
            }
        } else if (UITool.getNumSharedFiles(deviceNode.getDevice().getFinger(), by) == 0) {
            this.model.removeNodeFromParent(deviceFileTypeTreeNode);
        } else {
            deviceFileTypeTreeNode.updateText();
        }
    }

    public DirectoryHolder getSelectedDirectoryHolder() {
        LibraryNode libraryNode = (LibraryNode)this.tree.getLastSelectedPathComponent();
        return libraryNode != null && libraryNode instanceof DirectoryHolderNode ? ((DirectoryHolderNode)libraryNode).getDirectoryHolder() : null;
    }

    public Device getSelectedDeviceFiles() {
        LibraryNode libraryNode = (LibraryNode)this.tree.getLastSelectedPathComponent();
        return libraryNode != null && libraryNode instanceof DeviceFileTypeTreeNode ? ((DeviceFileTypeTreeNode)libraryNode).getDevice() : null;
    }

    public Dimension getRowDimension() {
        Rectangle rectangle = this.tree.getUI().getPathBounds(this.tree, new TreePath(this.root));
        return rectangle.getSize();
    }

    public int getRowsCount() {
        return this.tree.getUI().getRowCount(this.tree);
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public void refreshSelection() {
        this.refreshSelection(false);
    }

    public void selectAudio() {
        LibraryNode libraryNode = (LibraryNode)this.tree.getLastSelectedPathComponent();
        if (libraryNode != null && libraryNode instanceof DirectoryHolderNode && ((DirectoryHolderNode)libraryNode).getDirectoryHolder() instanceof MediaTypeSavedFilesDirectoryHolder && ((MediaTypeSavedFilesDirectoryHolder)((DirectoryHolderNode)libraryNode).getDirectoryHolder()).getMediaType().equals(MediaType.getAudioMediaType())) {
            try {
                this.treeSelectionListener.valueChanged(null);
            }
            catch (Exception exception) {
                System.out.println();
            }
            return;
        }
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DirectoryHolder directoryHolder;
            LibraryNode libraryNode2 = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode2 instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode2).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder) || !((MediaTypeSavedFilesDirectoryHolder)directoryHolder).getMediaType().equals(MediaType.getAudioMediaType())) continue;
            this.tree.setSelectionPath(new TreePath(libraryNode2.getPath()));
            this.tree.scrollPathToVisible(new TreePath(libraryNode2.getPath()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectStarred() {
        try {
            if (this.selectionListenerForSameItem(StarredDirectoryHolder.class)) {
                return;
            }
            Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DirectoryHolder directoryHolder;
                LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
                if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof StarredDirectoryHolder)) continue;
                this.tree.setSelectionPath(new TreePath(libraryNode.getPath()));
                this.tree.scrollPathToVisible(new TreePath(libraryNode.getPath()));
                return;
            }
        }
        finally {
            this.executePendingRunnables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFinishedDownloads() {
        try {
            if (this.selectionListenerForSameItem(StarredDirectoryHolder.class)) {
                return;
            }
            Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DirectoryHolder directoryHolder;
                LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
                if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof SavedFilesDirectoryHolder)) continue;
                this.tree.setSelectionPath(new TreePath(libraryNode.getPath()));
                this.tree.scrollPathToVisible(new TreePath(libraryNode.getPath()));
                return;
            }
        }
        finally {
            this.executePendingRunnables();
        }
    }

    public boolean selectionListenerForSameItem(Class<?> clazz) {
        LibraryNode libraryNode = (LibraryNode)this.tree.getLastSelectedPathComponent();
        if (libraryNode != null && libraryNode instanceof DirectoryHolderNode && clazz.isInstance(((DirectoryHolderNode)libraryNode).getDirectoryHolder())) {
            try {
                this.treeSelectionListener.valueChanged(null);
            }
            catch (Exception exception) {
                System.out.println();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectRadio() {
        try {
            if (this.selectionListenerForSameItem(InternetRadioDirectoryHolder.class)) {
                return;
            }
            Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DirectoryHolder directoryHolder;
                LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
                if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof InternetRadioDirectoryHolder)) continue;
                this.tree.setSelectionPath(new TreePath(libraryNode.getPath()));
                this.tree.scrollPathToVisible(new TreePath(libraryNode.getPath()));
                return;
            }
        }
        finally {
            this.executePendingRunnables();
        }
    }

    public List<MediaTypeSavedFilesDirectoryHolder> getMediaTypeSavedFilesDirectoryHolders() {
        ArrayList<MediaTypeSavedFilesDirectoryHolder> arrayList = new ArrayList<MediaTypeSavedFilesDirectoryHolder>();
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DirectoryHolder directoryHolder;
            LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder)) continue;
            arrayList.add((MediaTypeSavedFilesDirectoryHolder)directoryHolder);
        }
        return arrayList;
    }

    public void clearDirectoryHolderCaches() {
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode instanceof DirectoryHolderNode)) continue;
            DirectoryHolder directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder();
            if (directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder) {
                ((MediaTypeSavedFilesDirectoryHolder)directoryHolder).clearCache();
                continue;
            }
            if (!(directoryHolder instanceof SavedFilesDirectoryHolder)) continue;
            ((SavedFilesDirectoryHolder)directoryHolder).clearCache();
        }
        this.refreshSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectDeviceFileType(Device device, byte by) {
        Object object = null;
        if (this.tree.getSelectionPath() == null) {
            this.tree.setSelectionRow(0);
        }
        object = this.tree.getSelectionPath().getLastPathComponent();
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            final LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode instanceof DeviceFileTypeTreeNode)) continue;
            Device device2 = ((DeviceFileTypeTreeNode)libraryNode).getDevice();
            byte by2 = ((DeviceFileTypeTreeNode)libraryNode).getFileType();
            if (!device2.equals(device) || by2 != by) continue;
            this.tree.setSelectionPath(new TreePath(libraryNode.getPath()));
            this.enqueueRunnable(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryExplorer.this.tree.scrollPathToVisible(new TreePath(libraryNode.getPath()));
                        }
                    });
                }
            });
            if (object != null && object.equals(libraryNode)) {
                this.executePendingRunnables();
            }
            return;
        }
    }

    private class ExploreAction
    extends AbstractAction {
        private static final long serialVersionUID = 2767346265174793478L;

        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Library Folder"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryHolder directoryHolder = LibraryExplorer.this.getSelectedDirectoryHolder();
            if (directoryHolder == null) {
                return;
            }
            File file = directoryHolder.getDirectory();
            if (file != null) {
                GUIMediator.launchExplorer(file);
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 412879927060208864L;

        public RefreshAction() {
            this.putValue("Name", I18n.tr("Refresh"));
            this.putValue("ShortDescription", I18n.tr("Refresh selected"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryHolder directoryHolder = LibraryExplorer.this.getSelectedDirectoryHolder();
            if (directoryHolder == null) {
                return;
            }
            LibraryExplorer.this.refreshSelection(true);
        }
    }

    private final class SearchByMediaTypeRunnable
    implements Runnable {
        private final MediaTypeSavedFilesDirectoryHolder _mtsfdh;

        public SearchByMediaTypeRunnable(MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirectoryHolder) {
            this._mtsfdh = mediaTypeSavedFilesDirectoryHolder;
        }

        @Override
        public void run() {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().clearLibraryTable();
                }
            });
            final ArrayList<File> arrayList = new ArrayList<File>(this._mtsfdh.getCache());
            if (arrayList.size() == 0) {
                File file = SharingSettings.TORRENT_DATA_DIR_SETTING.getValue();
                Set<File> set = TorrentUtil.getIgnorableFiles();
                HashSet<File> hashSet = new HashSet<File>(LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue());
                hashSet.removeAll(LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                for (File file2 : hashSet) {
                    if (file2 == null) continue;
                    if (file2.equals(file)) {
                        this.search(file2, set, LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                        continue;
                    }
                    if (file2.equals(LibrarySettings.USER_MUSIC_FOLDER) && !this._mtsfdh.getMediaType().equals(MediaType.getAudioMediaType())) continue;
                    this.search(file2, new HashSet<File>(), LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                }
            } else {
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LibraryMediator.instance().addFilesToLibraryTable(arrayList);
                    }
                });
            }
            LibraryExplorer.this.executePendingRunnables();
        }

        private void search(File file, Set<File> set, Set<File> set2) {
            if (file == null || !file.isDirectory() || !file.exists()) {
                return;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            final ArrayList<File> arrayList2 = new ArrayList<File>();
            for (File file2 : file.listFiles()) {
                DirectoryHolder directoryHolder = LibraryExplorer.this.getSelectedDirectoryHolder();
                if (!this._mtsfdh.equals(directoryHolder)) {
                    return;
                }
                if (set.contains(file2) || file2.isHidden()) continue;
                if (file2.isDirectory() && !set2.contains(file2)) {
                    arrayList.add(file2);
                    continue;
                }
                if (!this._mtsfdh.accept(file2)) continue;
                arrayList2.add(file2);
            }
            this._mtsfdh.addToCache(arrayList2);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().addFilesToLibraryTable(arrayList2);
                }
            };
            GUIMediator.safeInvokeLater(runnable);
            for (File file3 : arrayList) {
                this.search(file3, set, set2);
            }
        }
    }

    private class LibraryExplorerTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryExplorerTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeNode treeNode = (TreeNode)LibraryExplorer.this.tree.getLastSelectedPathComponent();
            if (treeNode == null) {
                return;
            }
            LibraryMediator.instance().getLibraryPlaylists().clearSelection();
            LibraryExplorer.this.refreshSelection(false);
        }
    }
}

