/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryFilesTableModel;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableIconCell;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.Icon;

public final class LibraryFilesTableDataLine
extends AbstractLibraryTableDataLine<File> {
    static final int ICON_IDX = 0;
    static final int NAME_IDX = 1;
    static final int SIZE_IDX = 2;
    static final int TYPE_IDX = 3;
    static final int PATH_IDX = 4;
    static final int MODIFICATION_TIME_IDX = 5;
    private static LimeTableColumn[] ltColumns;
    private String _name;
    private String _type;
    private long _size;
    private SizeHolder _sizeHolder;
    private FileDesc _fileDesc;
    private String _path;
    private final LibraryFilesTableModel _model;
    private boolean _iconLoaded = false;
    private boolean _iconScheduledForLoad = false;

    public LibraryFilesTableDataLine(LibraryFilesTableModel libraryFilesTableModel) {
        this._model = libraryFilesTableModel;
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    @Override
    public int getColumnCount() {
        return this.getLimeTableColumns().length;
    }

    @Override
    public void initialize(File file) {
        super.initialize(file);
        String string = file.getPath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._name = ((File)this.initializer).getName();
        this._type = "";
        if (!file.isDirectory()) {
            int n = this._name.lastIndexOf(".");
            int n2 = string.lastIndexOf(File.separator);
            this._path = string.substring(0, n2);
            if (n != -1 && n != 0) {
                this._type = this._name.substring(n + 1);
                this._name = this._name.substring(0, n);
            }
        } else {
            this._path = string;
        }
        if (((File)this.initializer).isFile()) {
            long l = this._size;
            this._size = ((File)this.initializer).length();
            if (l != this._size) {
                this._sizeHolder = new SizeHolder(this._size);
            }
        } else if (((File)this.initializer).isDirectory()) {
            this._sizeHolder = new SizeHolder(0L);
        }
    }

    void setFileDesc(FileDesc fileDesc) {
        this.initialize(fileDesc.getFile());
        this._fileDesc = fileDesc;
    }

    @Override
    public File getFile() {
        return (File)this.initializer;
    }

    @Override
    public Object getValueAt(int n) {
        boolean bl = this.isPlaying();
        switch (n) {
            case 0: {
                return new PlayableIconCell(this.getIcon(), bl);
            }
            case 1: {
                return new LibraryNameHolder(this, this._name, bl, true, n);
            }
            case 2: {
                return new PlayableCell(this, this._sizeHolder, bl, n);
            }
            case 3: {
                return new PlayableCell(this, this._type, bl, n);
            }
            case 4: {
                return new PlayableCell(this, this._path, bl, n);
            }
            case 5: {
                if (this._fileDesc != null) {
                    return new PlayableCell(this, new Date(this._fileDesc.lastModified()), bl, n);
                }
                return new PlayableCell(this, new Date(((File)this.initializer).lastModified()), bl, n);
            }
        }
        return null;
    }

    private boolean isPlaying() {
        if (this.initializer != null) {
            return AudioPlayer.instance().isThisBeingPlayed((File)this.initializer);
        }
        return false;
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        return this.getLimeTableColumns()[n];
    }

    @Override
    public boolean isClippable(int n) {
        switch (n) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 1;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public String[] getToolTipArray(int n) {
        return new String[]{((File)this.getInitializeObject()).getAbsolutePath()};
    }

    private LimeTableColumn[] getLimeTableColumns() {
        if (ltColumns == null) {
            LimeTableColumn[] limeTableColumnArray = new LimeTableColumn[]{new LimeTableColumn(0, "LIBRARY_TABLE_ICON", I18n.tr("Icon"), GUIMediator.getThemeImage("question_mark"), 18, true, PlayableIconCell.class), new LimeTableColumn(1, "LIBRARY_TABLE_NAME", I18n.tr("Name"), 239, true, LibraryNameHolder.class), new LimeTableColumn(2, "LIBRARY_TABLE_SIZE", I18n.tr("Size"), 62, true, PlayableCell.class), new LimeTableColumn(3, "LIBRARY_TABLE_TYPE", I18n.tr("Type"), 48, true, PlayableCell.class), new LimeTableColumn(4, "LIBRARY_TABLE_PATH", I18n.tr("Path"), 108, true, PlayableCell.class), new LimeTableColumn(5, "LIBRARY_TABLE_MODIFICATION_TIME", I18n.tr("Last Modified"), 20, false, PlayableCell.class)};
            ltColumns = limeTableColumnArray;
        }
        return ltColumns;
    }

    private Icon getIcon() {
        boolean bl = IconManager.instance().isIconForFileAvailable((File)this.initializer);
        if (!bl && !this._iconScheduledForLoad) {
            this._iconScheduledForLoad = true;
            BackgroundExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            IconManager.instance().getIconForFile((File)LibraryFilesTableDataLine.this.initializer);
                            LibraryFilesTableDataLine.this._iconLoaded = true;
                            LibraryFilesTableDataLine.this._model.refresh();
                        }
                    });
                }
            });
            return null;
        }
        if (this._iconLoaded || bl) {
            return IconManager.instance().getIconForFile((File)this.initializer);
        }
        return null;
    }
}

