/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.bittorrent.CreateTorrentDialog;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryFilesTableDataLine;
import com.frostwire.gui.library.LibraryFilesTableModel;
import com.frostwire.gui.library.LibraryFilesTableTransferHandler;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.LibraryNameHolderEditor;
import com.frostwire.gui.library.LibraryNameHolderRenderer;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableCellRenderer;
import com.frostwire.gui.library.PlayableIconCell;
import com.frostwire.gui.library.PlayableIconCellRenderer;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.limewire.collection.CollectionUtils;
import org.limewire.collection.Tuple;
import org.limewire.util.FileUtils;
import org.limewire.util.FilenameUtils;
import org.limewire.util.OSUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

final class LibraryFilesTableMediator
extends AbstractLibraryTableMediator<LibraryFilesTableModel, LibraryFilesTableDataLine, File> {
    public static Action LAUNCH_ACTION;
    public static Action LAUNCH_OS_ACTION;
    public static Action OPEN_IN_FOLDER_ACTION;
    public static Action CREATE_TORRENT_ACTION;
    public static Action DELETE_ACTION;
    public static Action RENAME_ACTION;
    public static Action SEND_TO_ITUNES_ACTION;
    private static LibraryFilesTableMediator INSTANCE;

    public static LibraryFilesTableMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryFilesTableMediator();
        }
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        LAUNCH_OS_ACTION = new LaunchOSAction();
        OPEN_IN_FOLDER_ACTION = new OpenInFolderAction();
        CREATE_TORRENT_ACTION = new CreateTorrentAction();
        DELETE_ACTION = new RemoveAction();
        RENAME_ACTION = new RenameAction();
        SEND_TO_ITUNES_ACTION = new SendAudioFilesToiTunes();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (LibraryUtils.isRefreshKeyEvent(keyEvent)) {
                    LibraryMediator.instance().getLibraryExplorer().refreshSelection(true);
                }
            }
        });
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(LibraryNameHolder.class, new LibraryNameHolderRenderer());
        this.TABLE.setDefaultRenderer(PlayableIconCell.class, new PlayableIconCellRenderer());
        this.TABLE.setDefaultRenderer(PlayableCell.class, new PlayableCellRenderer());
    }

    @Override
    protected void setupConstants() {
        super.setupConstants();
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new LibraryFilesTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryFilesTableModel)this.DATA_MODEL).setTable(this.TABLE);
        Action[] actionArray = new Action[]{LAUNCH_ACTION, OPEN_IN_FOLDER_ACTION, this.SEND_TO_FRIEND_ACTION, DELETE_ACTION, this.OPTIONS_ACTION};
        this.BUTTON_ROW = new ButtonRow(actionArray, 0, 14);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        skinPopupMenu.add(new SkinMenuItem(LAUNCH_ACTION));
        if (this.getMediaType().equals(MediaType.getAudioMediaType())) {
            skinPopupMenu.add(new SkinMenuItem(LAUNCH_OS_ACTION));
        }
        if (this.hasExploreAction()) {
            skinPopupMenu.add(new SkinMenuItem(OPEN_IN_FOLDER_ACTION));
        }
        skinPopupMenu.add(new SkinMenuItem(CREATE_TORRENT_ACTION));
        if (this.areAllSelectedFilesPlayable()) {
            skinPopupMenu.add(this.createAddToPlaylistSubMenu());
        }
        skinPopupMenu.add(new SkinMenuItem(this.SEND_TO_FRIEND_ACTION));
        skinPopupMenu.add(new SkinMenuItem(SEND_TO_ITUNES_ACTION));
        ((JPopupMenu)skinPopupMenu).addSeparator();
        skinPopupMenu.add(new SkinMenuItem(DELETE_ACTION));
        skinPopupMenu.add(new SkinMenuItem(RENAME_ACTION));
        ((JPopupMenu)skinPopupMenu).addSeparator();
        int[] nArray = this.TABLE.getSelectedRows();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            File file = ((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(nArray[i])).getFile();
            if (file.isDirectory()) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (bl && bl2) break;
        }
        if (bl) {
            DELETE_ACTION.setEnabled(true);
            RENAME_ACTION.setEnabled(false);
        } else {
            DELETE_ACTION.setEnabled(true);
        }
        LibraryFilesTableDataLine libraryFilesTableDataLine = (LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(nArray[0]);
        skinPopupMenu.add(this.createSearchSubMenu(libraryFilesTableDataLine));
        return skinPopupMenu;
    }

    private boolean areAllSelectedFilesPlayable() {
        int[] nArray;
        boolean bl = true;
        for (int n : nArray = this.TABLE.getSelectedRows()) {
            if (AudioPlayer.isPlayableFile((File)((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(n)).getInitializeObject())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private JMenu createSearchSubMenu(LibraryFilesTableDataLine libraryFilesTableDataLine) {
        File file;
        String string;
        SkinMenu skinMenu = new SkinMenu(I18n.tr("Search"));
        if (libraryFilesTableDataLine != null && (string = QueryUtils.createQueryString((file = (File)libraryFilesTableDataLine.getInitializeObject()).getName())).length() > 0) {
            skinMenu.add(new SkinMenuItem(new SearchAction(string)));
        }
        if (skinMenu.getItemCount() == 0) {
            skinMenu.setEnabled(false);
        }
        return skinMenu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryFilesTableMediator() {
        super("LIBRARY_FILES_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new LibraryFilesTableTransferHandler(this));
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new LibraryNameHolderEditor());
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.TABLE.addMouseListener(mouseInputListener);
        this.TABLE.addMouseMotionListener(mouseInputListener);
    }

    void updateTableFiles(DirectoryHolder directoryHolder) {
        if (directoryHolder == null) {
            return;
        }
        if (directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder) {
            this.setMediaType(((MediaTypeSavedFilesDirectoryHolder)directoryHolder).getMediaType());
        } else {
            this.setMediaType(MediaType.getAnyTypeMediaType());
        }
        this.clearTable();
        List<List<File>> list = CollectionUtils.split(100, Arrays.asList(directoryHolder.getFiles()));
        Iterator<List<File>> iterator = list.iterator();
        while (iterator.hasNext()) {
            List<File> list2;
            final List<File> list3 = list2 = iterator.next();
            BackgroundExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (File file : list3) {
                                LibraryFilesTableMediator.this.addUnsorted(file);
                            }
                            LibraryMediator.instance().getLibrarySearch().addResults(list3.size());
                        }
                    });
                    Thread.yield();
                }
            });
        }
        this.forceResort();
    }

    File getFile(int n) {
        return ((LibraryFilesTableModel)this.DATA_MODEL).getFile(n);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void startRename() {
        int n = this.TABLE.getSelectedRow();
        if (n == -1) {
            return;
        }
    }

    void showLicenseWindow() {
    }

    private static Object[] createRemoveOptions() {
        if (OSUtils.supportsTrash()) {
            String string = OSUtils.isWindows() ? I18n.tr("Move to Recycle Bin") : I18n.tr("Move to Trash");
            return new Object[]{string, I18n.tr("Delete"), I18n.tr("Cancel")};
        }
        return new Object[]{I18n.tr("Delete"), I18n.tr("Cancel")};
    }

    @Override
    public List<AudioSource> getFileView() {
        int n = ((LibraryFilesTableModel)this.DATA_MODEL).getRowCount();
        ArrayList<AudioSource> arrayList = new ArrayList<AudioSource>(n);
        for (int i = 0; i < n; ++i) {
            try {
                File file = ((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(i)).getFile();
                if (!AudioPlayer.isPlayableFile(file)) continue;
                arrayList.add(new AudioSource(((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(i)).getFile()));
                continue;
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
        return arrayList;
    }

    @Override
    public void removeSelection() {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        if (this.TABLE.isEditing()) {
            object = this.TABLE.getCellEditor();
            object.cancelCellEditing();
        }
        object = new ArrayList(nArray.length);
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray2 = ((LibraryFilesTableModel)this.DATA_MODEL).getFile(nArray[i]);
            objectArray = ((LibraryFilesTableModel)this.DATA_MODEL).getFileDesc(nArray[i]);
            object.add(new Tuple<File, FileDesc>((File)objectArray2, (FileDesc)objectArray));
        }
        CheckBoxListPanel<Tuple<File, FileDesc>> checkBoxListPanel = new CheckBoxListPanel<Tuple<File, FileDesc>>((Collection<Tuple<File, FileDesc>>)object, new TupleTextProvider(), true);
        checkBoxListPanel.getList().setVisibleRowCount(4);
        objectArray2 = new Object[]{new MultiLineLabel(I18n.tr("Are you sure you want to delete the selected file(s), thus removing it from your computer?"), 400), Box.createVerticalStrut(6), checkBoxListPanel, Box.createVerticalStrut(6)};
        objectArray = LibraryFilesTableMediator.createRemoveOptions();
        int n = JOptionPane.showOptionDialog(MessageService.getParentComponent(), objectArray2, I18n.tr("Message"), 0, 3, null, objectArray, objectArray[0]);
        if (n == objectArray.length - 1 || n == -1) {
            return;
        }
        List<Tuple<File, FileDesc>> list = checkBoxListPanel.getSelectedElements();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Tuple<File, FileDesc> tuple : list) {
            boolean bl;
            File file = tuple.getFirst();
            FileDesc fileDesc = tuple.getSecond();
            if (fileDesc != null) {
                // empty if block
            }
            if (bl = FileUtils.delete(file, objectArray.length > 2 && n == 0)) {
                if (AudioPlayer.instance().isThisBeingPlayed(file)) {
                    AudioPlayer.instance().stop();
                }
                ((LibraryFilesTableModel)this.DATA_MODEL).remove(((LibraryFilesTableModel)this.DATA_MODEL).getRow(file));
                continue;
            }
            arrayList.add(this.getCompleteFileName(file));
        }
        this.clearSelection();
        if (arrayList.isEmpty()) {
            return;
        }
        objectArray2 = new Object[]{new MultiLineLabel(I18n.tr("The following files could not be deleted. They may be in use by another application or are currently being downloaded to."), 400), Box.createVerticalStrut(6), new JScrollPane(LibraryFilesTableMediator.createFileList(arrayList))};
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), objectArray2, I18n.tr("Error"), 0);
        super.removeSelection();
    }

    private static JList createFileList(List<String> list) {
        JList<Object> jList = new JList<Object>(list.toArray());
        jList.setVisibleRowCount(5);
        jList.setCellRenderer(new FileNameListCellRenderer());
        jList.setFocusable(false);
        return jList;
    }

    private String getCompleteFileName(File file) {
        return file.getName();
    }

    String handleNameChange(String string) {
        int n = this.TABLE.getEditingRow();
        LibraryFilesTableModel libraryFilesTableModel = (LibraryFilesTableModel)this.DATA_MODEL;
        File file = libraryFilesTableModel.getFile(n);
        String string2 = file.getParent();
        String string3 = string + "." + libraryFilesTableModel.getType(n);
        File file2 = new File(string2, string3);
        if (!libraryFilesTableModel.getName(n).equals(string)) {
            if (file.renameTo(file2)) {
                ((LibraryFilesTableModel)this.DATA_MODEL).reinitialize(file);
                return string;
            }
            GUIMediator.showError(I18n.tr("Unable to rename the file '{0}'. It may be in use by another application.", libraryFilesTableModel.getName(n)));
            return libraryFilesTableModel.getName(n);
        }
        return string;
    }

    @Override
    public void handleActionKey() {
        LibraryFilesTableDataLine libraryFilesTableDataLine = (LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (libraryFilesTableDataLine == null) {
            return;
        }
        if (this.getMediaType().equals(MediaType.getAudioMediaType()) && AudioPlayer.isPlayableFile(libraryFilesTableDataLine.getFile())) {
            AudioPlayer.instance().asyncLoadSong(new AudioSource(libraryFilesTableDataLine.getFile()), true, true, null, this.getFileView());
            return;
        }
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
        }
        this.launch(true);
    }

    void launch(boolean bl) {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        File file = ((LibraryFilesTableModel)this.DATA_MODEL).getFile(nArray[0]);
        if (OSUtils.isWindows()) {
            if (file.isDirectory()) {
                GUIMediator.launchExplorer(file);
                return;
            }
            if (!AudioPlayer.isPlayableFile(file)) {
                GUIMediator.launchFile(file);
                return;
            }
        }
        GUILauncher.LaunchableProvider[] launchableProviderArray = new GUILauncher.LaunchableProvider[nArray.length];
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                MediaType mediaType = MediaType.getMediaTypeForExtension(FilenameUtils.getExtension(((LibraryFilesTableModel)this.DATA_MODEL).getFile(nArray[i]).getName()));
                if (mediaType.equals(MediaType.getVideoMediaType())) {
                    bl2 = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            launchableProviderArray[i] = new FileProvider(((LibraryFilesTableModel)this.DATA_MODEL).getFile(nArray[i]));
        }
        if (bl2 || !bl) {
            AudioPlayer.instance().stop();
        }
        if (bl) {
            GUILauncher.launch(launchableProviderArray);
        } else {
            GUIMediator.launchFile(file);
        }
    }

    @Override
    public void handleSelection(int n) {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            this.handleNoSelection();
            return;
        }
        File file = this.getFile(nArray[0]);
        LAUNCH_ACTION.setEnabled(true);
        LAUNCH_OS_ACTION.setEnabled(true);
        DELETE_ACTION.setEnabled(true);
        if (file != null && !file.getName().endsWith(".torrent")) {
            CREATE_TORRENT_ACTION.setEnabled(nArray.length == 1);
        }
        if (file != null) {
            this.SEND_TO_FRIEND_ACTION.setEnabled(nArray.length == 1);
            if (this.getMediaType().equals(MediaType.getAnyTypeMediaType())) {
                boolean bl = false;
                for (int n2 : nArray) {
                    File file2 = this.getFile(n2);
                    if (!AudioPlayer.isPlayableFile(file2) && !FilenameUtils.hasExtension(file2.getAbsolutePath(), "mp4")) continue;
                    bl = true;
                    break;
                }
                SEND_TO_ITUNES_ACTION.setEnabled(bl);
            } else {
                SEND_TO_ITUNES_ACTION.setEnabled(this.getMediaType().equals(MediaType.getAudioMediaType()) || FilenameUtils.hasExtension(file.getAbsolutePath(), "mp4"));
            }
        }
        if (nArray.length == 1 && file.isFile() && file.getParentFile() != null) {
            OPEN_IN_FOLDER_ACTION.setEnabled(true);
        } else {
            OPEN_IN_FOLDER_ACTION.setEnabled(false);
        }
        if (nArray.length == 1) {
            LibraryMediator.instance().getLibraryCoverArt().setFile(file);
        }
    }

    @Override
    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        LAUNCH_OS_ACTION.setEnabled(false);
        OPEN_IN_FOLDER_ACTION.setEnabled(false);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        CREATE_TORRENT_ACTION.setEnabled(false);
        DELETE_ACTION.setEnabled(false);
        RENAME_ACTION.setEnabled(false);
        SEND_TO_ITUNES_ACTION.setEnabled(false);
    }

    public void setPlayerEnabled(boolean bl) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    public boolean setFileSelected(File file) {
        int n = ((LibraryFilesTableModel)this.DATA_MODEL).getRow(file);
        if (n != -1) {
            this.TABLE.setSelectedRow(n);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    private boolean hasExploreAction() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    @Override
    protected void sortAndMaintainSelection(int n) {
        super.sortAndMaintainSelection(n);
        this.resetAudioPlayerFileView();
    }

    public void resetAudioPlayerFileView() {
        Playlist playlist = AudioPlayer.instance().getCurrentPlaylist();
        if (playlist == null) {
            AudioPlayer.instance().setPlaylistFilesView(this.getFileView());
        }
    }

    @Override
    protected AudioSource createAudioSource(LibraryFilesTableDataLine libraryFilesTableDataLine) {
        if (AudioPlayer.isPlayableFile((File)libraryFilesTableDataLine.getInitializeObject())) {
            return new AudioSource((File)libraryFilesTableDataLine.getInitializeObject());
        }
        return null;
    }

    private static class FileProvider
    implements GUILauncher.LaunchableProvider {
        private final File _file;

        public FileProvider(File file) {
            this._file = file;
        }

        @Override
        public File getFile() {
            return this._file;
        }
    }

    private class TupleTextProvider
    implements CheckBoxList.TextProvider<Tuple<File, FileDesc>> {
        private TupleTextProvider() {
        }

        @Override
        public Icon getIcon(Tuple<File, FileDesc> tuple) {
            String string = FileUtils.getFileExtension(tuple.getFirst());
            if (string != null) {
                return IconManager.instance().getIconForExtension(string);
            }
            return null;
        }

        @Override
        public String getText(Tuple<File, FileDesc> tuple) {
            return LibraryFilesTableMediator.this.getCompleteFileName(tuple.getFirst());
        }

        @Override
        public String getToolTipText(Tuple<File, FileDesc> tuple) {
            return tuple.getFirst().getAbsolutePath();
        }
    }

    private static class FileNameListCellRenderer
    extends SubstanceDefaultListCellRenderer {
        private static final long serialVersionUID = 5064313639046811749L;

        private FileNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = FileUtils.getFileExtension(object.toString());
            if (string != null) {
                this.setIcon(IconManager.instance().getIconForExtension(string));
            }
            return this;
        }
    }

    private class SendAudioFilesToiTunes
    extends AbstractAction {
        private static final long serialVersionUID = 4726989286129406765L;

        public SendAudioFilesToiTunes() {
            this.putValue("Name", I18n.tr("Send to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Send audio files to iTunes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryFilesTableMediator.this.TABLE.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                File file = ((LibraryFilesTableModel)LibraryFilesTableMediator.this.DATA_MODEL).getFile(n);
                iTunesMediator.instance().scanForSongs(file);
            }
        }
    }

    private final class RenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 2673219925804729384L;

        public RenameAction() {
            this.putValue("Name", I18n.tr("Rename"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryFilesTableMediator.this.startRename();
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -8704093935791256631L;

        public RemoveAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryFilesTableMediator.this.REMOVE_LISTENER.actionPerformed(actionEvent);
        }
    }

    private final class CreateTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1898917632888388860L;

        public CreateTorrentAction() {
            super(I18n.tr("Create New Torrent"));
            this.putValue("LongDescription", I18n.tr("Create a new .torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = ((LibraryFilesTableModel)LibraryFilesTableMediator.this.DATA_MODEL).getFile(LibraryFilesTableMediator.this.TABLE.getSelectedRow());
            if (file.isDirectory() && file.listFiles().length == 0) {
                JOptionPane.showMessageDialog(null, I18n.tr("The folder you selected is empty."), I18n.tr("Invalid Folder"), 0);
                return;
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(null, I18n.tr("Error: You can't read on that file/folder."), I18n.tr("Error"), 0);
                return;
            }
            CreateTorrentDialog createTorrentDialog = new CreateTorrentDialog(GUIMediator.getAppFrame());
            createTorrentDialog.setChosenContent(file);
            createTorrentDialog.setVisible(true);
        }
    }

    private final class OpenInFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1693310684299300459L;

        public OpenInFolderAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryFilesTableMediator.this.TABLE.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            File file = LibraryFilesTableMediator.this.getFile(nArray[0]);
            if (file.isFile() && file.getParentFile() != null) {
                GUIMediator.launchExplorer(file);
            }
        }
    }

    private final class LaunchOSAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392592L;

        public LaunchOSAction() {
            String string = "OS";
            if (OSUtils.isWindows()) {
                string = "Windows";
            } else if (OSUtils.isMacOSX()) {
                string = "Mac";
            } else if (OSUtils.isLinux()) {
                string = "Linux";
            }
            this.putValue("Name", I18n.tr("Launch in ") + string);
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files in " + string));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryFilesTableMediator.this.launch(false);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392591L;

        public LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryFilesTableMediator.this.launch(true);
        }
    }
}

