/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.limewire.util.OSUtils;

class LibraryFilesTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -5962762524077270378L;
    private final LibraryFilesTableMediator mediator;
    private final TransferHandler fallbackTransferHandler;

    public LibraryFilesTableTransferHandler(LibraryFilesTableMediator libraryFilesTableMediator) {
        this.mediator = libraryFilesTableMediator;
        this.fallbackTransferHandler = new MulticastTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLERS);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return this.canImport(transferSupport, true);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport, false)) {
            return this.fallbackTransferHandler.importData(transferSupport);
        }
        try {
            Transferable transferable = transferSupport.getTransferable();
            if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                PlaylistItem[] playlistItemArray = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                LibraryUtils.createNewPlaylist(playlistItemArray);
            } else {
                File[] fileArray = DNDUtils.getFiles(transferSupport.getTransferable());
                if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.createNewPlaylist(fileArray[0]);
                } else {
                    LibraryUtils.createNewPlaylist(fileArray);
                }
            }
        }
        catch (Exception exception) {
            return this.fallbackTransferHandler.importData(transferSupport);
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 0x40000003;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        List list = this.mediator.getSelectedLines();
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(i).getFile());
        }
        return new FileTransferable(arrayList);
    }

    private boolean canImport(TransferHandler.TransferSupport transferSupport, boolean bl) {
        transferSupport.setShowDropLocation(false);
        if (!this.mediator.getMediaType().equals(MediaType.getAudioMediaType())) {
            return bl ? this.fallbackTransferHandler.canImport(transferSupport) : false;
        }
        if (transferSupport.isDataFlavorSupported(LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
            return true;
        }
        if (DNDUtils.containsFileFlavors(transferSupport.getDataFlavors())) {
            if (OSUtils.isMacOSX()) {
                return true;
            }
            try {
                File[] fileArray;
                for (File file : fileArray = DNDUtils.getFiles(transferSupport.getTransferable())) {
                    if (AudioPlayer.isPlayableFile(file)) {
                        return true;
                    }
                    if (!file.isDirectory() || !LibraryUtils.directoryContainsAudio(file)) continue;
                    return true;
                }
                if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                    return true;
                }
                return bl ? this.fallbackTransferHandler.canImport(transferSupport) : false;
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                return true;
            }
            catch (Exception exception) {
                return bl ? this.fallbackTransferHandler.canImport(transferSupport) : false;
            }
        }
        return false;
    }
}

