/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.DeviceNode;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.OSUtils;

final class LibraryFilesTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -3874985752229848555L;
    private static final Log LOG = LogFactory.getLog(LibraryFilesTransferHandler.class);
    private final JTree tree;

    public LibraryFilesTransferHandler(JTree jTree) {
        this.tree = jTree;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        block12: {
            try {
                File[] fileArray;
                LibraryNode libraryNode = this.getNodeFromLocation(transferSupport.getDropLocation());
                if (!(libraryNode instanceof DirectoryHolderNode) && !(libraryNode instanceof DeviceNode)) {
                    return false;
                }
                if (!(!(libraryNode instanceof DirectoryHolderNode) || (fileArray = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder && ((MediaTypeSavedFilesDirectoryHolder)fileArray).getMediaType().equals(MediaType.getAudioMediaType()) || fileArray instanceof StarredDirectoryHolder)) {
                    return false;
                }
                if (transferSupport.isDataFlavorSupported(LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                    return true;
                }
                if (!DNDUtils.containsFileFlavors(transferSupport.getDataFlavors())) break block12;
                if (OSUtils.isMacOSX()) {
                    return true;
                }
                if (libraryNode instanceof DeviceNode) {
                    return true;
                }
                try {
                    for (File file : fileArray = DNDUtils.getFiles(transferSupport.getTransferable())) {
                        if (AudioPlayer.isPlayableFile(file)) {
                            return true;
                        }
                        if (!file.isDirectory() || !LibraryUtils.directoryContainsAudio(file)) continue;
                        return true;
                    }
                    if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                        return true;
                    }
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                LOG.error("Error in LibraryFilesTransferHandler processing", throwable);
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        try {
            Transferable transferable = transferSupport.getTransferable();
            LibraryNode libraryNode = this.getNodeFromLocation(transferSupport.getDropLocation());
            if (libraryNode instanceof DeviceNode) {
                File[] fileArray = null;
                if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                    PlaylistItem[] playlistItemArray = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                    fileArray = LibraryUtils.convertToFiles(playlistItemArray);
                } else {
                    fileArray = DNDUtils.getFiles(transferSupport.getTransferable());
                }
                if (fileArray != null) {
                    ((DeviceNode)libraryNode).getDevice().upload(fileArray);
                }
            } else if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                PlaylistItem[] playlistItemArray = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                LibraryUtils.createNewPlaylist(playlistItemArray, this.isStarredDirectoryHolder(transferSupport.getDropLocation()));
            } else {
                File[] fileArray = DNDUtils.getFiles(transferSupport.getTransferable());
                if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.createNewPlaylist(fileArray[0], this.isStarredDirectoryHolder(transferSupport.getDropLocation()));
                } else {
                    LibraryUtils.createNewPlaylist(fileArray, this.isStarredDirectoryHolder(transferSupport.getDropLocation()));
                }
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error in LibraryFilesTransferHandler processing", throwable);
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 0x40000003;
    }

    private boolean isStarredDirectoryHolder(TransferHandler.DropLocation dropLocation) {
        LibraryNode libraryNode = this.getNodeFromLocation(dropLocation);
        if (libraryNode instanceof DirectoryHolderNode) {
            DirectoryHolder directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder();
            return directoryHolder instanceof StarredDirectoryHolder;
        }
        return false;
    }

    private LibraryNode getNodeFromLocation(TransferHandler.DropLocation dropLocation) {
        TreePath treePath = this.tree.getUI().getClosestPathForLocation(this.tree, dropLocation.getDropPoint().x, dropLocation.getDropPoint().y);
        return treePath != null ? (LibraryNode)treePath.getLastPathComponent() : null;
    }
}

