/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListModel;

public class LibraryIconList
extends JList {
    private static final long serialVersionUID = 6951236485310381795L;
    private Image speaker;
    private Image loading;

    public LibraryIconList() {
        this.loadIcons();
    }

    public LibraryIconList(ListModel listModel) {
        super(listModel);
        this.loadIcons();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        AudioPlayer audioPlayer = AudioPlayer.instance();
        if (audioPlayer.getState() != MediaPlaybackState.Stopped && audioPlayer.getCurrentSong() != null && audioPlayer.getCurrentPlaylist() != null && audioPlayer.getPlaylistFilesView() != null && (n = this.getPlaylistIndex(audioPlayer.getCurrentPlaylist())) != -1) {
            this.paintIcon(graphics, this.speaker, n);
        }
        this.paintImportingIcons(graphics);
    }

    private void loadIcons() {
        this.speaker = GUIMediator.getThemeImage("speaker").getImage();
        this.loading = GUIMediator.getThemeImage("indeterminate_small_progress").getImage();
    }

    private void paintIcon(Graphics graphics, Image image, int n) {
        Rectangle rectangle = this.getUI().getCellBounds(this, n, n);
        Dimension dimension = rectangle.getSize();
        Point point = rectangle.getLocation();
        graphics.drawImage(image, point.x + dimension.width - this.speaker.getWidth(null) - 4, point.y + (dimension.height - this.speaker.getHeight(null)) / 2, null);
    }

    private int getPlaylistIndex(Playlist playlist) {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Playlist playlist2;
            Object e = this.getModel().getElementAt(i);
            if (!(e instanceof LibraryPlaylists.LibraryPlaylistsListCell) || (playlist2 = ((LibraryPlaylists.LibraryPlaylistsListCell)e).getPlaylist()) == null || !playlist2.equals(playlist)) continue;
            return i;
        }
        return -1;
    }

    private void paintImportingIcons(Graphics graphics) {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.getModel().getElementAt(i);
            if (e instanceof LibraryPlaylists.LibraryPlaylistsListCell) {
                Playlist playlist = ((LibraryPlaylists.LibraryPlaylistsListCell)e).getPlaylist();
                if (!LibraryMediator.instance().getLibraryPlaylists().isPlaylistImporting(playlist)) continue;
                this.paintIcon(graphics, this.loading, i);
                continue;
            }
            return;
        }
    }
}

