/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.DeviceFileTypeTreeNode;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.InternetRadioDirectoryHolder;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.DeviceAudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryIconTree
extends JTree {
    private static final long serialVersionUID = 3025054051505168836L;
    private static final Log LOG = LogFactory.getLog(LibraryIconTree.class);
    private Image speaker;

    public LibraryIconTree() {
        this.loadIcons();
    }

    public LibraryIconTree(TreeModel treeModel) {
        super(treeModel);
        this.loadIcons();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        try {
            AudioPlayer audioPlayer = AudioPlayer.instance();
            if (audioPlayer.getState() != MediaPlaybackState.Stopped) {
                TreePath treePath;
                if (audioPlayer.getCurrentSong() instanceof InternetRadioAudioSource) {
                    TreePath treePath2 = this.getRadioPath();
                    if (treePath2 != null) {
                        this.paintIcon(graphics, this.speaker, treePath2);
                    }
                } else if (audioPlayer.getCurrentSong() instanceof DeviceAudioSource) {
                    TreePath treePath3 = this.getDeviceFileTypePath((DeviceAudioSource)audioPlayer.getCurrentSong());
                    if (treePath3 != null) {
                        this.paintIcon(graphics, this.speaker, treePath3);
                    }
                } else if (audioPlayer.getCurrentSong() != null && audioPlayer.getCurrentPlaylist() == null && audioPlayer.getPlaylistFilesView() != null) {
                    TreePath treePath4 = this.getAudioPath();
                    if (treePath4 != null) {
                        this.paintIcon(graphics, this.speaker, treePath4);
                    }
                } else if (audioPlayer.getCurrentSong() != null && audioPlayer.getCurrentPlaylist() != null && audioPlayer.getPlaylistFilesView() != null && (treePath = this.getPlaylistPath(audioPlayer.getCurrentPlaylist())) != null) {
                    this.paintIcon(graphics, this.speaker, treePath);
                }
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error painting the speaker icon, e:" + throwable.getMessage());
        }
    }

    private TreePath getDeviceFileTypePath(DeviceAudioSource deviceAudioSource) {
        Enumeration<TreeNode> enumeration = ((LibraryNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode instanceof DeviceFileTypeTreeNode)) continue;
            Device device = ((DeviceFileTypeTreeNode)libraryNode).getDevice();
            byte by = ((DeviceFileTypeTreeNode)libraryNode).getFileType();
            if (!device.equals(deviceAudioSource.getDevice()) || by != deviceAudioSource.getFileDescriptor().fileType) continue;
            return new TreePath(libraryNode.getPath());
        }
        return null;
    }

    private void loadIcons() {
        this.speaker = GUIMediator.getThemeImage("speaker").getImage();
    }

    private void paintIcon(Graphics graphics, Image image, TreePath treePath) {
        Rectangle rectangle = this.getUI().getPathBounds(this, treePath);
        Dimension dimension = rectangle.getSize();
        Point point = rectangle.getLocation();
        graphics.drawImage(image, point.x + dimension.width - this.speaker.getWidth(null) - 4, point.y + (dimension.height - this.speaker.getHeight(null)) / 2, null);
    }

    private TreePath getAudioPath() {
        Enumeration<TreeNode> enumeration = ((LibraryNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DirectoryHolder directoryHolder;
            LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof MediaTypeSavedFilesDirectoryHolder) || !((MediaTypeSavedFilesDirectoryHolder)directoryHolder).getMediaType().equals(MediaType.getAudioMediaType())) continue;
            return new TreePath(libraryNode.getPath());
        }
        return null;
    }

    private TreePath getRadioPath() {
        Enumeration<TreeNode> enumeration = ((LibraryNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DirectoryHolder directoryHolder;
            LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
            if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof InternetRadioDirectoryHolder)) continue;
            return new TreePath(libraryNode.getPath());
        }
        return null;
    }

    private TreePath getPlaylistPath(Playlist playlist) {
        if (playlist.getId() == -3) {
            Enumeration<TreeNode> enumeration = ((LibraryNode)this.getModel().getRoot()).depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DirectoryHolder directoryHolder;
                LibraryNode libraryNode = (LibraryNode)enumeration.nextElement();
                if (!(libraryNode instanceof DirectoryHolderNode) || !((directoryHolder = ((DirectoryHolderNode)libraryNode).getDirectoryHolder()) instanceof StarredDirectoryHolder)) continue;
                return new TreePath(libraryNode.getPath());
            }
        }
        return null;
    }
}

