/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.InternetRadioBookmark;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameHolder;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import org.limewire.util.StringUtils;

public final class LibraryInternetRadioTableDataLine
extends AbstractLibraryTableDataLine<InternetRadioStation> {
    static final int BOOKMARKED_IDX = 0;
    private static final LimeTableColumn BOOKMARKED_COLUMN = new LimeTableColumn(0, "INTERNET_RADIO_TABLE_BOOKMARKED", I18n.tr("Bookmarked"), 20, true, false, false, InternetRadioBookmark.class);
    static final int NAME_IDX = 1;
    private static final LimeTableColumn NAME_COLUMN = new LimeTableColumn(1, "INTERNET_RADIO_TABLE_NAME", I18n.tr("Name"), 484, true, LibraryNameHolder.class);
    static final int GENRE_IDX = 2;
    static final LimeTableColumn GENRE_COLUMN = new LimeTableColumn(2, "INTERNET_RADIO_TABLE_GENRE", I18n.tr("Genre"), 268, true, PlayableCell.class);
    static final int BITRATE_IDX = 3;
    private static final LimeTableColumn BITRATE_COLUMN = new LimeTableColumn(3, "INTERNET_RADIO_TABLE_BITRATE", I18n.tr("Bitrate"), 80, true, PlayableCell.class);
    static final int WEBSITE_IDX = 4;
    private static final LimeTableColumn WEBSITE_COLUMN = new LimeTableColumn(4, "INTERNET_RADIO_TABLE_WEBSITE", I18n.tr("Website"), 170, true, ActionIconAndNameHolder.class);
    static final int TYPE_IDX = 5;
    private static final LimeTableColumn TYPE_COLUMN = new LimeTableColumn(5, "INTERNET_RADIO_TABLE_TYPE", I18n.tr("Type"), 40, true, PlayableCell.class);
    static final int URL_IDX = 6;
    private static final LimeTableColumn URL_COLUMN = new LimeTableColumn(6, "INTERNET_RADIO_TABLE_URL", I18n.tr("Url"), 80, false, PlayableCell.class);
    static final int DESCRIPTION_IDX = 7;
    private static final LimeTableColumn DESCRIPTION_COLUMN = new LimeTableColumn(7, "INTERNET_RADIO_TABLE_DESCRIPTION", I18n.tr("Description"), 80, false, PlayableCell.class);
    static final int NUMBER_OF_COLUMNS = 8;
    private ActionListener detailsAction;

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public void initialize(final InternetRadioStation internetRadioStation) {
        super.initialize(internetRadioStation);
        this.detailsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.openURL("http://" + internetRadioStation.getWebsite().replace("http://", ""));
            }
        };
    }

    @Override
    public Object getValueAt(int n) {
        boolean bl = this.isPlaying();
        switch (n) {
            case 0: {
                return new InternetRadioBookmark(this, bl);
            }
            case 1: {
                return new LibraryNameHolder(this, ((InternetRadioStation)this.initializer).getName(), bl, true, n);
            }
            case 7: {
                return new PlayableCell(this, ((InternetRadioStation)this.initializer).getDescription(), bl, n);
            }
            case 6: {
                return new PlayableCell(this, ((InternetRadioStation)this.initializer).getUrl(), bl, n);
            }
            case 3: {
                return new PlayableCell(this, ((InternetRadioStation)this.initializer).getBitrate(), bl, n);
            }
            case 5: {
                return new PlayableCell(this, ((InternetRadioStation)this.initializer).getType(), bl, n);
            }
            case 4: {
                return new ActionIconAndNameHolder(null, this.detailsAction, "<html><a href=\"#\">" + ((InternetRadioStation)this.initializer).getWebsite().replace("http://", "") + "</a></html>");
            }
            case 2: {
                return new PlayableCell(this, ((InternetRadioStation)this.initializer).getGenre(), bl, n);
            }
        }
        return null;
    }

    private boolean isPlaying() {
        if (this.initializer != null) {
            return AudioPlayer.instance().isThisBeingPlayed(((InternetRadioStation)this.initializer).getUrl());
        }
        return false;
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        switch (n) {
            case 0: {
                return BOOKMARKED_COLUMN;
            }
            case 1: {
                return NAME_COLUMN;
            }
            case 7: {
                return DESCRIPTION_COLUMN;
            }
            case 6: {
                return URL_COLUMN;
            }
            case 3: {
                return BITRATE_COLUMN;
            }
            case 5: {
                return TYPE_COLUMN;
            }
            case 4: {
                return WEBSITE_COLUMN;
            }
            case 2: {
                return GENRE_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int n) {
        return false;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public String[] getToolTipArray(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getName(), true)) {
            arrayList.add(I18n.tr("Name") + ": " + ((InternetRadioStation)this.initializer).getName());
        }
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getDescription(), true)) {
            arrayList.add(I18n.tr("Description") + ": " + ((InternetRadioStation)this.initializer).getDescription());
        }
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getUrl(), true)) {
            arrayList.add(I18n.tr("Url") + ": " + ((InternetRadioStation)this.initializer).getUrl());
        }
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getBitrate(), true)) {
            arrayList.add(I18n.tr("Bitrate") + ": " + ((InternetRadioStation)this.initializer).getBitrate());
        }
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getType(), true)) {
            arrayList.add(I18n.tr("Type") + ": " + ((InternetRadioStation)this.initializer).getType());
        }
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getWebsite(), true)) {
            arrayList.add(I18n.tr("Website") + ": " + ((InternetRadioStation)this.initializer).getWebsite());
        }
        if (!StringUtils.isNullOrEmpty(((InternetRadioStation)this.initializer).getGenre(), true)) {
            arrayList.add(I18n.tr("Genre") + ": " + ((InternetRadioStation)this.initializer).getGenre());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }
}

