/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Playlist;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.InternetRadioBookmark;
import com.frostwire.gui.library.InternetRadioBookmarkEditor;
import com.frostwire.gui.library.InternetRadioBookmarkRenderer;
import com.frostwire.gui.library.LibraryInternetRadioTableDataLine;
import com.frostwire.gui.library.LibraryInternetRadioTableModel;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.LibraryNameHolderEditor;
import com.frostwire.gui.library.LibraryNameHolderRenderer;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableCellRenderer;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameEditor;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.settings.TablesHandlerSettings;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

final class LibraryInternetRadioTableMediator
extends AbstractLibraryTableMediator<LibraryInternetRadioTableModel, LibraryInternetRadioTableDataLine, InternetRadioStation> {
    private Action importRadioStationAction;
    private Action copyStreamUrlAction;
    private Action LAUNCH_ACTION;
    private Action DELETE_ACTION;
    private static LibraryInternetRadioTableMediator INSTANCE;

    public static LibraryInternetRadioTableMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryInternetRadioTableMediator();
        }
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.importRadioStationAction = new AddRadioStationAction();
        this.copyStreamUrlAction = new CopyStreamUrlAction();
        this.LAUNCH_ACTION = new LaunchAction();
        this.DELETE_ACTION = new RemoveFromStationsAction();
    }

    @Override
    protected void setupConstants() {
        super.setupConstants();
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new LibraryInternetRadioTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        Action[] actionArray = new Action[]{this.LAUNCH_ACTION, this.DELETE_ACTION, this.importRadioStationAction, this.OPTIONS_ACTION};
        this.BUTTON_ROW = new ButtonRow(actionArray, 0, 14);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        skinPopupMenu.add(new SkinMenuItem(this.LAUNCH_ACTION));
        skinPopupMenu.add(new SkinMenuItem(this.importRadioStationAction));
        skinPopupMenu.add(new SkinMenuItem(this.copyStreamUrlAction));
        skinPopupMenu.add(new SkinMenuItem(this.DELETE_ACTION));
        int[] nArray = this.TABLE.getSelectedRows();
        this.DELETE_ACTION.setEnabled(true);
        ((JPopupMenu)skinPopupMenu).addSeparator();
        LibraryInternetRadioTableDataLine libraryInternetRadioTableDataLine = (LibraryInternetRadioTableDataLine)((LibraryInternetRadioTableModel)this.DATA_MODEL).get(nArray[0]);
        skinPopupMenu.add(this.createSearchSubMenu(libraryInternetRadioTableDataLine));
        return skinPopupMenu;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (LibraryUtils.isRefreshKeyEvent(keyEvent)) {
                    // empty if block
                }
            }
        });
    }

    private JMenu createSearchSubMenu(LibraryInternetRadioTableDataLine libraryInternetRadioTableDataLine) {
        String string;
        SkinMenu skinMenu = new SkinMenu(I18n.tr("Search"));
        if (libraryInternetRadioTableDataLine != null && (string = QueryUtils.createQueryString(((InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject()).getName())).length() > 0) {
            skinMenu.add(new SkinMenuItem(new SearchAction(string)));
        }
        if (skinMenu.getItemCount() == 0) {
            skinMenu.setEnabled(false);
        }
        return skinMenu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryInternetRadioTableMediator() {
        super("LIBRARY_INTERNET_RADIO_TABLE");
        this.setMediaType(MediaType.getAudioMediaType());
        ThemeMediator.addThemeObserver(this);
        LimeTableColumn limeTableColumn = LibraryInternetRadioTableDataLine.GENRE_COLUMN;
        if (limeTableColumn != null && TablesHandlerSettings.getVisibility(limeTableColumn.getId(), limeTableColumn.getDefaultVisibility()).getValue()) {
            ((LibraryInternetRadioTableModel)this.DATA_MODEL).sort(2);
        }
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setDropMode(DropMode.INSERT_ROWS);
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(PlayableCell.class, new PlayableCellRenderer());
        this.TABLE.setDefaultRenderer(InternetRadioBookmark.class, new InternetRadioBookmarkRenderer());
        this.TABLE.setDefaultRenderer(LibraryNameHolder.class, new LibraryNameHolderRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(4);
        tableColumn.setCellEditor(new ActionIconAndNameEditor());
        tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellEditor(new InternetRadioBookmarkEditor());
        this.TABLE.addMouseMotionListener(new MouseMotionAdapter(){
            int currentCellColumn = -1;
            int currentCellRow = -1;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = LibraryInternetRadioTableMediator.this.TABLE.columnAtPoint(point);
                int n2 = LibraryInternetRadioTableMediator.this.TABLE.rowAtPoint(point);
                if (this.currentCellRow != n2 || this.currentCellColumn != n) {
                    if (LibraryInternetRadioTableMediator.this.TABLE.getCellRenderer(n2, n) instanceof InternetRadioBookmarkRenderer) {
                        LibraryInternetRadioTableMediator.this.TABLE.editCellAt(n2, n);
                    }
                    this.currentCellColumn = n;
                    this.currentCellRow = n2;
                }
            }
        });
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new LibraryNameHolderEditor());
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.TABLE.addMouseListener(mouseInputListener);
        this.TABLE.addMouseMotionListener(mouseInputListener);
    }

    void updateTableItems(List<InternetRadioStation> list) {
        if (list == null) {
            return;
        }
        this.clearTable();
        for (int i = 0; i < list.size(); ++i) {
            this.addUnsorted(list.get(i));
        }
        this.forceResort();
    }

    File getFile(int n) {
        return ((LibraryInternetRadioTableModel)this.DATA_MODEL).getFile(n);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    LibraryInternetRadioTableDataLine[] getSelectedLibraryLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        LibraryInternetRadioTableDataLine[] libraryInternetRadioTableDataLineArray = new LibraryInternetRadioTableDataLine[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            libraryInternetRadioTableDataLineArray[i] = (LibraryInternetRadioTableDataLine)((LibraryInternetRadioTableModel)this.DATA_MODEL).get(nArray[i]);
        }
        return libraryInternetRadioTableDataLineArray;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void startRename() {
        int n = this.TABLE.getSelectedRow();
        if (n == -1) {
            return;
        }
    }

    void showLicenseWindow() {
    }

    @Override
    public void removeSelection() {
        LibraryInternetRadioTableDataLine[] libraryInternetRadioTableDataLineArray = this.getSelectedLibraryLines();
        int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.trn(I18n.tr("Are you sure you want to remove the selected radio station?"), I18n.tr("Are you sure you want to remove the selected radio stations?"), libraryInternetRadioTableDataLineArray.length), I18n.tr("Are you sure?"), 0, 3);
        if (n != 0) {
            return;
        }
        for (LibraryInternetRadioTableDataLine libraryInternetRadioTableDataLine : libraryInternetRadioTableDataLineArray) {
            InternetRadioStation internetRadioStation = (InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject();
            internetRadioStation.delete();
        }
        LibraryMediator.instance().getLibraryExplorer().selectRadio();
        this.clearSelection();
        super.removeSelection();
    }

    @Override
    public void handleActionKey() {
        this.playSong();
    }

    private void playSong() {
        LibraryInternetRadioTableDataLine libraryInternetRadioTableDataLine = (LibraryInternetRadioTableDataLine)((LibraryInternetRadioTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (libraryInternetRadioTableDataLine == null) {
            return;
        }
        try {
            InternetRadioAudioSource internetRadioAudioSource = new InternetRadioAudioSource(((InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject()).getUrl(), (InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject());
            AudioPlayer.instance().asyncLoadSong(internetRadioAudioSource, true, false, null, this.getFileView());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void launch() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        File file = ((LibraryInternetRadioTableModel)this.DATA_MODEL).getFile(nArray[0]);
        if (OSUtils.isWindows()) {
            if (file.isDirectory()) {
                GUIMediator.launchExplorer(file);
                return;
            }
            if (!AudioPlayer.isPlayableFile(file)) {
                GUIMediator.launchFile(file);
                return;
            }
        }
        GUILauncher.LaunchableProvider[] launchableProviderArray = new GUILauncher.LaunchableProvider[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            launchableProviderArray[i] = new FileProvider(((LibraryInternetRadioTableModel)this.DATA_MODEL).getFile(nArray[i]));
        }
        GUILauncher.launch(launchableProviderArray);
    }

    @Override
    public void handleSelection(int n) {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            this.handleNoSelection();
            return;
        }
        this.copyStreamUrlAction.setEnabled(true);
        this.LAUNCH_ACTION.setEnabled(true);
        this.DELETE_ACTION.setEnabled(true);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        if (nArray.length == 1) {
            LibraryMediator.instance().getLibraryCoverArt().setDefault();
        }
    }

    @Override
    public void handleNoSelection() {
        this.copyStreamUrlAction.setEnabled(false);
        this.LAUNCH_ACTION.setEnabled(false);
        this.DELETE_ACTION.setEnabled(false);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
    }

    public void setPlayerEnabled(boolean bl) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    public boolean setPlaylistItemSelected(InternetRadioStation internetRadioStation) {
        int n = ((LibraryInternetRadioTableModel)this.DATA_MODEL).getRow(internetRadioStation);
        if (n != -1) {
            this.TABLE.setSelectedRow(n);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    @Override
    public List<AudioSource> getFileView() {
        int n = ((LibraryInternetRadioTableModel)this.DATA_MODEL).getRowCount();
        ArrayList<AudioSource> arrayList = new ArrayList<AudioSource>(n);
        for (int i = 0; i < n; ++i) {
            try {
                String string = ((InternetRadioStation)((LibraryInternetRadioTableDataLine)((LibraryInternetRadioTableModel)this.DATA_MODEL).get(i)).getInitializeObject()).getUrl();
                arrayList.add(new InternetRadioAudioSource(string, (InternetRadioStation)((LibraryInternetRadioTableDataLine)((LibraryInternetRadioTableModel)this.DATA_MODEL).get(i)).getInitializeObject()));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    protected void sortAndMaintainSelection(int n) {
        super.sortAndMaintainSelection(n);
        this.resetAudioPlayerFileView();
    }

    private void resetAudioPlayerFileView() {
        Playlist playlist = AudioPlayer.instance().getCurrentPlaylist();
        if (playlist == null && AudioPlayer.instance().getPlaylistFilesView() != null) {
            AudioPlayer.instance().setPlaylistFilesView(this.getFileView());
        }
    }

    @Override
    protected AudioSource createAudioSource(LibraryInternetRadioTableDataLine libraryInternetRadioTableDataLine) {
        return new InternetRadioAudioSource(((InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject()).getUrl(), (InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject());
    }

    private final class CopyStreamUrlAction
    extends AbstractAction {
        private static final long serialVersionUID = 5603390659365617618L;

        public CopyStreamUrlAction() {
            this.putValue("Name", I18n.tr("Copy Stream URL"));
            this.putValue("LimeShortName", I18n.tr("Copy Stream URL"));
            this.putValue("ShortDescription", I18n.tr("Copy Stream URL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryInternetRadioTableDataLine[] libraryInternetRadioTableDataLineArray = LibraryInternetRadioTableMediator.this.getSelectedLibraryLines();
            String string = "";
            for (int i = 0; i < libraryInternetRadioTableDataLineArray.length; ++i) {
                string = string + ((InternetRadioStation)libraryInternetRadioTableDataLineArray[i].getInitializeObject()).getUrl();
                string = string + "\n";
            }
            GUIMediator.setClipboardContent(string);
        }
    }

    private static class FileProvider
    implements GUILauncher.LaunchableProvider {
        private final File _file;

        public FileProvider(File file) {
            this._file = file;
        }

        @Override
        public File getFile() {
            return this._file;
        }
    }

    private final class RemoveFromStationsAction
    extends AbstractAction {
        private static final long serialVersionUID = -8704093935791256631L;

        public RemoveFromStationsAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Radio Station"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryInternetRadioTableMediator.this.REMOVE_LISTENER.actionPerformed(actionEvent);
        }
    }

    public static final class AddRadioStationAction
    extends AbstractAction {
        private static final long serialVersionUID = 7087376528613706765L;

        public AddRadioStationAction() {
            super(I18n.tr("Add Radio"));
            this.putValue("LongDescription", I18n.tr("Add a new Radio Station. You must enter the Stream's URL"));
            this.putValue("LimeIconName", "LIBRARY_ADD_RADIO_STATION");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)JOptionPane.showInputDialog(GUIMediator.getAppFrame(), I18n.tr("Radio Station's stream URL"), I18n.tr("Add Radio Station"), -1, null, null, "");
            if (!StringUtils.isNullOrEmpty(string, true)) {
                LibraryUtils.asyncAddRadioStation(string);
            }
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392591L;

        public LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryInternetRadioTableMediator.this.launch();
        }
    }
}

