/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.LibraryCoverArt;
import com.frostwire.gui.library.LibraryExplorer;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.library.LibrarySearch;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class LibraryLeftPanel
extends JPanel {
    private static final long serialVersionUID = -2924157073406477820L;
    public static final int MIN_WIDTH = 155;
    public static final int MAX_WIDTH = 300;
    private final LibrarySearch librarySearch;
    private final LibraryExplorer libraryExplorer;
    private final LibraryPlaylists libraryPlaylists;
    private final LibraryCoverArt libraryCoverArt;
    private final JSplitPane splitPane;

    public LibraryLeftPanel(LibrarySearch librarySearch, LibraryExplorer libraryExplorer, LibraryPlaylists libraryPlaylists, LibraryCoverArt libraryCoverArt) {
        this.librarySearch = librarySearch;
        this.libraryExplorer = libraryExplorer;
        this.libraryPlaylists = libraryPlaylists;
        this.libraryCoverArt = libraryCoverArt;
        this.splitPane = new JSplitPane(0);
        this.setupUI();
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.librarySearch.getSearchField(), "First");
        this.splitPane.setTopComponent(this.libraryExplorer);
        this.splitPane.setBottomComponent(this.libraryPlaylists);
        this.splitPane.setAutoscrolls(true);
        this.add((Component)this.splitPane, "Center");
        Dimension dimension = new Dimension(155, 155);
        Dimension dimension2 = new Dimension(300, 300);
        this.libraryCoverArt.setPreferredSize(dimension);
        this.libraryCoverArt.setMinimumSize(dimension);
        this.libraryCoverArt.setMaximumSize(dimension2);
        this.add((Component)this.libraryCoverArt, "Last");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LibraryLeftPanel.this.layoutComponents();
            }
        });
        DividerLocationSettingUpdater.install(this.splitPane, UISettings.UI_LIBRARY_EXPLORER_DIVIDER_POSITION);
    }

    protected void layoutComponents() {
        Dimension dimension = this.libraryCoverArt.getSize();
        dimension.height = dimension.width;
        this.libraryCoverArt.setSize(dimension);
        this.libraryCoverArt.setPreferredSize(dimension);
        this.revalidate();
    }
}

