/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.AbstractLibraryListPanel;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.DeviceDiscoveryClerk;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryCoverArt;
import com.frostwire.gui.library.LibraryDeviceTableMediator;
import com.frostwire.gui.library.LibraryExplorer;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryInternetRadioTableMediator;
import com.frostwire.gui.library.LibraryLeftPanel;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.LibrarySearch;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.DeviceAudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class LibraryMediator {
    private static final String FILES_TABLE_KEY = "LIBRARY_FILES_TABLE";
    private static final String PLAYLISTS_TABLE_KEY = "LIBRARY_PLAYLISTS_TABLE";
    private static final String INTERNET_RADIO_TABLE_KEY = "LIBRARY_INTERNET_RADIO_TABLE";
    private static final String DEVICE_TABLE_KEY = "DEVICE_FILES_TABLE";
    private static JPanel MAIN_PANEL;
    private static LibraryMediator INSTANCE;
    private LibraryExplorer libraryExplorer;
    private LibraryPlaylists libraryPlaylists;
    private LibraryCoverArt libraryCoverArt;
    private LibraryLeftPanel libraryLeftPanel;
    private LibrarySearch librarySearch;
    private static Library LIBRARY;
    private CardLayout _tablesViewLayout = new CardLayout();
    private JPanel _tablesPanel;
    private JSplitPane splitPane;
    private Map<Object, Integer> scrollbarValues;
    private Object lastSelectedKey;
    private AbstractLibraryTableMediator<?, ?, ?> lastSelectedMediator;
    private Set<Integer> idScanned;
    private AbstractLibraryTableMediator<?, ?, ?> currentMediator;

    public static LibraryMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryMediator();
        }
        return INSTANCE;
    }

    public LibraryMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Library Window..."));
        this.idScanned = new HashSet<Integer>();
        this.getComponent();
        this.scrollbarValues = new HashMap<Object, Integer>();
        this.splitPane = new JSplitPane(1, this.getLibraryLeftPanel(), this.getLibraryRightPanel());
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                int n = jSplitPane.getDividerLocation();
                if (n > 300) {
                    jSplitPane.setDividerLocation(300);
                } else if (n < 155) {
                    jSplitPane.setDividerLocation(155);
                }
            }
        });
        DividerLocationSettingUpdater.install(this.splitPane, UISettings.UI_LIBRARY_MAIN_DIVIDER_LOCATION);
        MAIN_PANEL.add(this.splitPane);
        DeviceDiscoveryClerk deviceDiscoveryClerk = new DeviceDiscoveryClerk();
        deviceDiscoveryClerk.start();
    }

    protected Object getSelectedKey() {
        if (this.getSelectedPlaylist() != null) {
            return this.getSelectedPlaylist();
        }
        return this.getLibraryExplorer().getSelectedDirectoryHolder();
    }

    public static Library getLibrary() {
        if (LIBRARY == null) {
            LIBRARY = new Library(LibrarySettings.LIBRARY_DATABASE);
        }
        return LIBRARY;
    }

    public LibraryExplorer getLibraryExplorer() {
        if (this.libraryExplorer == null) {
            this.libraryExplorer = new LibraryExplorer();
        }
        return this.libraryExplorer;
    }

    public LibraryPlaylists getLibraryPlaylists() {
        if (this.libraryPlaylists == null) {
            this.libraryPlaylists = new LibraryPlaylists();
        }
        return this.libraryPlaylists;
    }

    public Playlist getSelectedPlaylist() {
        return this.getLibraryPlaylists().getSelectedPlaylist();
    }

    public LibrarySearch getLibrarySearch() {
        if (this.librarySearch == null) {
            this.librarySearch = new LibrarySearch();
        }
        return this.librarySearch;
    }

    public LibraryCoverArt getLibraryCoverArt() {
        if (this.libraryCoverArt == null) {
            this.libraryCoverArt = new LibraryCoverArt();
        }
        return this.libraryCoverArt;
    }

    public JComponent getComponent() {
        if (MAIN_PANEL == null) {
            MAIN_PANEL = new JPanel(new BorderLayout());
            MAIN_PANEL.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ThemeMediator.CURRENT_THEME.getCustomUI().getLightBorder()));
        }
        return MAIN_PANEL;
    }

    public void showView(String string) {
        this.rememberScrollbarsOnMediators(string);
        this._tablesViewLayout.show(this._tablesPanel, string);
        this.currentMediator = string.equals(FILES_TABLE_KEY) ? LibraryFilesTableMediator.instance() : (string.equals(PLAYLISTS_TABLE_KEY) ? LibraryPlaylistsTableMediator.instance() : (string.equals(INTERNET_RADIO_TABLE_KEY) ? LibraryInternetRadioTableMediator.instance() : (string.equals(DEVICE_TABLE_KEY) ? LibraryDeviceTableMediator.instance() : null)));
    }

    private void rememberScrollbarsOnMediators(String string) {
        AbstractLibraryTableMediator abstractLibraryTableMediator = null;
        AbstractLibraryListPanel abstractLibraryListPanel = null;
        if (string.equals(FILES_TABLE_KEY)) {
            abstractLibraryTableMediator = LibraryFilesTableMediator.instance();
            abstractLibraryListPanel = this.getLibraryExplorer();
        } else if (string.equals(PLAYLISTS_TABLE_KEY)) {
            abstractLibraryTableMediator = LibraryPlaylistsTableMediator.instance();
            abstractLibraryListPanel = this.getLibraryPlaylists();
        } else if (string.equals(DEVICE_TABLE_KEY)) {
            abstractLibraryTableMediator = LibraryDeviceTableMediator.instance();
            abstractLibraryListPanel = this.getLibraryExplorer();
        }
        if (abstractLibraryTableMediator == null || abstractLibraryListPanel == null) {
            return;
        }
        if (this.lastSelectedMediator != null && this.lastSelectedKey != null) {
            this.scrollbarValues.put(this.lastSelectedKey, this.lastSelectedMediator.getScrollbarValue());
        }
        this.lastSelectedMediator = abstractLibraryTableMediator;
        this.lastSelectedKey = this.getSelectedKey();
        if (abstractLibraryListPanel.getPendingRunnables().size() == 0) {
            int n = this.scrollbarValues.containsKey(this.lastSelectedKey) ? this.scrollbarValues.get(this.lastSelectedKey) : 0;
            abstractLibraryTableMediator.scrollTo(n);
        }
    }

    public void updateTableFiles(DirectoryHolder directoryHolder) {
        this.clearLibraryTable();
        this.showView(FILES_TABLE_KEY);
        LibraryFilesTableMediator.instance().updateTableFiles(directoryHolder);
    }

    public void clearDirectoryHolderCaches() {
        this.getLibraryExplorer().clearDirectoryHolderCaches();
    }

    public void updateTableFiles(Device device, byte by) {
        this.clearLibraryTable();
        this.showView(DEVICE_TABLE_KEY);
        LibraryDeviceTableMediator.instance().updateTableFiles(device, by);
    }

    public void updateTableItems(Playlist playlist) {
        this.clearLibraryTable();
        this.showView(PLAYLISTS_TABLE_KEY);
        LibraryPlaylistsTableMediator.instance().updateTableItems(playlist);
    }

    public void showInternetRadioStations(List<InternetRadioStation> list) {
        this.clearLibraryTable();
        this.showView(INTERNET_RADIO_TABLE_KEY);
        LibraryInternetRadioTableMediator.instance().updateTableItems(list);
    }

    public void clearLibraryTable() {
        LibraryFilesTableMediator.instance().clearTable();
        LibraryPlaylistsTableMediator.instance().clearTable();
        LibraryDeviceTableMediator.instance().clearTable();
        this.getLibrarySearch().clear();
    }

    public void addFilesToLibraryTable(List<File> list) {
        for (File file : list) {
            LibraryFilesTableMediator.instance().add(file);
        }
        this.getLibrarySearch().addResults(list.size());
    }

    public void addItemsToLibraryTable(List<PlaylistItem> list) {
        for (PlaylistItem playlistItem : list) {
            LibraryPlaylistsTableMediator.instance().add(playlistItem);
        }
        this.getLibrarySearch().addResults(list.size());
    }

    public void addInternetRadioStationsToLibraryTable(List<InternetRadioStation> list) {
        for (InternetRadioStation internetRadioStation : list) {
            LibraryInternetRadioTableMediator.instance().add(internetRadioStation);
        }
        this.getLibrarySearch().addResults(list.size());
    }

    private JComponent getLibraryLeftPanel() {
        if (this.libraryLeftPanel == null) {
            this.libraryLeftPanel = new LibraryLeftPanel(this.getLibrarySearch(), this.getLibraryExplorer(), this.getLibraryPlaylists(), this.getLibraryCoverArt());
        }
        return this.libraryLeftPanel;
    }

    private JComponent getLibraryRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._tablesViewLayout = new CardLayout();
        this._tablesPanel = new JPanel(this._tablesViewLayout);
        this._tablesPanel.add((Component)LibraryFilesTableMediator.instance().getComponent(), FILES_TABLE_KEY);
        this._tablesPanel.add((Component)LibraryPlaylistsTableMediator.instance().getComponent(), PLAYLISTS_TABLE_KEY);
        this._tablesPanel.add((Component)LibraryInternetRadioTableMediator.instance().getComponent(), INTERNET_RADIO_TABLE_KEY);
        this._tablesPanel.add((Component)LibraryDeviceTableMediator.instance().getComponent(), DEVICE_TABLE_KEY);
        jPanel.add((Component)this.getLibrarySearch(), "First");
        jPanel.add((Component)this._tablesPanel, "Center");
        return jPanel;
    }

    public void setSelectedFile(File file) {
        this.getLibraryExplorer().selectFinishedDownloads();
        LibraryFilesTableMediator.instance().setFileSelected(file);
    }

    public void selectCurrentSong() {
        Playlist playlist = AudioPlayer.instance().getCurrentPlaylist();
        final AudioSource audioSource = AudioPlayer.instance().getCurrentSong();
        if (playlist != null && audioSource != null && audioSource.getPlaylistItem() != null) {
            if (playlist.getId() != -3) {
                this.getLibraryPlaylists().enqueueRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LibraryPlaylistsTableMediator.instance().setItemSelected(audioSource.getPlaylistItem());
                            }
                        });
                    }
                });
                this.getLibraryPlaylists().selectPlaylist(playlist);
            } else {
                LibraryExplorer libraryExplorer = this.getLibraryExplorer();
                libraryExplorer.enqueueRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LibraryPlaylistsTableMediator.instance().setItemSelected(audioSource.getPlaylistItem());
                            }
                        });
                    }
                });
                libraryExplorer.selectStarred();
            }
        } else if (audioSource != null && audioSource.getFile() != null) {
            LibraryExplorer libraryExplorer = this.getLibraryExplorer();
            libraryExplorer.enqueueRunnable(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryFilesTableMediator.instance().setFileSelected(audioSource.getFile());
                        }
                    });
                }
            });
            libraryExplorer.selectAudio();
        } else if (audioSource instanceof InternetRadioAudioSource) {
            LibraryExplorer libraryExplorer = this.getLibraryExplorer();
            libraryExplorer.enqueueRunnable(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryInternetRadioTableMediator.instance().setItemSelected(((InternetRadioAudioSource)audioSource).getInternetRadioStation());
                        }
                    });
                }
            });
            libraryExplorer.selectRadio();
        } else if (audioSource instanceof DeviceAudioSource) {
            LibraryExplorer libraryExplorer = this.getLibraryExplorer();
            libraryExplorer.enqueueRunnable(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryDeviceTableMediator.instance().setItemSelected(((DeviceAudioSource)audioSource).getFileDescriptor());
                        }
                    });
                }
            });
            libraryExplorer.selectDeviceFileType(((DeviceAudioSource)audioSource).getDevice(), ((DeviceAudioSource)audioSource).getFileDescriptor().fileType);
        }
    }

    public boolean isScanned(int n) {
        return this.idScanned.contains(n);
    }

    public void scan(int n, File file) {
        this.idScanned.add(n);
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.scan(n, file2);
            }
        } else {
            List<MediaTypeSavedFilesDirectoryHolder> list = this.getLibraryExplorer().getMediaTypeSavedFilesDirectoryHolders();
            for (MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirectoryHolder : list) {
                Set<File> set = mediaTypeSavedFilesDirectoryHolder.getCache();
                if (!mediaTypeSavedFilesDirectoryHolder.accept(file) || set.isEmpty() || set.contains(file)) continue;
                set.add(file);
            }
        }
    }

    public long getTotalRadioStations() {
        return LibraryMediator.getLibrary().getTotalRadioStations();
    }

    public void restoreDefaultRadioStations() {
        LibraryMediator.getLibrary().restoreDefaultRadioStations();
    }

    public File getSelectedFile() {
        boolean bl;
        File file = null;
        DirectoryHolder directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
        boolean bl2 = bl = directoryHolder instanceof SavedFilesDirectoryHolder || directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder || directoryHolder instanceof TorrentDirectoryHolder;
        if (bl && LibraryFilesTableMediator.instance().getSelectedLines().size() == 1) {
            file = LibraryFilesTableMediator.instance().getSelectedLines().get(0).getFile();
        } else if (LibraryPlaylistsTableMediator.instance().getSelectedLines() != null && LibraryPlaylistsTableMediator.instance().getSelectedLines().size() == 1) {
            file = LibraryPlaylistsTableMediator.instance().getSelectedLines().get(0).getFile();
        }
        return file;
    }

    public void playCurrentSelection() {
        if (this.currentMediator != null) {
            this.currentMediator.playCurrentSelection();
        }
    }

    public void handleDeviceNew(Device device) {
        this.getLibraryExplorer().handleDeviceNew(device);
    }

    public void handleDeviceAlive(Device device) {
        this.getLibraryExplorer().handleDeviceAlive(device);
    }

    public void handleDeviceStale(Device device) {
        this.getLibraryExplorer().handleDeviceStale(device);
    }
}

