/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.LibraryDeviceTableDataLine;
import com.frostwire.gui.library.LibraryFilesTableDataLine;
import com.frostwire.gui.library.LibraryInternetRadioTableDataLine;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.DeviceAudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.themes.SkinTableCellRenderer;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.substance.internal.utils.border.SubstanceTableCellBorder;

public final class LibraryNameHolderRenderer
extends JPanel
implements TableCellRenderer,
SkinTableCellRenderer {
    private static final long serialVersionUID = -1624943333769190212L;
    private JLabel labelText;
    private JLabel labelPlay;
    private LibraryNameHolder libraryNameHolder;

    public LibraryNameHolderRenderer() {
        this.setupUI();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        boolean bl3;
        TableUI tableUI = jTable.getUI();
        SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
        bl2 = substanceTableUI.isFocusedCell(n, n2);
        SubstanceTableUI.TableCellId tableCellId = new SubstanceTableUI.TableCellId(n, n2);
        StateTransitionTracker.ModelStateInfo modelStateInfo = substanceTableUI.getModelStateInfo(tableCellId);
        ComponentState componentState = substanceTableUI.getCellState(tableCellId);
        JTable.DropLocation dropLocation = jTable.getDropLocation();
        boolean bl4 = bl3 = dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2;
        if (!bl3 && modelStateInfo != null) {
            if (substanceTableUI.hasRolloverAnimations() || substanceTableUI.hasSelectionAnimations()) {
                object3 = modelStateInfo.getStateContributionMap();
                object2 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
                if (componentState.isDisabled() || object3 == null || object3.size() == 1) {
                    super.setForeground(new ColorUIResource(object2.getForegroundColor()));
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState componentState2 = entry.getKey();
                        SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTable, substanceTableUI, componentState2);
                        Color color = substanceColorScheme.getForegroundColor();
                        float f4 = entry.getValue().getContribution();
                        f += (float)color.getRed() * f4;
                        f2 += (float)color.getGreen() * f4;
                        f3 += (float)color.getBlue() * f4;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                }
            } else {
                object3 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
                super.setForeground(new ColorUIResource(object3.getForegroundColor()));
            }
        } else {
            object3 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
            if (bl3) {
                object3 = SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
            }
            super.setForeground(new ColorUIResource(object3.getForegroundColor()));
        }
        SubstanceStripingUtils.applyStripedBackground(jTable, n, this);
        this.setFont(jTable.getFont());
        object3 = new SubstanceTableUI.TableCellId(n, n2);
        object2 = substanceTableUI.getStateTransitionTracker((SubstanceTableUI.TableCellId)object3);
        Insets insets = substanceTableUI.getCellRendererInsets();
        if (bl2 || object2 != null) {
            SubstanceTableCellBorder substanceTableCellBorder = new SubstanceTableCellBorder(insets, substanceTableUI, (SubstanceTableUI.TableCellId)object3);
            if (object2 != null) {
                substanceTableCellBorder.setAlpha(((StateTransitionTracker)object2).getFocusStrength(bl2));
            }
            if (!jTable.getShowHorizontalLines() && !jTable.getShowVerticalLines()) {
                this.setBorder(new CompoundBorder(new EmptyBorder(jTable.getRowMargin() / 2, 0, jTable.getRowMargin() / 2, 0), substanceTableCellBorder));
            } else {
                this.setBorder(substanceTableCellBorder);
            }
        } else {
            this.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        this.setData((LibraryNameHolder)object, componentState, jTable, n, n2);
        this.setOpaque(false);
        this.setEnabled(jTable.isEnabled());
        return this;
    }

    private SubstanceColorScheme getColorSchemeForState(JTable jTable, SubstanceTableUI substanceTableUI, ComponentState componentState) {
        UpdateOptimizationInfo updateOptimizationInfo = substanceTableUI.getUpdateOptimizationInfo();
        if (componentState == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme(jTable, componentState);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        }
        return updateOptimizationInfo.getHighlightColorScheme(componentState);
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    protected final void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
    }

    @Override
    public final void paintComponents(Graphics graphics) {
        super.paintComponents(graphics);
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
        this.labelText = new JLabel();
        this.labelText.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.labelText, gridBagConstraints);
        this.labelPlay = new JLabel(GUIMediator.getThemeImage("search_result_play_over"));
        this.labelPlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LibraryNameHolderRenderer.this.labelPlay_mouseReleased(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.ipadx = 1;
        this.add((Component)this.labelPlay, gridBagConstraints);
    }

    private void labelPlay_mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && this.libraryNameHolder != null && this.libraryNameHolder.getDataLine() != null) {
            AudioSource audioSource = null;
            Object object = this.libraryNameHolder.getDataLine();
            if (object instanceof LibraryFilesTableDataLine) {
                audioSource = new AudioSource(((LibraryFilesTableDataLine)object).getFile());
            } else if (object instanceof LibraryPlaylistsTableDataLine) {
                audioSource = new AudioSource(((LibraryPlaylistsTableDataLine)object).getPlayListItem());
            } else if (object instanceof LibraryInternetRadioTableDataLine) {
                LibraryInternetRadioTableDataLine libraryInternetRadioTableDataLine = (LibraryInternetRadioTableDataLine)object;
                audioSource = new InternetRadioAudioSource(((InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject()).getUrl(), (InternetRadioStation)libraryInternetRadioTableDataLine.getInitializeObject());
            } else if (object instanceof LibraryDeviceTableDataLine) {
                LibraryDeviceTableDataLine libraryDeviceTableDataLine = (LibraryDeviceTableDataLine)object;
                Device device = LibraryMediator.instance().getLibraryExplorer().getSelectedDeviceFiles();
                if (device != null) {
                    String string = device.getDownloadURL((FileDescriptor)libraryDeviceTableDataLine.getInitializeObject());
                    audioSource = new DeviceAudioSource(string, device, (FileDescriptor)libraryDeviceTableDataLine.getInitializeObject());
                }
            }
            if (audioSource != null && !this.isSourceBeingPlayed()) {
                this.labelPlay.setVisible(false);
                GUIMediator.instance().launchAudio(audioSource);
            }
        }
    }

    private void setData(LibraryNameHolder libraryNameHolder, ComponentState componentState, JTable jTable, int n, int n2) {
        this.libraryNameHolder = libraryNameHolder;
        this.labelText.setText(libraryNameHolder.toString());
        boolean bl = componentState.equals(ComponentState.ROLLOVER_SELECTED) || componentState.equals(ComponentState.ROLLOVER_UNSELECTED);
        this.labelPlay.setVisible(bl && !this.isSourceBeingPlayed() && this.isPlayableDataLine());
        this.setFontColor(this.libraryNameHolder.isPlaying(), jTable, n, n2);
    }

    private boolean isPlayableDataLine() {
        Object object = this.libraryNameHolder.getDataLine();
        if (object instanceof LibraryFilesTableDataLine) {
            return AudioPlayer.isPlayableFile(((LibraryFilesTableDataLine)object).getFile());
        }
        if (object instanceof LibraryPlaylistsTableDataLine) {
            return true;
        }
        if (object instanceof LibraryInternetRadioTableDataLine) {
            return true;
        }
        if (object instanceof LibraryDeviceTableDataLine) {
            return AudioPlayer.isPlayableFile(((FileDescriptor)((LibraryDeviceTableDataLine)object).getInitializeObject()).filePath);
        }
        return false;
    }

    private boolean isSourceBeingPlayed() {
        if (this.libraryNameHolder == null) {
            return false;
        }
        return this.libraryNameHolder.isPlaying();
    }

    private void setFontColor(boolean bl, JTable jTable, int n, int n2) {
        if (!this.libraryNameHolder.isExists()) {
            this.setForeground(ThemeSettings.FILE_NO_EXISTS_DATA_LINE_COLOR.getValue());
        } else if (bl) {
            this.labelText.setForeground(ThemeSettings.PLAYING_DATA_LINE_COLOR.getValue());
        } else {
            Color color = Color.BLACK;
            color = SubstanceLookAndFeel.isCurrentLookAndFeel() ? this.getSubstanceForegroundColor(jTable, n, n2) : UIManager.getColor("Table.foreground");
            this.labelText.setForeground(color);
        }
    }

    private Color getSubstanceForegroundColor(JTable jTable, int n, int n2) {
        TableUI tableUI = jTable.getUI();
        SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
        SubstanceTableUI.TableCellId tableCellId = new SubstanceTableUI.TableCellId(n, n2);
        ComponentState componentState = substanceTableUI.getCellState(tableCellId);
        SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
        return substanceColorScheme.getForegroundColor();
    }
}

