/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.components.SortedListModel;
import com.frostwire.gui.library.AbstractLibraryListPanel;
import com.frostwire.gui.library.LibraryIconList;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylistsTransferHandler;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.M3UPlaylist;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class LibraryPlaylists
extends AbstractLibraryListPanel {
    private static final long serialVersionUID = 6317109161466445259L;
    private DefaultListModel _model;
    private int _selectedIndexToRename;
    private LibraryPlaylistsListCell _newPlaylistCell;
    private ActionListener _selectedPlaylistAction;
    private LibraryPlaylistsMouseObserver _listMouseObserver;
    private ListSelectionListener _listSelectionListener;
    private JList _list;
    private JScrollPane _scrollPane;
    private JTextField _textName;
    private JPopupMenu _popup;
    private Action refreshAction = new RefreshAction();
    private Action refreshID3TagsAction = new RefreshID3TagsAction();
    private Action deleteAction = new DeleteAction();
    private Action cleanupPlaylistAction = new CleanupPlaylistAction();
    private Action renameAction = new StartRenamingPlaylistAction();
    private Action importToPlaylistAction = new ImportToPlaylistAction();
    private Action importToNewPlaylistAction = new ImportToNewPlaylistAction();
    private Action exportPlaylistAction = new ExportPlaylistAction();
    private Action exportToiTunesAction = new ExportToiTunesAction();
    private List<Playlist> importingPlaylists;

    public LibraryPlaylists() {
        this.setupUI();
        this.importingPlaylists = new ArrayList<Playlist>();
    }

    public Dimension getRowDimension() {
        Rectangle rectangle = this._list.getUI().getCellBounds(this._list, 0, 0);
        return rectangle.getSize();
    }

    public void addPlaylist(Playlist playlist) {
        LibraryPlaylistsListCell libraryPlaylistsListCell = new LibraryPlaylistsListCell(null, null, GUIMediator.getThemeImage("playlist"), playlist, this._selectedPlaylistAction);
        this._model.addElement(libraryPlaylistsListCell);
    }

    public void clearSelection() {
        this._list.clearSelection();
    }

    public Playlist getSelectedPlaylist() {
        LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylistsListCell)this._list.getSelectedValue();
        return libraryPlaylistsListCell != null ? libraryPlaylistsListCell.getPlaylist() : null;
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        GUIMediator.addRefreshListener(this);
        this.setupPopupMenu();
        this.setupModel();
        this.setupList();
        this._scrollPane = new JScrollPane(this._list);
        this.add(this._scrollPane);
    }

    private void setupPopupMenu() {
        this._popup = new SkinPopupMenu();
        this._popup.add(new SkinMenuItem(this.refreshAction));
        this._popup.add(new SkinMenuItem(this.refreshID3TagsAction));
        this._popup.add(new SkinMenuItem(this.renameAction));
        this._popup.add(new SkinMenuItem(this.deleteAction));
        this._popup.add(new SkinMenuItem(this.cleanupPlaylistAction));
        this._popup.addSeparator();
        this._popup.add(new SkinMenuItem(this.importToPlaylistAction));
        this._popup.add(new SkinMenuItem(this.importToNewPlaylistAction));
        this._popup.add(new SkinMenuItem(this.exportPlaylistAction));
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            this._popup.add(new SkinMenuItem(this.exportToiTunesAction));
        }
        this._popup.addSeparator();
        this._popup.add(new SkinMenuItem(new ConfigureOptionsAction("OPTIONS_LIBRARY_MAIN_TITLE", I18n.tr("Configure Options"), I18n.tr("You can configure the FrostWire's Options."))));
    }

    private void setupModel() {
        this._model = new DefaultListModel();
        this._newPlaylistCell = new LibraryPlaylistsListCell(I18n.tr("New Playlist"), I18n.tr("Creates a new Playlist"), GUIMediator.getThemeImage("playlist_plus"), null, null);
        Library library = LibraryMediator.getLibrary();
        this._selectedPlaylistAction = new SelectedPlaylistActionListener();
        this._model.addElement(this._newPlaylistCell);
        for (Playlist playlist : library.getPlaylists()) {
            LibraryPlaylistsListCell libraryPlaylistsListCell = new LibraryPlaylistsListCell(null, null, GUIMediator.getThemeImage("playlist"), playlist, this._selectedPlaylistAction);
            this._model.addElement(libraryPlaylistsListCell);
        }
    }

    private void setupList() {
        this._listMouseObserver = new LibraryPlaylistsMouseObserver();
        this._listSelectionListener = new LibraryPlaylistsSelectionListener();
        SortedListModel sortedListModel = new SortedListModel(this._model, SortedListModel.SortOrder.ASCENDING, new Comparator<LibraryPlaylistsListCell>(){

            @Override
            public int compare(LibraryPlaylistsListCell libraryPlaylistsListCell, LibraryPlaylistsListCell libraryPlaylistsListCell2) {
                if (libraryPlaylistsListCell == LibraryPlaylists.this._newPlaylistCell) {
                    return -1;
                }
                if (libraryPlaylistsListCell2 == LibraryPlaylists.this._newPlaylistCell) {
                    return 1;
                }
                return libraryPlaylistsListCell.getText().compareTo(libraryPlaylistsListCell2.getText());
            }
        });
        this._list = new LibraryIconList((ListModel)sortedListModel);
        this._list.setFixedCellHeight(TableSettings.DEFAULT_TABLE_ROW_HEIGHT.getValue());
        this._list.setCellRenderer(new LibraryPlaylistsCellRenderer());
        this._list.addMouseListener(new DefaultMouseListener(this._listMouseObserver));
        this._list.addListSelectionListener(this._listSelectionListener);
        this._list.setSelectionMode(2);
        this._list.setLayoutOrientation(0);
        this._list.setPrototypeCellValue(new LibraryPlaylistsListCell("test", "", GUIMediator.getThemeImage("playlist"), null, null));
        this._list.setVisibleRowCount(-1);
        this._list.setDragEnabled(true);
        this._list.setTransferHandler(new LibraryPlaylistsTransferHandler(this._list));
        ToolTipManager.sharedInstance().registerComponent(this._list);
        this._list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                LibraryPlaylists.this.list_keyPressed(keyEvent);
            }
        });
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    LibraryPlaylists.this.actionStartRename();
                }
            }
        });
        this._textName = new JTextField();
        this._textName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                LibraryPlaylists.this.textName_keyPressed(keyEvent);
            }
        });
        this._textName.setVisible(false);
        this._list.add(this._textName);
    }

    protected void list_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.cancelEdit();
        } else if (n == 10) {
            if (OSUtils.isMacOSX()) {
                this.actionStartRename();
            }
        } else if (n == 113) {
            if (!OSUtils.isMacOSX()) {
                this.actionStartRename();
            }
        } else if (n == 127 || OSUtils.isMacOSX() && n == 8) {
            this.deleteAction.actionPerformed(null);
        }
        if (LibraryUtils.isRefreshKeyEvent(keyEvent)) {
            this.refreshSelection();
        }
    }

    protected void textName_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this._selectedIndexToRename != -1 && n == 10) {
            this.renameSelectedItem(this._selectedIndexToRename);
        } else if (this._selectedIndexToRename == -1 && n == 10) {
            this.createNewPlaylist();
        } else if (n == 27) {
            this._textName.setVisible(false);
        }
    }

    public void refreshSelection() {
        LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylistsListCell)this._list.getSelectedValue();
        if (libraryPlaylistsListCell == null) {
            if (this._model.getSize() == 2 && AudioPlayer.instance().getCurrentPlaylist() == null) {
                this._list.setSelectedIndex(1);
            }
            return;
        }
        Playlist playlist = libraryPlaylistsListCell.getPlaylist();
        playlist.refresh();
        LibraryMediator.instance().updateTableItems(playlist);
        String string = LibraryUtils.getPlaylistDurationInDDHHMMSS(playlist) + ", " + playlist.getItems().size() + " " + I18n.tr("tracks");
        LibraryMediator.instance().getLibrarySearch().setStatus(string);
        this.executePendingRunnables();
    }

    private void actionStartRename() {
        this.cancelEdit();
        int n = this._list.getSelectedIndex();
        if (n != -1) {
            this.startEdit(n);
        }
    }

    private void startEdit(int n) {
        if (n < 0) {
            return;
        }
        LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylistsListCell)this._model.getElementAt(n);
        this._selectedIndexToRename = libraryPlaylistsListCell.getPlaylist() != null ? n : -1;
        String string = libraryPlaylistsListCell.getText();
        Rectangle rectangle = this._list.getUI().getCellBounds(this._list, n, n);
        Dimension dimension = rectangle.getSize();
        Point point = rectangle.getLocation();
        this._textName.setSize(dimension);
        this._textName.setLocation(point);
        this._textName.setText(string);
        this._textName.setSelectionStart(0);
        this._textName.setSelectionEnd(string.length());
        this._textName.setVisible(true);
        this._textName.requestFocusInWindow();
        this._textName.requestFocus();
    }

    public void selectPlaylist(Playlist playlist) {
        Object e = this._list.getSelectedValue();
        if (e != null && ((LibraryPlaylistsListCell)e).getPlaylist() != null && ((LibraryPlaylistsListCell)e).getPlaylist().equals(playlist)) {
            try {
                this._listSelectionListener.valueChanged(null);
            }
            catch (Exception exception) {
                System.out.println();
            }
            return;
        }
        int n = this._model.getSize();
        for (int i = 0; i < n; ++i) {
            try {
                LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylistsListCell)this._model.get(i);
                if (libraryPlaylistsListCell.getPlaylist() == null || !libraryPlaylistsListCell.getPlaylist().equals(playlist)) continue;
                this._list.setSelectedValue(libraryPlaylistsListCell, true);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void renameSelectedItem(int n) {
        if (!this._textName.isVisible() || this._textName.getText().trim().length() == 0) {
            return;
        }
        Playlist playlist = this.getSelectedPlaylist();
        playlist.setName(this._textName.getText().trim());
        playlist.save();
        this._list.repaint();
        this._textName.setVisible(false);
    }

    private void createNewPlaylist() {
        if (!this._textName.isVisible()) {
            return;
        }
        String string = this._textName.getText();
        Library library = LibraryMediator.getLibrary();
        Playlist playlist = library.newPlaylist(string, string);
        playlist.save();
        LibraryPlaylistsListCell libraryPlaylistsListCell = new LibraryPlaylistsListCell(null, null, GUIMediator.getThemeImage("playlist"), playlist, this._selectedPlaylistAction);
        this._model.addElement(libraryPlaylistsListCell);
        this._list.setSelectedValue(libraryPlaylistsListCell, true);
        this._textName.setVisible(false);
    }

    private void cancelEdit() {
        this._selectedIndexToRename = -1;
        this._textName.setVisible(false);
    }

    public void importM3U(Playlist playlist) {
        File file;
        File file2 = FileChooserHandler.getLastInputDirectory();
        if (file2 == null) {
            file2 = CommonUtils.getCurrentDirectory();
        }
        if ((file = FileChooserHandler.getInputFile((Component)GUIMediator.getAppFrame(), I18nMarker.marktr("Open Playlist (.m3u)"), file2, new PlaylistListFileFilter())) == null || !file.isFile()) {
            return;
        }
        String string = file.getPath();
        try {
            string = FileUtils.getCanonicalPath(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.loadM3U(playlist, file, string);
    }

    private void loadM3U(final Playlist playlist, File file, final String string) {
        BackgroundExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    List<File> list = M3UPlaylist.load(string);
                    if (playlist != null) {
                        LibraryUtils.asyncAddToPlaylist(playlist, list.toArray(new File[0]));
                    } else {
                        LibraryUtils.createNewPlaylist(list.toArray(new File[0]));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GUIMediator.showError("Unable to save playlist");
                        }
                    });
                }
            }
        });
    }

    public void exportM3U(Playlist playlist) {
        Object object;
        if (playlist == null) {
            return;
        }
        String string = CommonUtils.convertFileName(playlist.getName());
        File file = FileChooserHandler.getLastInputDirectory();
        if (file.equals(CommonUtils.getCurrentDirectory())) {
            file = new File(CommonUtils.getUserHomeDir(), "Desktop");
        }
        File file2 = new File(file, string + ".m3u");
        File file3 = FileChooserHandler.getSaveAsFile(GUIMediator.getAppFrame(), I18nMarker.marktr("Save Playlist As"), file2, new PlaylistListFileFilter());
        if (file3 == null) {
            return;
        }
        if (file3.exists() && (object = GUIMediator.showYesNoMessage(I18n.tr("Warning: a file with the name {0} already exists in the folder. Overwrite this file?", file3.getName()), QuestionsHandler.PLAYLIST_OVERWRITE_OK, DialogOption.NO)) != DialogOption.YES) {
            return;
        }
        object = file3.getPath();
        try {
            object = FileUtils.getCanonicalPath(file3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!object.toLowerCase().endsWith(".m3u")) {
            object = object + ".m3u";
        }
        this.saveM3U(playlist, (String)object);
    }

    private void saveM3U(final Playlist playlist, final String string) {
        BackgroundExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    List<PlaylistItem> list = playlist.getItems();
                    for (PlaylistItem playlistItem : list) {
                        File file = new File(playlistItem.getFilePath());
                        if (!file.exists()) continue;
                        arrayList.add(file);
                    }
                    M3UPlaylist.save(string, arrayList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GUIMediator.showError("Unable to save playlist");
                        }
                    });
                }
            }
        });
    }

    public void reselectPlaylist() {
        this._listSelectionListener.valueChanged(null);
    }

    @Override
    public void refresh() {
        this._list.repaint();
    }

    public void markBeginImport(Playlist playlist) {
        try {
            if (!this.importingPlaylists.contains(playlist)) {
                this.importingPlaylists.add(playlist);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void markEndImport(Playlist playlist) {
        try {
            this.importingPlaylists.remove(playlist);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPlaylistImporting(Playlist playlist) {
        try {
            return this.importingPlaylists.contains(playlist);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private final class ExportToiTunesAction
    extends AbstractAction {
        private static final long serialVersionUID = 3601146746674363384L;

        public ExportToiTunesAction() {
            this.putValue("Name", I18n.tr("Export Playlist to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Export this playlist into an iTunes playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Playlist playlist = LibraryPlaylists.this.getSelectedPlaylist();
            if (playlist != null) {
                ArrayList<File> arrayList = new ArrayList<File>();
                for (PlaylistItem playlistItem : playlist.getItems()) {
                    File file = new File(playlistItem.getFilePath());
                    arrayList.add(file);
                }
                iTunesMediator.instance().addSongsiTunes(playlist.getName(), arrayList.toArray(new File[0]));
            }
        }
    }

    private final class ExportPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 6149822357662730490L;

        public ExportPlaylistAction() {
            this.putValue("Name", I18n.tr("Export Playlist to .m3u"));
            this.putValue("ShortDescription", I18n.tr("Export this playlist into a .m3u file"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylists.this.exportM3U(LibraryPlaylists.this.getSelectedPlaylist());
        }
    }

    private final class ImportToNewPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 390846680458085610L;

        public ImportToNewPlaylistAction() {
            this.putValue("Name", I18n.tr("Import .m3u to New Playlist"));
            this.putValue("ShortDescription", I18n.tr("Import a .m3u file to a new playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylists.this.importM3U(null);
        }
    }

    private final class ImportToPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = -9099898749358019734L;

        public ImportToPlaylistAction() {
            this.putValue("Name", I18n.tr("Import .m3u to Playlist"));
            this.putValue("ShortDescription", I18n.tr("Import a .m3u file into the selected playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_TO");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylists.this.importM3U(LibraryPlaylists.this.getSelectedPlaylist());
        }
    }

    private static class PlaylistListFileFilter
    extends FileFilter {
        private PlaylistListFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith("m3u");
        }

        @Override
        public String getDescription() {
            return I18n.tr("Playlist Files (*.m3u)");
        }
    }

    private class StartRenamingPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 520856485566457934L;

        public StartRenamingPlaylistAction() {
            this.putValue("Name", I18n.tr("Rename"));
            this.putValue("ShortDescription", I18n.tr("Rename Playlist"));
            this.putValue("LimeIconName", "PLAYLIST_RENAME");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylists.this.startEdit(LibraryPlaylists.this._list.getSelectedIndex());
        }
    }

    private final class CleanupPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 8400749433148927596L;

        public CleanupPlaylistAction() {
            this.putValue("Name", I18n.tr("Cleanup playlist"));
            this.putValue("ShortDescription", I18n.tr("Remove the deleted items"));
            this.putValue("LimeIconName", "PLAYLIST_CLEANUP");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Playlist playlist = LibraryPlaylists.this.getSelectedPlaylist();
            if (playlist != null) {
                LibraryUtils.cleanup(playlist);
                LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 520856485566457934L;

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Playlist"));
            this.putValue("LimeIconName", "PLAYLIST_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Playlist playlist = LibraryPlaylists.this.getSelectedPlaylist();
            if (playlist != null) {
                int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("Are you sure you want to delete the playlist?\n(No files will be deleted)"), I18n.tr("Are you sure?"), 0, 3);
                if (n != 0) {
                    return;
                }
                playlist.delete();
                LibraryPlaylists.this._model.removeElement(LibraryPlaylists.this._list.getSelectedValue());
                LibraryMediator.instance().clearLibraryTable();
            }
        }
    }

    private class RefreshID3TagsAction
    extends AbstractAction {
        private static final long serialVersionUID = -472437818841089984L;

        public RefreshID3TagsAction() {
            this.putValue("Name", I18n.tr("Refresh Audio Properties"));
            this.putValue("ShortDescription", I18n.tr("Refresh the audio properties based on ID3 tags of selected items"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Playlist playlist = LibraryPlaylists.this.getSelectedPlaylist();
            if (playlist != null) {
                LibraryUtils.refreshID3Tags(playlist);
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 3259221218056223423L;

        public RefreshAction() {
            this.putValue("Name", I18n.tr("Refresh"));
            this.putValue("ShortDescription", I18n.tr("Refresh selected"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylists.this.refreshSelection();
        }
    }

    private class LibraryPlaylistsSelectionListener
    implements ListSelectionListener {
        private LibraryPlaylistsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            LibraryPlaylists.this.cancelEdit();
            if (listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylistsListCell)LibraryPlaylists.this._list.getSelectedValue();
            if (libraryPlaylistsListCell == null) {
                return;
            }
            LibraryMediator.instance().getLibraryExplorer().clearSelection();
            if (libraryPlaylistsListCell.getAction() != null) {
                libraryPlaylistsListCell.getAction().actionPerformed(null);
            }
        }
    }

    private class LibraryPlaylistsMouseObserver
    implements MouseObserver {
        private LibraryPlaylistsMouseObserver() {
        }

        @Override
        public void handleMouseClick(MouseEvent mouseEvent) {
            int n = LibraryPlaylists.this._list.locationToIndex(mouseEvent.getPoint());
            LibraryPlaylists.this._list.setSelectedIndex(n);
            if (((LibraryPlaylistsListCell)LibraryPlaylists.this._list.getSelectedValue()).getPlaylist() == null) {
                LibraryPlaylists.this.actionStartRename();
            }
        }

        @Override
        public void handleMouseDoubleClick(MouseEvent mouseEvent) {
        }

        @Override
        public void handleRightMouseClick(MouseEvent mouseEvent) {
        }

        @Override
        public void handlePopupMenu(MouseEvent mouseEvent) {
            LibraryPlaylists.this._list.setSelectedIndex(LibraryPlaylists.this._list.locationToIndex(mouseEvent.getPoint()));
            LibraryPlaylists.this._popup.show(LibraryPlaylists.this._list, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class SelectedPlaylistActionListener
    implements ActionListener {
        private SelectedPlaylistActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylists.this.refreshSelection();
        }
    }

    private class LibraryPlaylistsCellRenderer
    extends SubstanceDefaultListCellRenderer {
        private static final long serialVersionUID = -2047182373734965968L;

        private LibraryPlaylistsCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylistsListCell)object;
            this.setText(libraryPlaylistsListCell.getText());
            this.setToolTipText(libraryPlaylistsListCell.getDescription());
            this.setPreferredSize(new Dimension(this.getSize().width, TableSettings.DEFAULT_TABLE_ROW_HEIGHT.getValue()));
            Icon icon = libraryPlaylistsListCell.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    public static class LibraryPlaylistsListCell {
        private final String _text;
        private final String _description;
        private final Icon _icon;
        private final Playlist _playlist;
        private final ActionListener _action;

        public LibraryPlaylistsListCell(String string, String string2, Icon icon, Playlist playlist, ActionListener actionListener2) {
            this._text = string;
            this._description = string2;
            this._icon = icon;
            this._playlist = playlist;
            this._action = actionListener2;
        }

        public String getText() {
            if (this._text != null) {
                return this._text;
            }
            if (this._playlist != null && this._playlist.getName() != null) {
                return this._playlist.getName();
            }
            return "";
        }

        public String getDescription() {
            if (this._description != null) {
                return this._description;
            }
            if (this._playlist != null && this._playlist.getDescription() != null) {
                return this._playlist.getDescription();
            }
            return "";
        }

        public Icon getIcon() {
            return this._icon;
        }

        public Playlist getPlaylist() {
            return this._playlist;
        }

        public ActionListener getAction() {
            return this._action;
        }
    }
}

