/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.PlaylistItemProperty;
import com.frostwire.gui.library.PlaylistItemStar;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.io.File;
import java.util.ArrayList;
import org.limewire.util.FilenameUtils;
import org.limewire.util.StringUtils;

public final class LibraryPlaylistsTableDataLine
extends AbstractLibraryTableDataLine<PlaylistItem> {
    static final int STARRED_IDX = 0;
    private static final LimeTableColumn STARRED_COLUMN = new LimeTableColumn(0, "PLAYLIST_TABLE_STARRED", I18n.tr("Starred"), 20, true, false, false, PlaylistItemStar.class);
    static final int TITLE_IDX = 1;
    private static final LimeTableColumn TITLE_COLUMN = new LimeTableColumn(1, "PLAYLIST_TABLE_TITLE", I18n.tr("Title"), 80, true, LibraryNameHolder.class);
    static final int ARTIST_IDX = 2;
    private static final LimeTableColumn ARTIST_COLUMN = new LimeTableColumn(2, "PLAYLIST_TABLE_ARTIST", I18n.tr("Artist"), 80, true, PlaylistItemProperty.class);
    static final int LENGTH_IDX = 3;
    private static final LimeTableColumn LENGTH_COLUMN = new LimeTableColumn(3, "PLAYLIST_TABLE_LENGTH", I18n.tr("Length"), 150, true, PlaylistItemProperty.class);
    static final int ALBUM_IDX = 4;
    private static final LimeTableColumn ALBUM_COLUMN = new LimeTableColumn(4, "PLAYLIST_TABLE_ALBUM", I18n.tr("Album"), 120, true, PlaylistItemProperty.class);
    static final int TRACK_IDX = 5;
    private static final LimeTableColumn TRACK_COLUMN = new LimeTableColumn(5, "PLAYLIST_TABLE_TRACK", I18n.tr("Track"), 20, false, PlaylistItemProperty.class);
    static final int GENRE_IDX = 6;
    private static final LimeTableColumn GENRE_COLUMN = new LimeTableColumn(6, "PLAYLIST_TABLE_GENRE", I18n.tr("Genre"), 80, true, PlaylistItemProperty.class);
    static final int BITRATE_IDX = 7;
    private static final LimeTableColumn BITRATE_COLUMN = new LimeTableColumn(7, "PLAYLIST_TABLE_BITRATE", I18n.tr("Bitrate"), 60, true, PlaylistItemProperty.class);
    static final int COMMENT_IDX = 8;
    private static final LimeTableColumn COMMENT_COLUMN = new LimeTableColumn(8, "PLAYLIST_TABLE_COMMENT", I18n.tr("Comment"), 20, false, PlaylistItemProperty.class);
    static final int SIZE_IDX = 9;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(9, "PLAYLIST_TABLE_SIZE", I18n.tr("Size"), 80, false, PlaylistItemProperty.class);
    static final int TYPE_IDX = 10;
    private static final LimeTableColumn TYPE_COLUMN = new LimeTableColumn(10, "PLAYLIST_TABLE_TYPE", I18n.tr("Type"), 40, true, PlaylistItemProperty.class);
    static final int YEAR_IDX = 11;
    private static final LimeTableColumn YEAR_COLUMN = new LimeTableColumn(11, "PLAYLIST_TABLE_YEAR", I18n.tr("Year"), 30, false, PlaylistItemProperty.class);
    static final int NUMBER_OF_COLUMNS = 12;
    private SizeHolder sizeHolder;
    private boolean exists;

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public void initialize(PlaylistItem playlistItem) {
        super.initialize(playlistItem);
        this.sizeHolder = new SizeHolder(playlistItem.getFileSize());
        this.exists = new File(playlistItem.getFilePath()).exists();
    }

    @Override
    public Object getValueAt(int n) {
        boolean bl = this.isPlaying();
        switch (n) {
            case 0: {
                return new PlaylistItemStar(this, bl, this.exists);
            }
            case 4: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackAlbum(), bl, this.exists, n);
            }
            case 2: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackArtist(), bl, this.exists, n);
            }
            case 7: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackBitrate(), bl, this.exists, n);
            }
            case 8: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackComment(), bl, this.exists, n);
            }
            case 6: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackGenre(), bl, this.exists, n);
            }
            case 3: {
                return new PlaylistItemProperty(LibraryUtils.getSecondsInDDHHMMSS((int)((PlaylistItem)this.initializer).getTrackDurationInSecs()), bl, this.exists, n);
            }
            case 9: {
                return new PlaylistItemProperty(this.sizeHolder.toString(), bl, this.exists, n);
            }
            case 1: {
                return new LibraryNameHolder(this, ((PlaylistItem)this.initializer).getTrackTitle(), bl, this.exists, n);
            }
            case 5: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackNumber(), bl, this.exists, n);
            }
            case 10: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getFileExtension(), bl, this.exists, n);
            }
            case 11: {
                return new PlaylistItemProperty(((PlaylistItem)this.initializer).getTrackYear(), bl, this.exists, n);
            }
        }
        return null;
    }

    private boolean isPlaying() {
        if (this.initializer != null) {
            return AudioPlayer.instance().isThisBeingPlayed((PlaylistItem)this.initializer);
        }
        return false;
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        switch (n) {
            case 0: {
                return STARRED_COLUMN;
            }
            case 4: {
                return ALBUM_COLUMN;
            }
            case 2: {
                return ARTIST_COLUMN;
            }
            case 7: {
                return BITRATE_COLUMN;
            }
            case 8: {
                return COMMENT_COLUMN;
            }
            case 6: {
                return GENRE_COLUMN;
            }
            case 3: {
                return LENGTH_COLUMN;
            }
            case 9: {
                return SIZE_COLUMN;
            }
            case 1: {
                return TITLE_COLUMN;
            }
            case 5: {
                return TRACK_COLUMN;
            }
            case 10: {
                return TYPE_COLUMN;
            }
            case 11: {
                return YEAR_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int n) {
        return false;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    public PlaylistItem getPlayListItem() {
        return (PlaylistItem)this.initializer;
    }

    @Override
    public String[] getToolTipArray(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackTitle(), true)) {
            arrayList.add(I18n.tr("Title") + ": " + ((PlaylistItem)this.initializer).getTrackTitle());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackNumber(), true)) {
            arrayList.add(I18n.tr("Track") + ": " + ((PlaylistItem)this.initializer).getTrackNumber());
        }
        arrayList.add(I18n.tr("Duration") + ": " + LibraryUtils.getSecondsInDDHHMMSS((int)((PlaylistItem)this.initializer).getTrackDurationInSecs()));
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackArtist(), true)) {
            arrayList.add(I18n.tr("Artist") + ": " + ((PlaylistItem)this.initializer).getTrackArtist());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackAlbum(), true)) {
            arrayList.add(I18n.tr("Album") + ": " + ((PlaylistItem)this.initializer).getTrackAlbum());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackGenre(), true)) {
            arrayList.add(I18n.tr("Genre") + ": " + ((PlaylistItem)this.initializer).getTrackGenre());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackYear(), true)) {
            arrayList.add(I18n.tr("Year") + ": " + ((PlaylistItem)this.initializer).getTrackYear());
        }
        if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackComment(), true)) {
            arrayList.add(I18n.tr("Comment") + ": " + ((PlaylistItem)this.initializer).getTrackComment());
        }
        if (arrayList.size() == 1) {
            if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getFileName(), true)) {
                arrayList.add(I18n.tr("File") + ": " + ((PlaylistItem)this.initializer).getFileName());
            }
            if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getFilePath(), true)) {
                arrayList.add(I18n.tr("Folder") + ": " + FilenameUtils.getPath(((PlaylistItem)this.initializer).getFilePath()));
            }
            if (!StringUtils.isNullOrEmpty(((PlaylistItem)this.initializer).getTrackBitrate(), true)) {
                arrayList.add(I18n.tr("Bitrate") + ": " + ((PlaylistItem)this.initializer).getTrackBitrate());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public File getFile() {
        return new File(((PlaylistItem)this.initializer).getFilePath());
    }
}

