/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.bittorrent.CreateTorrentDialog;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNameHolder;
import com.frostwire.gui.library.LibraryNameHolderEditor;
import com.frostwire.gui.library.LibraryNameHolderRenderer;
import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.library.LibraryPlaylistsTableModel;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferHandler;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.PlaylistItemProperty;
import com.frostwire.gui.library.PlaylistItemPropertyRenderer;
import com.frostwire.gui.library.PlaylistItemStar;
import com.frostwire.gui.library.PlaylistItemStarEditor;
import com.frostwire.gui.library.PlaylistItemStarRenderer;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.limewire.util.OSUtils;

final class LibraryPlaylistsTableMediator
extends AbstractLibraryTableMediator<LibraryPlaylistsTableModel, LibraryPlaylistsTableDataLine, PlaylistItem> {
    private Playlist currentPlaylist;
    public static Action LAUNCH_ACTION;
    public static Action LAUNCH_OS_ACTION;
    public static Action OPEN_IN_FOLDER_ACTION;
    public static Action CREATE_TORRENT_ACTION;
    public static Action DELETE_ACTION;
    public static Action SEND_TO_ITUNES_ACTION;
    private Action importToPlaylistAction = new ImportToPlaylistAction();
    private Action exportPlaylistAction = new ExportPlaylistAction();
    private Action cleanupPlaylistAction = new CleanupPlaylistAction();
    private Action refreshID3TagsAction = new RefreshID3TagsAction();
    private static LibraryPlaylistsTableMediator INSTANCE;

    public static LibraryPlaylistsTableMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryPlaylistsTableMediator();
        }
        return INSTANCE;
    }

    public Playlist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        LAUNCH_OS_ACTION = new LaunchOSAction();
        OPEN_IN_FOLDER_ACTION = new OpenInFolderAction();
        CREATE_TORRENT_ACTION = new CreateTorrentAction();
        DELETE_ACTION = new RemoveFromPlaylistAction();
        SEND_TO_ITUNES_ACTION = new SendAudioFilesToiTunes();
    }

    @Override
    protected void setupConstants() {
        super.setupConstants();
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new LibraryPlaylistsTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL){
            private Image bigAudioIcon;
            {
                this.bigAudioIcon = GUIMediator.getThemeImage("audio128x128").getImage();
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (LibraryPlaylistsTableMediator.this.TABLE.getRowCount() == 0) {
                    LibraryPlaylistsTableMediator.this.drawHelpGraphics(graphics, this.bigAudioIcon);
                } else {
                    super.paintComponent(graphics);
                }
            }
        };
        Action[] actionArray = new Action[]{LAUNCH_ACTION, OPEN_IN_FOLDER_ACTION, this.SEND_TO_FRIEND_ACTION, DELETE_ACTION, this.OPTIONS_ACTION};
        this.BUTTON_ROW = new ButtonRow(actionArray, 0, 14);
    }

    private void drawHelpGraphics(Graphics graphics, Image image) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 20;
        graphics2D.setStroke(new BasicStroke(6.0f, 1, 1, 10.0f, new float[]{16.0f, 20.0f}, 0.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.TABLE.getWidth(), this.TABLE.getHeight());
        graphics2D.setColor(ThemeMediator.CURRENT_THEME.getCustomUI().getDarkBorder());
        graphics2D.drawRoundRect(n, n, this.TABLE.getWidth() - n * 2, this.TABLE.getHeight() - n * 2, 6, 6);
        try {
            if (this.TABLE.getHeight() - n * 3 < image.getHeight(null)) {
                int n2 = this.TABLE.getHeight() - n * 2 - 5;
                if (n2 > 16) {
                    graphics2D.drawImage(image, (this.TABLE.getWidth() - n2) / 2, (this.TABLE.getHeight() - n2) / 2, n2, n2, null);
                }
            } else {
                graphics2D.drawImage(image, (this.TABLE.getWidth() - image.getWidth(null)) / 2, (this.TABLE.getHeight() - image.getHeight(null)) / 2, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        skinPopupMenu.add(new SkinMenuItem(LAUNCH_ACTION));
        skinPopupMenu.add(new SkinMenuItem(LAUNCH_OS_ACTION));
        if (this.hasExploreAction()) {
            skinPopupMenu.add(new SkinMenuItem(OPEN_IN_FOLDER_ACTION));
        }
        skinPopupMenu.add(new SkinMenuItem(CREATE_TORRENT_ACTION));
        skinPopupMenu.add(this.createAddToPlaylistSubMenu());
        skinPopupMenu.add(new SkinMenuItem(this.SEND_TO_FRIEND_ACTION));
        skinPopupMenu.add(new SkinMenuItem(SEND_TO_ITUNES_ACTION));
        ((JPopupMenu)skinPopupMenu).addSeparator();
        skinPopupMenu.add(new SkinMenuItem(DELETE_ACTION));
        int[] nArray = this.TABLE.getSelectedRows();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            File file = ((LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(nArray[i])).getFile();
            if (file.isDirectory()) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (bl && bl2) break;
        }
        if (bl) {
            DELETE_ACTION.setEnabled(true);
        } else {
            DELETE_ACTION.setEnabled(true);
        }
        ((JPopupMenu)skinPopupMenu).addSeparator();
        skinPopupMenu.add(new SkinMenuItem(this.importToPlaylistAction));
        skinPopupMenu.add(new SkinMenuItem(this.exportPlaylistAction));
        skinPopupMenu.add(new SkinMenuItem(this.cleanupPlaylistAction));
        skinPopupMenu.add(new SkinMenuItem(this.refreshID3TagsAction));
        ((JPopupMenu)skinPopupMenu).addSeparator();
        LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine = (LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(nArray[0]);
        skinPopupMenu.add(this.createSearchSubMenu(libraryPlaylistsTableDataLine));
        return skinPopupMenu;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (LibraryUtils.isRefreshKeyEvent(keyEvent)) {
                    LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
                }
            }
        });
    }

    private JMenu createSearchSubMenu(LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine) {
        File file;
        String string;
        SkinMenu skinMenu = new SkinMenu(I18n.tr("Search"));
        if (libraryPlaylistsTableDataLine != null && (string = QueryUtils.createQueryString((file = libraryPlaylistsTableDataLine.getFile()).getName())).length() > 0) {
            skinMenu.add(new SkinMenuItem(new SearchAction(string)));
        }
        if (skinMenu.getItemCount() == 0) {
            skinMenu.setEnabled(false);
        }
        return skinMenu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryPlaylistsTableMediator() {
        super("LIBRARY_PLAYLISTS_TABLE");
        this.setMediaType(MediaType.getAudioMediaType());
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setDropMode(DropMode.INSERT_ROWS);
        this.TABLE.setTransferHandler(new LibraryPlaylistsTableTransferHandler(this));
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(PlaylistItemProperty.class, new PlaylistItemPropertyRenderer());
        this.TABLE.setDefaultRenderer(PlaylistItemStar.class, new PlaylistItemStarRenderer());
        this.TABLE.setDefaultRenderer(LibraryNameHolder.class, new LibraryNameHolderRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellEditor(new PlaylistItemStarEditor());
        this.TABLE.addMouseMotionListener(new MouseMotionAdapter(){
            int currentCellColumn = -1;
            int currentCellRow = -1;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = LibraryPlaylistsTableMediator.this.TABLE.columnAtPoint(point);
                int n2 = LibraryPlaylistsTableMediator.this.TABLE.rowAtPoint(point);
                if (this.currentCellRow != n2 || this.currentCellColumn != n) {
                    if (LibraryPlaylistsTableMediator.this.TABLE.getCellRenderer(n2, n) instanceof PlaylistItemStarRenderer) {
                        LibraryPlaylistsTableMediator.this.TABLE.editCellAt(n2, n);
                    }
                    this.currentCellColumn = n;
                    this.currentCellRow = n2;
                }
            }
        });
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new LibraryNameHolderEditor());
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.TABLE.addMouseListener(mouseInputListener);
        this.TABLE.addMouseMotionListener(mouseInputListener);
    }

    void updateTableItems(Playlist playlist) {
        if (playlist == null) {
            return;
        }
        this.currentPlaylist = playlist;
        List<PlaylistItem> list = this.currentPlaylist.getItems();
        this.clearTable();
        for (int i = 0; i < list.size(); ++i) {
            this.addUnsorted(list.get(i));
        }
        this.forceResort();
    }

    File getFile(int n) {
        return ((LibraryPlaylistsTableModel)this.DATA_MODEL).getFile(n);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    LibraryPlaylistsTableDataLine[] getSelectedLibraryLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        LibraryPlaylistsTableDataLine[] libraryPlaylistsTableDataLineArray = new LibraryPlaylistsTableDataLine[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            libraryPlaylistsTableDataLineArray[i] = (LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(nArray[i]);
        }
        return libraryPlaylistsTableDataLineArray;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void startRename() {
        int n = this.TABLE.getSelectedRow();
        if (n == -1) {
            return;
        }
    }

    void showLicenseWindow() {
    }

    @Override
    public void removeSelection() {
        LibraryPlaylistsTableDataLine[] libraryPlaylistsTableDataLineArray = this.getSelectedLibraryLines();
        if (this.currentPlaylist != null && this.currentPlaylist.getId() == -3) {
            for (LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine : libraryPlaylistsTableDataLineArray) {
                PlaylistItem playlistItem = (PlaylistItem)libraryPlaylistsTableDataLine.getInitializeObject();
                playlistItem.setStarred(false);
                playlistItem.save();
            }
            LibraryMediator.instance().getLibraryExplorer().refreshSelection();
        } else {
            for (LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine : libraryPlaylistsTableDataLineArray) {
                PlaylistItem playlistItem = (PlaylistItem)libraryPlaylistsTableDataLine.getInitializeObject();
                playlistItem.delete();
            }
            LibraryMediator.instance().getLibraryPlaylists().reselectPlaylist();
            this.clearSelection();
        }
        super.removeSelection();
    }

    @Override
    public void handleActionKey() {
        this.playSong();
    }

    private void playSong() {
        LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine = (LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (libraryPlaylistsTableDataLine == null) {
            return;
        }
        AudioSource audioSource = new AudioSource(libraryPlaylistsTableDataLine.getPlayListItem());
        if (AudioPlayer.isPlayableFile(audioSource)) {
            AudioPlayer.instance().asyncLoadSong(audioSource, true, true, this.currentPlaylist, this.getFileView());
        }
    }

    void launch(boolean bl) {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        File file = ((LibraryPlaylistsTableModel)this.DATA_MODEL).getFile(nArray[0]);
        if (OSUtils.isWindows()) {
            if (file.isDirectory()) {
                GUIMediator.launchExplorer(file);
                return;
            }
            if (!AudioPlayer.isPlayableFile(file)) {
                GUIMediator.launchFile(file);
                return;
            }
        }
        GUILauncher.LaunchableProvider[] launchableProviderArray = new GUILauncher.LaunchableProvider[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            launchableProviderArray[i] = new FileProvider(((LibraryPlaylistsTableModel)this.DATA_MODEL).getFile(nArray[i]));
        }
        if (!bl) {
            AudioPlayer.instance().stop();
        }
        if (bl) {
            GUILauncher.launch(launchableProviderArray);
        } else {
            GUIMediator.launchFile(file);
        }
    }

    @Override
    public void handleSelection(int n) {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            this.handleNoSelection();
            return;
        }
        File file = this.getFile(nArray[0]);
        LAUNCH_ACTION.setEnabled(true);
        LAUNCH_OS_ACTION.setEnabled(true);
        DELETE_ACTION.setEnabled(true);
        SEND_TO_ITUNES_ACTION.setEnabled(true);
        if (file != null && !file.getName().endsWith(".torrent")) {
            CREATE_TORRENT_ACTION.setEnabled(nArray.length == 1);
        }
        if (file != null) {
            this.SEND_TO_FRIEND_ACTION.setEnabled(nArray.length == 1);
        }
        if (nArray.length == 1 && file.isFile() && file.getParentFile() != null) {
            OPEN_IN_FOLDER_ACTION.setEnabled(true);
        } else {
            OPEN_IN_FOLDER_ACTION.setEnabled(false);
        }
        if (nArray.length == 1) {
            LibraryMediator.instance().getLibraryCoverArt().setFile(this.getSelectedLibraryLines()[0].getFile());
        }
    }

    @Override
    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        LAUNCH_OS_ACTION.setEnabled(false);
        OPEN_IN_FOLDER_ACTION.setEnabled(false);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        CREATE_TORRENT_ACTION.setEnabled(false);
        DELETE_ACTION.setEnabled(false);
        SEND_TO_ITUNES_ACTION.setEnabled(false);
    }

    public void setPlayerEnabled(boolean bl) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    private boolean hasExploreAction() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    @Override
    public List<AudioSource> getFileView() {
        int n = ((LibraryPlaylistsTableModel)this.DATA_MODEL).getRowCount();
        ArrayList<AudioSource> arrayList = new ArrayList<AudioSource>(n);
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.add(new AudioSource(((LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(i)).getPlayListItem()));
                continue;
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
        return arrayList;
    }

    @Override
    protected void sortAndMaintainSelection(int n) {
        super.sortAndMaintainSelection(n);
        this.resetAudioPlayerFileView();
    }

    private void resetAudioPlayerFileView() {
        Playlist playlist = AudioPlayer.instance().getCurrentPlaylist();
        if (playlist != null && playlist.equals(this.currentPlaylist) && AudioPlayer.instance().getPlaylistFilesView() != null) {
            AudioPlayer.instance().setPlaylistFilesView(this.getFileView());
        }
    }

    @Override
    protected AudioSource createAudioSource(LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine) {
        return new AudioSource((PlaylistItem)libraryPlaylistsTableDataLine.getInitializeObject());
    }

    private final class RefreshID3TagsAction
    extends AbstractAction {
        private static final long serialVersionUID = 758150680592618044L;

        public RefreshID3TagsAction() {
            this.putValue("Name", I18n.tr("Refresh Audio Properties"));
            this.putValue("ShortDescription", I18n.tr("Refresh the audio properties based on ID3 tags"));
            this.putValue("LimeIconName", "PLAYLIST_REFRESHID3TAGS");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylistsTableDataLine[] libraryPlaylistsTableDataLineArray = LibraryPlaylistsTableMediator.this.getSelectedLibraryLines();
            ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(libraryPlaylistsTableDataLineArray.length);
            for (LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine : libraryPlaylistsTableDataLineArray) {
                arrayList.add((PlaylistItem)libraryPlaylistsTableDataLine.getInitializeObject());
            }
            LibraryUtils.refreshID3Tags(LibraryPlaylistsTableMediator.this.currentPlaylist, arrayList);
        }
    }

    private final class CleanupPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 8400749433148927596L;

        public CleanupPlaylistAction() {
            this.putValue("Name", I18n.tr("Cleanup playlist"));
            this.putValue("ShortDescription", I18n.tr("Remove the deleted items"));
            this.putValue("LimeIconName", "PLAYLIST_CLEANUP");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryUtils.cleanup(LibraryPlaylistsTableMediator.this.currentPlaylist);
            LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
        }
    }

    private final class ExportPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 6149822357662730490L;

        public ExportPlaylistAction() {
            this.putValue("Name", I18n.tr("Export Playlist to .m3u"));
            this.putValue("ShortDescription", I18n.tr("Export this playlist into a .m3u file"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryMediator.instance().getLibraryPlaylists().exportM3U(LibraryPlaylistsTableMediator.this.currentPlaylist);
        }
    }

    private final class ImportToPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = -9099898749358019734L;

        public ImportToPlaylistAction() {
            this.putValue("Name", I18n.tr("Import .m3u to Playlist"));
            this.putValue("ShortDescription", I18n.tr("Import a .m3u file into the selected playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_TO");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryMediator.instance().getLibraryPlaylists().importM3U(LibraryPlaylistsTableMediator.this.currentPlaylist);
        }
    }

    private static class FileProvider
    implements GUILauncher.LaunchableProvider {
        private final File _file;

        public FileProvider(File file) {
            this._file = file;
        }

        @Override
        public File getFile() {
            return this._file;
        }
    }

    private final class RemoveFromPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = -8704093935791256631L;

        public RemoveFromPlaylistAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Selected Files from this playlist"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylistsTableMediator.this.REMOVE_LISTENER.actionPerformed(actionEvent);
        }
    }

    private class SendAudioFilesToiTunes
    extends AbstractAction {
        private static final long serialVersionUID = 4726989286129406765L;

        public SendAudioFilesToiTunes() {
            this.putValue("Name", I18n.tr("Send to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Send audio files to iTunes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryPlaylistsTableMediator.this.TABLE.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                File file = ((LibraryPlaylistsTableModel)LibraryPlaylistsTableMediator.this.DATA_MODEL).getFile(n);
                iTunesMediator.instance().scanForSongs(file);
            }
        }
    }

    private final class CreateTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1898917632888388860L;

        public CreateTorrentAction() {
            super(I18n.tr("Create New Torrent"));
            this.putValue("LongDescription", I18n.tr("Create a new .torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = ((LibraryPlaylistsTableModel)LibraryPlaylistsTableMediator.this.DATA_MODEL).getFile(LibraryPlaylistsTableMediator.this.TABLE.getSelectedRow());
            if (file.isDirectory() && file.listFiles().length == 0) {
                JOptionPane.showMessageDialog(null, I18n.tr("The folder you selected is empty."), I18n.tr("Invalid Folder"), 0);
                return;
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(null, I18n.tr("Error: You can't read on that file/folder."), I18n.tr("Error"), 0);
                return;
            }
            CreateTorrentDialog createTorrentDialog = new CreateTorrentDialog(GUIMediator.getAppFrame());
            createTorrentDialog.setChosenContent(file);
            createTorrentDialog.setVisible(true);
        }
    }

    private final class OpenInFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1693310684299300459L;

        public OpenInFolderAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryPlaylistsTableMediator.this.TABLE.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            File file = LibraryPlaylistsTableMediator.this.getFile(nArray[0]);
            if (file.isFile() && file.getParentFile() != null) {
                GUIMediator.launchExplorer(file);
            }
        }
    }

    private final class LaunchOSAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392592L;

        public LaunchOSAction() {
            String string = "OS";
            if (OSUtils.isWindows()) {
                string = "Windows";
            } else if (OSUtils.isMacOSX()) {
                string = "Mac";
            } else if (OSUtils.isLinux()) {
                string = "Linux";
            }
            this.putValue("Name", I18n.tr("Launch in ") + string);
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files in " + string));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylistsTableMediator.this.launch(false);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392591L;

        public LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPlaylistsTableMediator.this.launch(true);
        }
    }
}

