/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.limewire.util.OSUtils;

class LibraryPlaylistsTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -360187293186425556L;
    private final LibraryPlaylistsTableMediator mediator;
    private final TransferHandler fallbackTransferHandler;

    public LibraryPlaylistsTableTransferHandler(LibraryPlaylistsTableMediator libraryPlaylistsTableMediator) {
        this.mediator = libraryPlaylistsTableMediator;
        this.fallbackTransferHandler = new MulticastTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLERS);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return this.canImport(transferSupport, true);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport, false)) {
            return this.fallbackTransferHandler.importData(transferSupport);
        }
        try {
            Transferable transferable;
            JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
            int n = dropLocation.getRow();
            int n2 = this.mediator.getTable().getModel().getRowCount();
            if (n < 0 || n > n2) {
                n = n2;
            }
            if (DNDUtils.contains((transferable = transferSupport.getTransferable()).getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                if (this.mediator.getCurrentPlaylist() != null) {
                    this.importPlaylistItemArrayData(transferable, n);
                }
            } else if (this.mediator.getCurrentPlaylist() != null) {
                File[] fileArray = DNDUtils.getFiles(transferSupport.getTransferable());
                if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.asyncAddToPlaylist(this.mediator.getCurrentPlaylist(), fileArray[0], n);
                } else {
                    LibraryUtils.asyncAddToPlaylist(this.mediator.getCurrentPlaylist(), fileArray, n);
                }
            }
        }
        catch (Exception exception) {
            return this.fallbackTransferHandler.importData(transferSupport);
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 0x40000003;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        List list = this.mediator.getSelectedLines();
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add((PlaylistItem)list.get(i).getInitializeObject());
        }
        return new LibraryPlaylistsTableTransferable(arrayList);
    }

    private boolean canImport(TransferHandler.TransferSupport transferSupport, boolean bl) {
        if (!this.mediator.getMediaType().equals(MediaType.getAudioMediaType())) {
            return bl ? this.fallbackTransferHandler.canImport(transferSupport) : false;
        }
        if (this.mediator.getCurrentPlaylist() != null && this.mediator.getCurrentPlaylist().getId() == -3) {
            return false;
        }
        if (transferSupport.isDataFlavorSupported(LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
            return true;
        }
        if (DNDUtils.containsFileFlavors(transferSupport.getDataFlavors())) {
            if (OSUtils.isMacOSX()) {
                return true;
            }
            try {
                File[] fileArray;
                for (File file : fileArray = DNDUtils.getFiles(transferSupport.getTransferable())) {
                    if (AudioPlayer.isPlayableFile(file)) {
                        return true;
                    }
                    if (!file.isDirectory() || !LibraryUtils.directoryContainsAudio(file)) continue;
                    return true;
                }
                if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                    return true;
                }
                return bl ? this.fallbackTransferHandler.canImport(transferSupport) : false;
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                return true;
            }
            catch (Exception exception) {
                return bl ? this.fallbackTransferHandler.canImport(transferSupport) : false;
            }
        }
        return false;
    }

    private void importPlaylistItemArrayData(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
        PlaylistItem[] playlistItemArray = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
        LibraryUtils.asyncAddToPlaylist(this.mediator.getCurrentPlaylist(), playlistItemArray, n);
    }
}

