/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryUtils;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LibraryPlaylistsTableTransferable
implements Transferable {
    public static final DataFlavor ITEM_ARRAY = new DataFlavor(Item[].class, "LibraryPlaylistTransferable.Item Array");
    private final List<Item> items;
    private final FileTransferable fileTransferable;

    public LibraryPlaylistsTableTransferable(List<PlaylistItem> list) {
        this.items = LibraryUtils.convertToItems(list);
        ArrayList<File> arrayList = new ArrayList<File>(this.items.size());
        for (PlaylistItem playlistItem : list) {
            arrayList.add(new File(playlistItem.getFilePath()));
        }
        this.fileTransferable = new FileTransferable(arrayList);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
        arrayList.addAll(Arrays.asList(this.fileTransferable.getTransferDataFlavors()));
        arrayList.add(ITEM_ARRAY);
        return arrayList.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(ITEM_ARRAY) || this.fileTransferable.isDataFlavorSupported(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(ITEM_ARRAY)) {
            return this.items.toArray(new Item[0]);
        }
        return this.fileTransferable.getTransferData(dataFlavor);
    }

    public static final class Item
    implements Serializable {
        private static final long serialVersionUID = 928701185904989565L;
        public int id;
        public String filePath;
        public String fileName;
        public long fileSize;
        public String fileExtension;
        public String trackTitle;
        public float trackDurationInSecs;
        public String trackArtist;
        public String trackAlbum;
        public String coverArtPath;
        public String trackBitrate;
        public String trackComment;
        public String trackGenre;
        public String trackNumber;
        public String trackYear;
        public boolean starred;
    }
}

