/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.limewire.util.OSUtils;

class LibraryPlaylistsTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -3874985752229848555L;
    private final JList list;

    public LibraryPlaylistsTransferHandler(JList jList) {
        this.list = jList;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDataFlavorSupported(LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
            return true;
        }
        if (DNDUtils.containsFileFlavors(transferSupport.getDataFlavors())) {
            if (OSUtils.isMacOSX()) {
                return true;
            }
            try {
                File[] fileArray;
                for (File file : fileArray = DNDUtils.getFiles(transferSupport.getTransferable())) {
                    if (AudioPlayer.isPlayableFile(file)) {
                        return true;
                    }
                    if (!file.isDirectory() || !LibraryUtils.directoryContainsAudio(file)) continue;
                    return true;
                }
                if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                    return true;
                }
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        TransferHandler.DropLocation dropLocation = transferSupport.getDropLocation();
        int n = this.list.locationToIndex(dropLocation.getDropPoint());
        if (n != -1) {
            LibraryPlaylists.LibraryPlaylistsListCell libraryPlaylistsListCell;
            Playlist playlist;
            Rectangle rectangle = this.list.getUI().getCellBounds(this.list, n, n);
            if (!rectangle.contains(dropLocation.getDropPoint())) {
                n = 0;
            }
            if ((playlist = (libraryPlaylistsListCell = (LibraryPlaylists.LibraryPlaylistsListCell)this.list.getModel().getElementAt(n)).getPlaylist()) == null) {
                try {
                    Transferable transferable = transferSupport.getTransferable();
                    if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                        PlaylistItem[] playlistItemArray = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                        LibraryUtils.createNewPlaylist(playlistItemArray);
                    } else {
                        File[] fileArray = DNDUtils.getFiles(transferSupport.getTransferable());
                        if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                            LibraryUtils.createNewPlaylist(fileArray[0]);
                        } else {
                            LibraryUtils.createNewPlaylist(fileArray);
                        }
                    }
                    this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
                    LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
                }
                catch (Exception exception) {
                    return false;
                }
            } else {
                try {
                    Transferable transferable = transferSupport.getTransferable();
                    if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                        PlaylistItem[] playlistItemArray = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                        LibraryUtils.asyncAddToPlaylist(playlist, playlistItemArray);
                    }
                    File[] fileArray = DNDUtils.getFiles(transferSupport.getTransferable());
                    if (fileArray.length == 1 && fileArray[0].getAbsolutePath().endsWith(".m3u")) {
                        LibraryUtils.asyncAddToPlaylist(playlist, fileArray[0]);
                    }
                    LibraryUtils.asyncAddToPlaylist(playlist, fileArray);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 0x40000003;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        LibraryPlaylists.LibraryPlaylistsListCell libraryPlaylistsListCell = (LibraryPlaylists.LibraryPlaylistsListCell)this.list.getSelectedValue();
        if (libraryPlaylistsListCell != null && libraryPlaylistsListCell.getPlaylist() != null && libraryPlaylistsListCell.getPlaylist().getItems().size() > 0) {
            return new LibraryPlaylistsTableTransferable(libraryPlaylistsListCell.getPlaylist().getItems());
        }
        return null;
    }
}

