/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.LibraryUtils;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.InternetRadioStationDB;
import com.frostwire.alexandria.db.LibraryDB;
import com.frostwire.alexandria.db.PlaylistItemDB;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.components.SearchField;
import com.frostwire.gui.components.searchfield.JXSearchField;
import com.frostwire.gui.library.Device;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.InternetRadioDirectoryHolder;
import com.frostwire.gui.library.LibraryDeviceTableMediator;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryInternetRadioTableMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.LibrarySettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.limewire.util.StringUtils;

public class LibrarySearch
extends JPanel {
    private static final long serialVersionUID = 2266243762191789491L;
    private JLabel statusLabel;
    private SearchField searchField;
    private SearchRunnable currentSearchRunnable;
    private int resultsCount;
    private String status;

    public LibrarySearch() {
        this.setupUI();
    }

    public void searchFor(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
                LibraryMediator.instance().getLibraryExplorer().selectFinishedDownloads();
                if (LibrarySearch.this.searchField != null) {
                    SearchLibraryAction searchLibraryAction = new SearchLibraryAction();
                    if (string.length() < 50) {
                        LibrarySearch.this.searchField.setText(string);
                    } else {
                        LibrarySearch.this.searchField.setText(string.substring(0, 49));
                    }
                    searchLibraryAction.actionPerformed(null);
                }
            }
        });
    }

    public void addResults(int n) {
        if (n < 0) {
            return;
        }
        this.resultsCount += n;
        this.setStatus(this.resultsCount + " " + I18n.tr("search results"));
    }

    public void clear() {
        this.setStatus("");
        this.searchField.setText("");
        this.resultsCount = 0;
    }

    public void pushStatus(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                LibrarySearch.this.statusLabel.setText(string);
            }
        });
    }

    public void revertStatus() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                LibrarySearch.this.statusLabel.setText(LibrarySearch.this.status);
            }
        });
    }

    public void setStatus(String string) {
        this.status = string;
        this.statusLabel.setText(string);
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setMinimumSize(new Dimension(200, 20));
        this.setPreferredSize(new Dimension(200, 20));
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 0));
        this.add((Component)this.statusLabel, "Center");
        this.searchField = new SearchField();
        this.searchField.setSearchMode(JXSearchField.SearchMode.INSTANT);
        this.searchField.setInstantSearchDelay(50);
        this.searchField.addActionListener(new ActionListener(){
            private SearchLibraryAction a;
            {
                this.a = new SearchLibraryAction();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LibrarySearch.this.searchField.getText().length() == 0) {
                    this.a.perform(".");
                } else {
                    this.a.actionPerformed(null);
                }
            }
        });
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder() == null && LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist() == null && LibraryMediator.instance().getLibraryExplorer().getSelectedDeviceFiles() == null) {
                    LibraryMediator.instance().getLibraryExplorer().selectAudio();
                }
            }
        });
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public void setSearchPrompt(String string) {
        this.searchField.setPrompt(I18n.tr("Search in ") + string);
    }

    private final class SearchInternetRadioStationsRunnable
    extends SearchRunnable {
        private final String query;

        public SearchInternetRadioStationsRunnable(String string) {
            this.query = string;
            this.canceled = false;
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    LibraryInternetRadioTableMediator.instance().clearTable();
                    LibrarySearch.this.setStatus("");
                    LibrarySearch.this.statusLabel.setText("");
                    LibrarySearch.this.resultsCount = 0;
                }
            });
            this.search();
        }

        private void search() {
            if (this.canceled) {
                return;
            }
            String string = null;
            List<List<Object>> list = null;
            if (StringUtils.isNullOrEmpty(this.query, true) || this.query.equals(".")) {
                LibraryMediator.instance().getLibraryExplorer().selectRadio();
                return;
            }
            Object object = LibraryUtils.wildcardLuceneQuery(this.query);
            string = "SELECT T.internetRadioStationId, T.name, T.description, T.url, T.bitrate, T.type, T.website, T.genre, T.pls, T.bookmarked FROM FTL_SEARCH_DATA(?, 0, 0) FT, INTERNETRADIOSTATIONS T WHERE FT.TABLE='INTERNETRADIOSTATIONS' AND T.internetRadioStationId = FT.KEYS[0]";
            list = ((LibraryDB)LibraryMediator.getLibrary().getDB()).getDatabase().query(string, object);
            object = new ArrayList();
            for (List<Object> list2 : list) {
                if (this.canceled) {
                    return;
                }
                InternetRadioStation internetRadioStation = new InternetRadioStation(LibraryMediator.getLibrary());
                ((InternetRadioStationDB)internetRadioStation.getDB()).fill(list2, internetRadioStation);
                object.add(internetRadioStation);
                if (object.size() <= 100) continue;
                Runnable runnable = new Runnable((List)object){
                    final /* synthetic */ List val$results;
                    {
                        this.val$results = list;
                    }

                    @Override
                    public void run() {
                        LibraryMediator.instance().addInternetRadioStationsToLibraryTable(this.val$results);
                        this.val$results.clear();
                    }
                };
                GUIMediator.safeInvokeLater(runnable);
            }
            Runnable runnable = new Runnable((List)object){
                final /* synthetic */ List val$results;
                {
                    this.val$results = list;
                }

                @Override
                public void run() {
                    LibraryMediator.instance().addInternetRadioStationsToLibraryTable(this.val$results);
                }
            };
            GUIMediator.safeInvokeLater(runnable);
        }
    }

    private final class SearchPlaylistItemsRunnable
    extends SearchRunnable {
        private final String query;
        private final Playlist playlist;

        public SearchPlaylistItemsRunnable(String string, Playlist playlist) {
            this.query = string;
            this.playlist = playlist;
            this.canceled = false;
            if (playlist == null) {
                this.canceled = true;
            }
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            GUIMediator.safeInvokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LibraryPlaylistsTableMediator.instance().clearTable();
                    LibrarySearch.this.setStatus("");
                    LibrarySearch.this.statusLabel.setText("");
                    LibrarySearch.this.resultsCount = 0;
                }
            });
            this.search();
        }

        private void search() {
            if (this.canceled || this.playlist == null) {
                return;
            }
            String string = null;
            List<List<Object>> list = null;
            if (StringUtils.isNullOrEmpty(this.query, true) || this.query.equals(".")) {
                if (this.playlist.isStarred()) {
                    LibraryMediator.instance().getLibraryExplorer().selectStarred();
                } else {
                    LibraryMediator.instance().getLibraryPlaylists().selectPlaylist(this.playlist);
                }
                return;
            }
            Object object = LibraryUtils.wildcardLuceneQuery(this.query);
            if (!this.playlist.isStarred()) {
                string = "SELECT T.playlistItemId, T.filePath, T.fileName, T.fileSize, T.fileExtension, T.trackTitle, T.trackDurationInSecs, T.trackArtist, T.trackAlbum, T.coverArtPath, T.trackBitrate, T.trackComment, T.trackGenre, T.trackNumber, T.trackYear, T.starred FROM FTL_SEARCH_DATA(?, 0, 0) FT, PLAYLISTITEMS T WHERE FT.TABLE='PLAYLISTITEMS' AND T.playlistItemId = FT.KEYS[0] AND T.playlistId = ?";
                list = ((LibraryDB)LibraryMediator.getLibrary().getDB()).getDatabase().query(string, object, this.playlist.getId());
            } else {
                string = "SELECT T.playlistItemId, T.filePath, T.fileName, T.fileSize, T.fileExtension, T.trackTitle, T.trackDurationInSecs, T.trackArtist, T.trackAlbum, T.coverArtPath, T.trackBitrate, T.trackComment, T.trackGenre, T.trackNumber, T.trackYear, T.starred FROM FTL_SEARCH_DATA(?, 0, 0) FT, PLAYLISTITEMS T WHERE FT.TABLE='PLAYLISTITEMS' AND T.playlistItemId = FT.KEYS[0] AND T.starred = TRUE";
                list = ((LibraryDB)LibraryMediator.getLibrary().getDB()).getDatabase().query(string, object);
            }
            object = new ArrayList();
            for (List<Object> list2 : list) {
                if (this.canceled) {
                    return;
                }
                Playlist playlist = LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist();
                if (!this.playlist.isStarred() && !this.playlist.equals(playlist)) {
                    return;
                }
                PlaylistItem playlistItem = new PlaylistItem(null);
                ((PlaylistItemDB)playlistItem.getDB()).fill(list2, playlistItem);
                object.add(playlistItem);
                if (object.size() <= 100) continue;
                Runnable runnable = new Runnable((List)object){
                    final /* synthetic */ List val$results;
                    {
                        this.val$results = list;
                    }

                    @Override
                    public void run() {
                        LibraryMediator.instance().addItemsToLibraryTable(this.val$results);
                        this.val$results.clear();
                    }
                };
                GUIMediator.safeInvokeLater(runnable);
            }
            Runnable runnable = new Runnable((List)object){
                final /* synthetic */ List val$results;
                {
                    this.val$results = list;
                }

                @Override
                public void run() {
                    LibraryMediator.instance().addItemsToLibraryTable(this.val$results);
                }
            };
            GUIMediator.safeInvokeLater(runnable);
        }
    }

    private static final class SearchFileFilter
    implements FileFilter {
        private final String[] _tokens;

        public SearchFileFilter(String string) {
            this._tokens = StringUtils.removeDoubleSpaces(string).toLowerCase(Locale.US).split(" ");
        }

        @Override
        public boolean accept(File file) {
            return this.accept(file, true);
        }

        public boolean accept(File file, boolean bl) {
            if (file.isDirectory() && bl) {
                return true;
            }
            String string = file.getAbsolutePath();
            for (String string2 : this._tokens) {
                if (string.toLowerCase(Locale.US).contains(string2)) continue;
                return false;
            }
            return true;
        }
    }

    private final class SearchFilesRunnable
    extends SearchRunnable {
        private final String _query;
        private final DirectoryHolder directoryHolder;

        public SearchFilesRunnable(String string) {
            this._query = string;
            this.directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
            this.canceled = false;
            if (this.directoryHolder == null) {
                this.canceled = true;
            }
        }

        @Override
        public void run() {
            Collection<File> collection;
            if (this.canceled) {
                return;
            }
            if (this._query.equals(".") && this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LibraryMediator.instance().updateTableFiles(SearchFilesRunnable.this.directoryHolder);
                        LibrarySearch.this.setStatus("");
                        LibrarySearch.this.resultsCount = 0;
                    }
                });
                return;
            }
            GUIMediator.safeInvokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LibraryFilesTableMediator.instance().clearTable();
                    LibrarySearch.this.statusLabel.setText("");
                    LibrarySearch.this.resultsCount = 0;
                }
            });
            if (this.directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder) {
                collection = new ArrayList<File>(((MediaTypeSavedFilesDirectoryHolder)this.directoryHolder).getCache());
                if (collection.size() > 0) {
                    this.search((List<File>)collection);
                    return;
                }
            } else if (this.directoryHolder instanceof SavedFilesDirectoryHolder && (collection = new ArrayList<File>(((SavedFilesDirectoryHolder)this.directoryHolder).getCache())).size() > 0) {
                this.search((List<File>)collection);
                return;
            }
            collection = TorrentUtil.getIgnorableFiles();
            if (this.directoryHolder instanceof TorrentDirectoryHolder) {
                this.search(((TorrentDirectoryHolder)this.directoryHolder).getDirectory(), (Set<File>)collection, LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                return;
            }
            if (this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                this.search(((SavedFilesDirectoryHolder)this.directoryHolder).getDirectory(), (Set<File>)collection, LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                return;
            }
            HashSet<File> hashSet = new HashSet<File>(LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue());
            hashSet.removeAll(LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
            for (File file : hashSet) {
                if (file == null || file.equals(LibrarySettings.USER_MUSIC_FOLDER) && this.directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder && !((MediaTypeSavedFilesDirectoryHolder)this.directoryHolder).getMediaType().equals(MediaType.getAudioMediaType())) continue;
                this.search(file, new HashSet<File>(), LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
            }
        }

        private void search(File file, Set<File> set, Set<File> set2) {
            if (this.canceled) {
                return;
            }
            if (file == null || !file.isDirectory() || !file.exists()) {
                return;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            final ArrayList<File> arrayList2 = new ArrayList<File>();
            SearchFileFilter searchFileFilter = new SearchFileFilter(this._query);
            for (File file2 : file.listFiles(searchFileFilter)) {
                if (this.canceled) {
                    return;
                }
                DirectoryHolder directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
                if (!this.directoryHolder.equals(directoryHolder)) {
                    return;
                }
                if (set.contains(file2) || file2.isHidden()) continue;
                if (file2.isDirectory() && !set2.contains(file2)) {
                    arrayList.add(file2);
                    continue;
                }
                if (!file2.isFile()) continue;
                if (this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                    if (!searchFileFilter.accept(file2, false)) continue;
                    arrayList2.add(file2);
                    continue;
                }
                if (!this.directoryHolder.accept(file2)) continue;
                arrayList2.add(file2);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().addFilesToLibraryTable(arrayList2);
                    if (SearchFilesRunnable.this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                        LibraryFilesTableMediator.instance().resetAudioPlayerFileView();
                    }
                }
            };
            GUIMediator.safeInvokeLater(runnable);
            for (File file3 : arrayList) {
                this.search(file3, set, set2);
            }
        }

        private void search(List<File> list) {
            if (this.canceled) {
                return;
            }
            final ArrayList<File> arrayList = new ArrayList<File>();
            SearchFileFilter searchFileFilter = new SearchFileFilter(this._query);
            for (File file : list) {
                if (this.canceled) {
                    return;
                }
                DirectoryHolder directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
                if (!this.directoryHolder.equals(directoryHolder)) {
                    return;
                }
                if (file.isHidden() || !searchFileFilter.accept(file)) continue;
                arrayList.add(file);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().addFilesToLibraryTable(arrayList);
                }
            };
            GUIMediator.safeInvokeLater(runnable);
        }
    }

    private abstract class SearchRunnable
    implements Runnable {
        protected boolean canceled;

        private SearchRunnable() {
        }

        public void cancel() {
            this.canceled = true;
        }
    }

    private class SearchLibraryAction
    extends AbstractAction {
        private static final long serialVersionUID = -2182314529781104010L;

        public SearchLibraryAction() {
            this.putValue("Name", I18n.tr("Search"));
        }

        public boolean validate(SearchInformation searchInformation) {
            switch (SearchMediator.validateInfo(searchInformation)) {
                case 1: {
                    return false;
                }
            }
            return true;
        }

        public void perform(String string) {
            Device device;
            DirectoryHolder directoryHolder;
            if (string.length() == 0) {
                LibrarySearch.this.searchField.getToolkit().beep();
                return;
            }
            SearchInformation searchInformation = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
            if (!this.validate(searchInformation)) {
                return;
            }
            LibrarySearch.this.searchField.addToDictionary();
            if (LibrarySearch.this.currentSearchRunnable != null) {
                LibrarySearch.this.currentSearchRunnable.cancel();
            }
            if ((directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder()) instanceof InternetRadioDirectoryHolder) {
                LibrarySearch.this.currentSearchRunnable = new SearchInternetRadioStationsRunnable(string);
                BackgroundExecutorService.schedule(LibrarySearch.this.currentSearchRunnable);
            } else if (directoryHolder != null && !(directoryHolder instanceof StarredDirectoryHolder)) {
                LibrarySearch.this.currentSearchRunnable = new SearchFilesRunnable(string);
                BackgroundExecutorService.schedule(LibrarySearch.this.currentSearchRunnable);
            }
            Playlist playlist = null;
            playlist = directoryHolder instanceof StarredDirectoryHolder ? LibraryMediator.getLibrary().getStarredPlaylist() : LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist();
            if (playlist != null) {
                LibrarySearch.this.currentSearchRunnable = new SearchPlaylistItemsRunnable(string, playlist);
                BackgroundExecutorService.schedule(LibrarySearch.this.currentSearchRunnable);
            }
            if ((device = LibraryMediator.instance().getLibraryExplorer().getSelectedDeviceFiles()) != null) {
                LibraryDeviceTableMediator.instance().filter(string);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = LibrarySearch.this.searchField.getText().trim();
            this.perform(string);
        }
    }
}

