/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.AudioMetaData;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryInternetRadioTableMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.M3UPlaylist;
import com.frostwire.gui.library.NameCalculator;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.FileUtils;
import org.limewire.util.FilenameUtils;
import org.limewire.util.StringUtils;

public class LibraryUtils {
    private static final Log LOG = LogFactory.getLog(LibraryUtils.class);
    private static final ExecutorService executor = ExecutorsHelper.newProcessingQueue("LibraryUtils-Executor");

    private static void addPlaylistItem(Playlist playlist, File file, boolean bl) {
        LibraryUtils.addPlaylistItem(playlist, file, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPlaylistItem(Playlist playlist, File file, boolean bl, int n) {
        try {
            LibraryMediator.instance().getLibrarySearch().pushStatus(I18n.tr("Importing") + " " + file.getName());
            AudioMetaData audioMetaData = new AudioMetaData(file);
            PlaylistItem playlistItem = playlist.newItem(file.getAbsolutePath(), file.getName(), file.length(), FileUtils.getFileExtension(file), audioMetaData.getTitle(), audioMetaData.getDurationInSecs(), audioMetaData.getArtist(), audioMetaData.getAlbum(), "", audioMetaData.getBitrate(), audioMetaData.getComment(), audioMetaData.getGenre(), audioMetaData.getTrack(), audioMetaData.getYear(), bl);
            List<PlaylistItem> list = playlist.getItems();
            if (n != -1 && n < list.size()) {
                list.add(n, playlistItem);
                playlistItem.save();
            } else {
                list.add(playlistItem);
                playlistItem.save();
                if (LibraryUtils.isPlaylistSelected(playlist)) {
                    LibraryPlaylistsTableMediator.instance().addUnsorted(playlistItem);
                }
            }
        }
        finally {
            LibraryMediator.instance().getLibrarySearch().revertStatus();
        }
    }

    public static String getSecondsInDDHHMMSS(int n) {
        if (n < 0) {
            n = 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n2 = n / 86400;
        int n3 = n % 86400;
        int n4 = n3 / 3600;
        n3 = n % 3600;
        int n5 = n3 / 60;
        int n6 = n3 % 60;
        string = String.valueOf(n2);
        string2 = n4 < 10 ? "0" + n4 : String.valueOf(n4);
        string3 = n5 < 10 ? "0" + n5 : String.valueOf(n5);
        String string5 = string4 = n6 < 10 ? "0" + n6 : String.valueOf(n6);
        if (n2 > 0) {
            stringBuilder.append(string);
            stringBuilder.append(" day");
            if (n2 > 1) {
                stringBuilder.append("s");
            }
            return stringBuilder.toString();
        }
        if (n4 > 0) {
            stringBuilder.append(string2);
            stringBuilder.append(":");
        }
        stringBuilder.append(string3);
        stringBuilder.append(":");
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public static void createNewPlaylist(final List<? extends AbstractLibraryTableDataLine<?>> list) {
        String string = (String)JOptionPane.showInputDialog(GUIMediator.getAppFrame(), I18n.tr("Playlist name"), I18n.tr("Playlist name"), -1, null, null, LibraryUtils.calculateName(list));
        if (string != null && string.length() > 0) {
            final Playlist playlist = LibraryMediator.getLibrary().newPlaylist(string, string);
            playlist.save();
            LibraryMediator.instance().getLibraryPlaylists().addPlaylist(playlist);
            LibraryMediator.instance().getLibraryPlaylists().markBeginImport(playlist);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    LibraryUtils.addToPlaylist(playlist, list);
                    playlist.save();
                    LibraryUtils.asyncAddToPlaylistFinalizer(playlist);
                }
            }, "createNewPlaylist");
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static void createNewPlaylist(File[] fileArray) {
        LibraryUtils.createNewPlaylist(fileArray, false);
    }

    public static void createNewPlaylist(final File[] fileArray, final boolean bl) {
        final StringBuilder stringBuilder = new StringBuilder();
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                String string = (String)JOptionPane.showInputDialog(GUIMediator.getAppFrame(), I18n.tr("Playlist name"), I18n.tr("Playlist name"), -1, null, null, LibraryUtils.calculateName(fileArray));
                if (!StringUtils.isNullOrEmpty(string, true)) {
                    stringBuilder.append(string);
                }
            }
        });
        String string = stringBuilder.toString();
        if (string != null && string.length() > 0) {
            GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
            final Playlist playlist = LibraryMediator.getLibrary().newPlaylist(string, string);
            playlist.save();
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().getLibraryPlaylists().addPlaylist(playlist);
                    LibraryMediator.instance().getLibraryPlaylists().markBeginImport(playlist);
                }
            });
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Set<File> set = TorrentUtil.getIgnorableFiles();
                        LibraryUtils.addToPlaylist(playlist, fileArray, bl, set);
                        playlist.save();
                    }
                    finally {
                        LibraryUtils.asyncAddToPlaylistFinalizer(playlist);
                    }
                }
            }, "createNewPlaylist");
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static void createNewPlaylist(PlaylistItem[] playlistItemArray) {
        LibraryUtils.createNewPlaylist(playlistItemArray, false);
    }

    public static void createNewPlaylist(final PlaylistItem[] playlistItemArray, boolean bl) {
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Playlist playlist = LibraryMediator.getLibrary().getStarredPlaylist();
                    LibraryUtils.addToPlaylist(playlist, playlistItemArray, true, -1);
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DirectoryHolder directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
                            if (directoryHolder instanceof StarredDirectoryHolder) {
                                LibraryMediator.instance().getLibraryExplorer().refreshSelection();
                            } else {
                                LibraryMediator.instance().getLibraryExplorer().selectStarred();
                            }
                        }
                    });
                }
            }, "createNewPlaylist");
            thread.setDaemon(true);
            thread.start();
        } else {
            String string = (String)JOptionPane.showInputDialog(GUIMediator.getAppFrame(), I18n.tr("Playlist name"), I18n.tr("Playlist name"), -1, null, null, LibraryUtils.calculateName(playlistItemArray));
            if (string != null && string.length() > 0) {
                final Playlist playlist = LibraryMediator.getLibrary().newPlaylist(string, string);
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            playlist.save();
                            LibraryUtils.addToPlaylist(playlist, playlistItemArray);
                            playlist.save();
                            GUIMediator.safeInvokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LibraryMediator.instance().getLibraryPlaylists().addPlaylist(playlist);
                                }
                            });
                        }
                        finally {
                            LibraryUtils.asyncAddToPlaylistFinalizer(playlist);
                        }
                    }
                }, "createNewPlaylist");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public static void createNewPlaylist(File file) {
        LibraryUtils.createNewPlaylist(file, false);
    }

    public static void createNewPlaylist(File file, boolean bl) {
        try {
            List<File> list = M3UPlaylist.load(file.getAbsolutePath());
            LibraryUtils.createNewPlaylist(list.toArray(new File[0]), bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void asyncAddToPlaylist(final Playlist playlist, final List<? extends AbstractLibraryTableDataLine<?>> list) {
        LibraryMediator.instance().getLibraryPlaylists().markBeginImport(playlist);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LibraryUtils.addToPlaylist(playlist, list);
                }
                finally {
                    LibraryUtils.asyncAddToPlaylistFinalizer(playlist);
                }
            }
        }, "asyncAddToPlaylist");
        thread.setDaemon(true);
        thread.start();
    }

    public static void asyncAddToPlaylist(Playlist playlist, File[] fileArray) {
        LibraryUtils.asyncAddToPlaylist(playlist, fileArray, -1);
    }

    public static void asyncAddToPlaylist(final Playlist playlist, final File[] fileArray, final int n) {
        LibraryMediator.instance().getLibraryPlaylists().markBeginImport(playlist);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Set<File> set = TorrentUtil.getIgnorableFiles();
                    LibraryUtils.addToPlaylist(playlist, fileArray, false, n, set);
                    playlist.save();
                }
                finally {
                    LibraryUtils.asyncAddToPlaylistFinalizer(playlist);
                }
            }
        }, "asyncAddToPlaylist");
        thread.setDaemon(true);
        thread.start();
    }

    private static void asyncAddToPlaylistFinalizer(final Playlist playlist) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.instance().getLibraryPlaylists().markEndImport(playlist);
                LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
                LibraryMediator.instance().getLibraryPlaylists().selectPlaylist(playlist);
            }
        });
    }

    public static void asyncAddToPlaylist(Playlist playlist, PlaylistItem[] playlistItemArray) {
        LibraryUtils.asyncAddToPlaylist(playlist, playlistItemArray, -1);
    }

    public static void asyncAddToPlaylist(final Playlist playlist, final PlaylistItem[] playlistItemArray, final int n) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LibraryUtils.addToPlaylist(playlist, playlistItemArray, n);
                playlist.save();
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
                    }
                });
            }
        }, "asyncAddToPlaylist");
        thread.setDaemon(true);
        thread.start();
    }

    public static void asyncAddToPlaylist(Playlist playlist, File file) {
        LibraryUtils.asyncAddToPlaylist(playlist, file, -1);
    }

    public static void asyncAddToPlaylist(Playlist playlist, File file, int n) {
        try {
            List<File> list = M3UPlaylist.load(file.getAbsolutePath());
            LibraryUtils.asyncAddToPlaylist(playlist, list.toArray(new File[0]), n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static List<LibraryPlaylistsTableTransferable.Item> convertToItems(List<PlaylistItem> list) {
        ArrayList<LibraryPlaylistsTableTransferable.Item> arrayList = new ArrayList<LibraryPlaylistsTableTransferable.Item>(list.size());
        for (PlaylistItem playlistItem : list) {
            LibraryPlaylistsTableTransferable.Item item = new LibraryPlaylistsTableTransferable.Item();
            item.id = playlistItem.getId();
            item.filePath = playlistItem.getFilePath();
            item.fileName = playlistItem.getFileName();
            item.fileSize = playlistItem.getFileSize();
            item.fileExtension = playlistItem.getFileExtension();
            item.trackTitle = playlistItem.getTrackTitle();
            item.trackDurationInSecs = playlistItem.getTrackDurationInSecs();
            item.trackArtist = playlistItem.getTrackArtist();
            item.trackAlbum = playlistItem.getTrackAlbum();
            item.coverArtPath = playlistItem.getCoverArtPath();
            item.trackBitrate = playlistItem.getTrackBitrate();
            item.trackComment = playlistItem.getTrackComment();
            item.trackGenre = playlistItem.getTrackGenre();
            item.trackNumber = playlistItem.getTrackNumber();
            item.trackYear = playlistItem.getTrackYear();
            item.starred = playlistItem.isStarred();
            arrayList.add(item);
        }
        return arrayList;
    }

    public static PlaylistItem[] convertToPlaylistItems(LibraryPlaylistsTableTransferable.Item[] itemArray) {
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(itemArray.length);
        for (LibraryPlaylistsTableTransferable.Item item : itemArray) {
            PlaylistItem playlistItem = new PlaylistItem(null, item.id, item.filePath, item.fileName, item.fileSize, item.fileExtension, item.trackTitle, item.trackDurationInSecs, item.trackArtist, item.trackAlbum, item.coverArtPath, item.trackBitrate, item.trackComment, item.trackGenre, item.trackNumber, item.trackYear, item.starred);
            arrayList.add(playlistItem);
        }
        return arrayList.toArray(new PlaylistItem[0]);
    }

    public static File[] convertToFiles(PlaylistItem[] playlistItemArray) {
        ArrayList<File> arrayList = new ArrayList<File>(playlistItemArray.length);
        for (PlaylistItem playlistItem : playlistItemArray) {
            arrayList.add(new File(playlistItem.getFilePath()));
        }
        return arrayList.toArray(new File[0]);
    }

    private static void addToPlaylist(Playlist playlist, List<? extends AbstractLibraryTableDataLine<?>> list) {
        for (int i = 0; i < list.size() && !playlist.isDeleted(); ++i) {
            AbstractLibraryTableDataLine<?> abstractLibraryTableDataLine = list.get(i);
            if (!AudioPlayer.isPlayableFile(abstractLibraryTableDataLine.getFile())) continue;
            LibraryUtils.addPlaylistItem(playlist, abstractLibraryTableDataLine.getFile(), false);
        }
    }

    private static int addToPlaylist(Playlist playlist, File[] fileArray, boolean bl, Set<File> set) {
        return LibraryUtils.addToPlaylist(playlist, fileArray, bl, -1, set);
    }

    private static int addToPlaylist(Playlist playlist, File[] fileArray, boolean bl, int n, Set<File> set) {
        int n2 = 0;
        for (int i = 0; i < fileArray.length && !playlist.isDeleted(); ++i) {
            if (AudioPlayer.isPlayableFile(fileArray[i]) && !set.contains(fileArray[i])) {
                LibraryUtils.addPlaylistItem(playlist, fileArray[i], bl, n + n2);
                ++n2;
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            n2 += LibraryUtils.addToPlaylist(playlist, fileArray[i].listFiles(), bl, n + n2, set);
        }
        return n2;
    }

    private static void addToPlaylist(Playlist playlist, PlaylistItem[] playlistItemArray) {
        LibraryUtils.addToPlaylist(playlist, playlistItemArray, false, -1);
    }

    private static void addToPlaylist(Playlist playlist, PlaylistItem[] playlistItemArray, int n) {
        LibraryUtils.addToPlaylist(playlist, playlistItemArray, false, n);
    }

    private static void addToPlaylist(Playlist playlist, PlaylistItem[] playlistItemArray, boolean bl, int n) {
        List<PlaylistItem> list = playlist.getItems();
        if (n != -1 && n <= list.size()) {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(playlistItemArray.length);
            for (n2 = 0; n2 < playlistItemArray.length && !playlist.isDeleted(); ++n2) {
                arrayList.add(playlistItemArray[n2].getId());
                playlistItemArray[n2].setId(-1);
                playlistItemArray[n2].setPlaylist(playlist);
                list.add(n + n2, playlistItemArray[n2]);
                if (!bl) continue;
                playlistItemArray[n2].setStarred(bl);
                playlistItemArray[n2].save();
            }
            block1: for (n2 = 0; n2 < arrayList.size() && !playlist.isDeleted(); ++n2) {
                int n3 = (Integer)arrayList.get(n2);
                for (int i = 0; i < list.size() && !playlist.isDeleted(); ++i) {
                    if (list.get(i).getId() != n3) continue;
                    list.remove(i);
                    continue block1;
                }
            }
        } else {
            for (int i = 0; i < playlistItemArray.length && !playlist.isDeleted(); ++i) {
                playlistItemArray[i].setPlaylist(playlist);
                list.add(playlistItemArray[i]);
                if (!bl) continue;
                playlistItemArray[i].setStarred(bl);
                playlistItemArray[i].save();
            }
        }
    }

    public static String getPlaylistDurationInDDHHMMSS(Playlist playlist) {
        List<PlaylistItem> list = playlist.getItems();
        float f = 0.0f;
        for (PlaylistItem playlistItem : list) {
            f += playlistItem.getTrackDurationInSecs();
        }
        return LibraryUtils.getSecondsInDDHHMMSS((int)f);
    }

    public static boolean directoryContainsAudio(File file, int n) {
        Set<File> set = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(file, n, set, AudioPlayer.getPlayableExtensions());
    }

    public static boolean directoryContainsAudio(File file) {
        Set<File> set = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(file, 4, set, AudioPlayer.getPlayableExtensions());
    }

    public static boolean directoryContainsExtension(File file, int n, String string) {
        Set<File> set = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(file, n, set, string);
    }

    public static boolean directoryContainsExtension(File file, String ... stringArray) {
        Set<File> set = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(file, 4, set, stringArray);
    }

    private static boolean directoryContainsExtension(File file, int n, Set<File> set, String ... stringArray) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        for (File file2 : file.listFiles()) {
            if (!(!file2.isDirectory() ? FilenameUtils.hasExtension(file2.getAbsolutePath(), stringArray) && !set.contains(file2) : n > 0 && LibraryUtils.directoryContainsExtension(file2, n - 1, set, stringArray))) continue;
            return true;
        }
        return false;
    }

    private static String calculateName(File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>(150);
        LibraryUtils.findNames(arrayList, fileArray);
        return new NameCalculator(arrayList).getName();
    }

    private static String calculateName(List<? extends AbstractLibraryTableDataLine<?>> list) {
        File[] fileArray = new File[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            fileArray[i] = list.get(i).getFile();
        }
        return LibraryUtils.calculateName(fileArray);
    }

    private static String calculateName(PlaylistItem[] playlistItemArray) {
        File[] fileArray = new File[playlistItemArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(playlistItemArray[i].getFilePath());
        }
        return LibraryUtils.calculateName(fileArray);
    }

    private static void findNames(List<String> list, File[] fileArray) {
        if (list.size() > 100) {
            return;
        }
        for (File file : fileArray) {
            String string;
            if (file.isDirectory()) {
                string = FilenameUtils.getBaseName(file.getAbsolutePath());
                list.add(string);
                LibraryUtils.findNames(list, file.listFiles());
                continue;
            }
            if (!AudioPlayer.isPlayableFile(file)) continue;
            string = FilenameUtils.getBaseName(file.getAbsolutePath());
            list.add(string);
        }
    }

    public static void cleanup(Playlist playlist) {
        if (playlist == null) {
            return;
        }
        try {
            for (PlaylistItem playlistItem : playlist.getItems()) {
                if (new File(playlistItem.getFilePath()).exists()) continue;
                playlistItem.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void refreshID3Tags(Playlist playlist) {
        LibraryUtils.refreshID3Tags(playlist, playlist.getItems());
    }

    public static void refreshID3Tags(final Playlist playlist, final List<PlaylistItem> list) {
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (PlaylistItem playlistItem : list) {
                    try {
                        LibraryMediator.instance().getLibrarySearch().pushStatus(I18n.tr("Refreshing") + " " + playlistItem.getTrackAlbum() + " - " + playlistItem.getTrackTitle());
                        File file = new File(playlistItem.getFilePath());
                        if (!file.exists()) continue;
                        AudioMetaData audioMetaData = new AudioMetaData(file);
                        LibraryMediator.getLibrary().updatePlaylistItemProperties(playlistItem.getFilePath(), audioMetaData.getTitle(), audioMetaData.getArtist(), audioMetaData.getAlbum(), audioMetaData.getComment(), audioMetaData.getGenre(), audioMetaData.getTrack(), audioMetaData.getYear());
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        LibraryMediator.instance().getLibrarySearch().revertStatus();
                    }
                }
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (playlist != null) {
                            if (playlist.getId() == -3) {
                                DirectoryHolder directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
                                if (directoryHolder instanceof StarredDirectoryHolder) {
                                    LibraryMediator.instance().getLibraryExplorer().refreshSelection();
                                }
                            } else {
                                Playlist playlist = LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist();
                                if (playlist != null && playlist.equals(playlist)) {
                                    LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private static boolean isPlaylistSelected(Playlist playlist) {
        Playlist playlist2 = LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist();
        return playlist2 != null && playlist2.equals(playlist);
    }

    public static boolean isRefreshKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isControlDown() || keyEvent.isAltGraphDown() || keyEvent.isMetaDown();
        return n == 116 || bl && n == 82;
    }

    public static void asyncAddRadioStation(final String string) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LibraryUtils.addRadioStation(string);
            }
        }, "ImportRadioStation");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRadioStation(final String string) {
        try {
            LibraryMediator.instance().getLibrarySearch().pushStatus(I18n.tr("Importing from") + " " + string);
            final InternetRadioStation internetRadioStation = LibraryUtils.processInternetRadioStationUrl(string);
            internetRadioStation.save();
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    LibraryInternetRadioTableMediator.instance().addUnsorted(internetRadioStation);
                    LibraryMediator.instance().getLibraryExplorer().selectRadio();
                    LibraryInternetRadioTableMediator.instance().selectItemAt(0);
                }
            });
        }
        catch (Throwable throwable) {
            LOG.error("Error adding radio station", throwable);
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(GUIMediator.getAppFrame(), I18n.tr("Error importing Radio Station from") + " " + string, I18n.tr("Error"), 0);
                }
            });
        }
        finally {
            LibraryMediator.instance().getLibrarySearch().revertStatus();
        }
    }

    private static InternetRadioStation processInternetRadioStationUrl(String string) throws Exception {
        String string2;
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setRequestProperty("User-Agent", "Java");
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = null;
        bufferedReader = uRLConnection.getContentEncoding() != null ? new BufferedReader(new InputStreamReader(inputStream, uRLConnection.getContentEncoding())) : new BufferedReader(new InputStreamReader(inputStream));
        String string3 = "";
        String[] stringArray = null;
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\n";
            if (string2.startsWith("File1=")) {
                String string4 = string2.split("=")[1];
                stringArray = LibraryUtils.processStreamUrl(string4);
            } else if (string2.startsWith("icy-name:")) {
                string3 = "";
                stringArray = LibraryUtils.processStreamUrl(string);
                break;
            }
            if (++n <= 10 || stringArray != null) continue;
        }
        inputStream.close();
        if (stringArray != null && stringArray[0] != null) {
            return LibraryMediator.getLibrary().newInternetRadioStation((String)stringArray[0], (String)stringArray[0], (String)stringArray[1], (String)stringArray[2], stringArray[3], stringArray[4], stringArray[5], string3, false);
        }
        return null;
    }

    private static String[] processStreamUrl(String string) throws Exception {
        String string2;
        URL uRL = new URL(string);
        System.out.print(" - " + string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setRequestProperty("User-Agent", "Java");
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = null;
        bufferedReader = uRLConnection.getContentEncoding() != null ? new BufferedReader(new InputStreamReader(inputStream, uRLConnection.getContentEncoding())) : new BufferedReader(new InputStreamReader(inputStream));
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; (string2 = bufferedReader.readLine()) != null && i < 10; ++i) {
            if (string2.startsWith("icy-name:")) {
                string3 = LibraryUtils.clean(string2.split(":")[1]);
                continue;
            }
            if (string2.startsWith("icy-genre:")) {
                string4 = LibraryUtils.clean(string2.split(":")[1]);
                continue;
            }
            if (string2.startsWith("icy-url:")) {
                string5 = string2.split("icy-url:")[1].trim();
                continue;
            }
            if (string2.startsWith("content-type:")) {
                String string8 = string2.split(":")[1].trim();
                if (string8.equals("audio/aacp")) {
                    string6 = "AAC+";
                    continue;
                }
                if (string8.equals("audio/mpeg")) {
                    string6 = "MP3";
                    continue;
                }
                if (!string8.equals("audio/aac")) continue;
                string6 = "AAC";
                continue;
            }
            if (!string2.startsWith("icy-br:")) continue;
            string7 = string2.split(":")[1].trim() + " kbps";
        }
        inputStream.close();
        return new String[]{string3, string, string7, string6, string5, string4};
    }

    private static String clean(String string) {
        return string.trim().replace("\"", "\\\"");
    }
}

