/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.limewire.util.FileUtils;
import org.limewire.util.IOUtils;

public final class M3UPlaylist {
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> load(String string) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            string2 = bufferedReader.readLine();
            if (string2 == null) throw new IOException();
            if (!string2.startsWith(M3U_HEADER) && !string2.startsWith(SONG_DELIM)) {
                throw new IOException();
            }
            if (string2.startsWith(M3U_HEADER)) {
                string2 = bufferedReader.readLine();
            }
            while (string2 != null) {
                if (string2.startsWith(SONG_DELIM)) {
                    string2 = bufferedReader.readLine();
                    if (string2 == null) break;
                    File file2 = new File(string2);
                    if (file2.exists() && !file2.isDirectory()) {
                        arrayList.add(file2);
                    } else {
                        file2 = new File(file.getParentFile().getAbsolutePath(), file2.getPath());
                        if (file2.exists() && !file2.isDirectory() && FileUtils.isReallyInParentPath(file.getParentFile(), file2)) {
                            arrayList.add(file2);
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close(bufferedReader);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String string, List<File> list) throws IOException {
        File file = new File(string);
        if (list.size() == 0) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file.getCanonicalPath(), false));
            printWriter.write(M3U_HEADER);
            printWriter.println();
            for (File file2 : list) {
                if (!file2.isFile()) continue;
                File file3 = new File(file2.toURI());
                printWriter.write(SONG_DELIM);
                printWriter.write(SEC_DELIM);
                printWriter.write("-1,");
                printWriter.write(file2.getName());
                printWriter.println();
                printWriter.write(file3.getCanonicalPath());
                printWriter.println();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(printWriter);
            throw throwable;
        }
        IOUtils.close(printWriter);
    }
}

