/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

class NameCalculator {
    private static final Pattern splitRegex = Pattern.compile("[~_ #-]");
    private final List<String> names;

    public NameCalculator(List<String> list) {
        this.names = list;
    }

    public String getName() {
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(this.names.size() * 4);
        for (String string : this.names) {
            String[] stringArray;
            for (String string2 : stringArray = splitRegex.split(string)) {
                if (string2.trim().length() == 0) continue;
                Pair pair = (Pair)hashMap.get(string2);
                if (pair != null) {
                    ++pair.frecuency;
                    continue;
                }
                pair = new Pair(string2);
                hashMap.put(string2, pair);
                arrayList.add(pair);
            }
        }
        Collections.sort(arrayList, new Comparator<Pair>(){

            @Override
            public int compare(Pair pair, Pair pair2) {
                return -Integer.valueOf(pair.frecuency).compareTo(pair2.frecuency);
            }
        });
        return this.getName(arrayList);
    }

    private String getName(List<Pair> list) {
        if (list.size() == 1) {
            return list.get((int)0).token;
        }
        if (list.size() == 2) {
            return list.get((int)0).token + " " + list.get((int)1).token;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size() && i < 3 && list.get((int)0).frecuency - list.get((int)i).frecuency <= 1; ++i) {
            stringBuilder.append(list.get((int)i).token);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    private class Pair {
        String token;
        int frecuency;

        public Pair(String string) {
            this.token = string;
            this.frecuency = 1;
        }

        public String toString() {
            return "(" + this.token + ":" + this.frecuency + ")";
        }
    }
}

