/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import org.limewire.util.StringUtils;

class PlaylistItemProperty
implements Comparable<PlaylistItemProperty> {
    private final String value;
    private final boolean playing;
    private final boolean exists;
    private final int columnIndex;

    public PlaylistItemProperty(String string, boolean bl, boolean bl2, int n) {
        this.value = string;
        this.playing = bl;
        this.exists = bl2;
        this.columnIndex = n;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public int compareTo(PlaylistItemProperty playlistItemProperty) {
        if ((playlistItemProperty == null || playlistItemProperty.value == null) && this.value != null) {
            return 1;
        }
        if (this.value == null && playlistItemProperty != null) {
            return -1;
        }
        if (this.value == null && playlistItemProperty == null) {
            return 0;
        }
        if (this.columnIndex == 7) {
            return this.compareByBitrate(playlistItemProperty);
        }
        if (this.columnIndex == 5) {
            return this.compareByTrack(playlistItemProperty);
        }
        return this.value.compareTo(playlistItemProperty.value);
    }

    private int compareByBitrate(PlaylistItemProperty playlistItemProperty) {
        if (StringUtils.isNullOrEmpty(this.value) && !StringUtils.isNullOrEmpty(playlistItemProperty.value)) {
            return 1;
        }
        if (!StringUtils.isNullOrEmpty(this.value) && StringUtils.isNullOrEmpty(playlistItemProperty.value)) {
            return -1;
        }
        if (StringUtils.isNullOrEmpty(this.value) && StringUtils.isNullOrEmpty(playlistItemProperty.value)) {
            return 0;
        }
        try {
            return Integer.valueOf(this.value.toLowerCase().replace("kbps", "").trim()).compareTo(Integer.valueOf(playlistItemProperty.value.toLowerCase().replace("kbps", "").trim()));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int compareByTrack(PlaylistItemProperty playlistItemProperty) {
        if (StringUtils.isNullOrEmpty(this.value) && !StringUtils.isNullOrEmpty(playlistItemProperty.value)) {
            return 1;
        }
        if (!StringUtils.isNullOrEmpty(this.value) && StringUtils.isNullOrEmpty(playlistItemProperty.value)) {
            return -1;
        }
        if (StringUtils.isNullOrEmpty(this.value) && StringUtils.isNullOrEmpty(playlistItemProperty.value)) {
            return 0;
        }
        try {
            return Integer.valueOf(this.value.toLowerCase().trim().replaceFirst("^0+(?!$)", "")).compareTo(Integer.valueOf(playlistItemProperty.value.toLowerCase().trim().replaceFirst("^0+(?!$)", "")));
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

