/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.PlaylistItemProperty;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.TableUI;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;

class PlaylistItemPropertyRenderer
extends SubstanceDefaultTableCellRenderer {
    private static final long serialVersionUID = 5077708462742409205L;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        PlaylistItemProperty playlistItemProperty = (PlaylistItemProperty)object;
        super.getTableCellRendererComponent(jTable, playlistItemProperty.getValue(), bl, bl2, n, n2);
        this.setFontColor(playlistItemProperty.isPlaying(), playlistItemProperty.exists(), jTable, n, n2);
        return this;
    }

    private void setFontColor(boolean bl, boolean bl2, JTable jTable, int n, int n2) {
        if (!bl2) {
            this.setForeground(ThemeSettings.FILE_NO_EXISTS_DATA_LINE_COLOR.getValue());
        } else if (bl) {
            this.setForeground(ThemeSettings.PLAYING_DATA_LINE_COLOR.getValue());
        } else {
            Color color = Color.BLACK;
            color = SubstanceLookAndFeel.isCurrentLookAndFeel() ? this.getSubstanceForegroundColor(jTable, n, n2) : UIManager.getColor("Table.foreground");
            this.setForeground(color);
        }
    }

    private Color getSubstanceForegroundColor(JTable jTable, int n, int n2) {
        TableUI tableUI = jTable.getUI();
        SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
        SubstanceTableUI.TableCellId tableCellId = new SubstanceTableUI.TableCellId(n, n2);
        ComponentState componentState = substanceTableUI.getCellState(tableCellId);
        SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
        return substanceColorScheme.getForegroundColor();
    }

    private SubstanceColorScheme getColorSchemeForState(JTable jTable, SubstanceTableUI substanceTableUI, ComponentState componentState) {
        UpdateOptimizationInfo updateOptimizationInfo = substanceTableUI.getUpdateOptimizationInfo();
        if (componentState == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme(jTable, componentState);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        }
        return updateOptimizationInfo.getHighlightColorScheme(componentState);
    }
}

