/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.library.PlaylistItemStar;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;

class PlaylistItemStarRenderer
extends SubstanceDefaultTableCellRenderer {
    private static final long serialVersionUID = 6800146830099830381L;
    private static final Icon starOn = GUIMediator.getThemeImage("star_on");
    private static final Icon starOff = GUIMediator.getThemeImage("star_off");
    private static final Icon speaker = GUIMediator.getThemeImage("speaker");
    private static final Icon exclamation = GUIMediator.getThemeImage("exclamation");

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        final LibraryPlaylistsTableDataLine libraryPlaylistsTableDataLine = ((PlaylistItemStar)object).getLine();
        final PlaylistItemStar playlistItemStar = (PlaylistItemStar)object;
        this.setIcon(playlistItemStar.isPlaying(), libraryPlaylistsTableDataLine.getPlayListItem().isStarred(), playlistItemStar.exists());
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PlaylistItemStarRenderer.this.setIcon(false, libraryPlaylistsTableDataLine.getPlayListItem().isStarred(), playlistItemStar.exists());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PlaylistItemStarRenderer.this.setIcon(playlistItemStar.isPlaying(), libraryPlaylistsTableDataLine.getPlayListItem().isStarred(), playlistItemStar.exists());
            }
        });
        return jLabel;
    }

    private void setIcon(boolean bl, boolean bl2, boolean bl3) {
        if (!bl3) {
            this.setIcon(exclamation);
        } else if (bl) {
            this.setIcon(speaker);
        } else if (bl2) {
            this.setIcon(starOn);
        } else {
            this.setIcon(starOff);
        }
    }
}

