/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.FileEntity;

public class ProgressFileEntity
extends FileEntity {
    private ProgressFileEntityListener _listener;

    public ProgressFileEntity(File file) {
        super(file, "binary/octet-stream");
        this.setChunked(true);
    }

    public ProgressFileEntityListener getProgressFileEntityListener() {
        return this._listener;
    }

    public void setProgressFileEntityListener(ProgressFileEntityListener progressFileEntityListener) {
        this._listener = progressFileEntityListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                this.fireOnWrite(n);
                if (this._listener == null || this._listener.isRunning()) continue;
            }
            outputStream.flush();
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    protected void fireOnWrite(int n) {
        if (this._listener != null) {
            this._listener.onWrite(this, n);
        }
    }

    public static interface ProgressFileEntityListener {
        public void onWrite(ProgressFileEntity var1, int var2);

        public boolean isRunning();
    }
}

