/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.trees.FileTreeModel;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.limewire.util.FileUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;

public class RecursiveLibraryDirectoryPanel
extends JPanel {
    private static final long serialVersionUID = 2342466847251833757L;
    private final FileTreeModel directoryTreeModel;
    private final JTree directoryTree;
    private final Set<File> deselected;
    private final Set<File> roots;
    private final JPanel legendPanel;
    private final JPanel mainPanel;
    private final FileTreeCellRenderer fileTreeCellRenderer = new FileTreeCellRenderer();
    private final Icon partiallyIncludedIcon = RecursiveLibraryDirectoryPanel.createPartiallyIncludedIcon();

    private static Set<File> emptyFileSet() {
        return Collections.emptySet();
    }

    private static Icon createPartiallyIncludedIcon() {
        if (ThemeSettings.isNativeOSXTheme()) {
            return GUIMediator.getThemeImage("sharing_checkbox_aqua");
        }
        Icon icon = UIManager.getIcon("CheckBox.icon");
        if (icon == null || icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
            icon = MetalIconFactory.getCheckBoxIcon();
        }
        return RecursiveLibraryDirectoryPanel.createDisabledIcon(RecursiveLibraryDirectoryPanel.configureCheckBox(new JCheckBox()), icon);
    }

    public RecursiveLibraryDirectoryPanel(boolean bl, File ... fileArray) {
        this(bl, RecursiveLibraryDirectoryPanel.emptyFileSet(), fileArray);
    }

    public RecursiveLibraryDirectoryPanel(boolean bl, Set<File> set, File ... fileArray) {
        super(new BorderLayout());
        this.roots = new TreeSet<File>(FileTreeModel.DEFAULT_COMPARATOR);
        this.deselected = new HashSet<File>(set);
        if (!bl) {
            this.addFoldersToExclude(new HashSet<File>(Arrays.asList(fileArray)));
        }
        this.directoryTreeModel = new FileTreeModel("", new File[0]);
        this.directoryTreeModel.setFileFilter(new IncludedFolderFilter());
        this.directoryTree = new RootNotEditableTree(this.directoryTreeModel);
        this.directoryTree.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.directoryTree.setCellRenderer(this.fileTreeCellRenderer);
        this.directoryTree.setCellEditor(new FileTreeCellEditor());
        this.directoryTree.setEditable(true);
        this.directoryTree.setVisibleRowCount(8);
        this.directoryTree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.directoryTree);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jScrollPane, "Center");
        this.legendPanel = new JPanel();
        this.mainPanel.add((Component)this.legendPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.setRoots(fileArray);
        this.updateLanguage();
    }

    public void updateLanguage() {
        this.createLegendPanel(this.legendPanel);
        this.directoryTreeModel.changeRootText(I18n.tr("Library Folders"));
    }

    public void addEastPanel(JComponent jComponent) {
        this.mainPanel.add((Component)jComponent, "East");
    }

    public void setRoots(File ... fileArray) {
        this.roots.clear();
        this.directoryTree.cancelEditing();
        this.directoryTreeModel.removeSubRoots();
        this.roots.addAll(RecursiveLibraryDirectoryPanel.retainAncestors(fileArray));
        ArrayList<File> arrayList = new ArrayList<File>(this.roots);
        Collections.sort(arrayList, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                if (file.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                    return -1;
                }
                if (file2.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                    return 1;
                }
                return file.compareTo(file2);
            }
        });
        for (File file : arrayList) {
            this.directoryTreeModel.addSubRoot(file);
        }
        this.setRootExpanded();
    }

    public boolean isRoot(File file) {
        return this.roots.contains(file);
    }

    public void setFoldersToExclude(Set<File> set) {
        this.deselected.clear();
        this.deselected.addAll(set);
    }

    public void addFoldersToExclude(Set<File> set) {
        this.deselected.addAll(set);
    }

    public void setRootsExpanded() {
        for (File file : this.roots) {
            this.setExpanded(file);
        }
    }

    public void setRootExpanded() {
        this.directoryTree.expandPath(new TreePath(this.directoryTreeModel.getRoot()));
    }

    public boolean addRoot(File file) {
        boolean bl = this.deselected.remove(file);
        for (File file2 : this.roots) {
            if (FileUtils.isAncestor(file2, file)) {
                if (file2.equals(file)) {
                    if (bl) {
                        this.directoryTreeModel.valueForPathChanged(this.getTreePath(file), null);
                    }
                    return bl;
                }
                this.removeFromPath(file);
                TreePath treePath = this.getTreePath(file);
                this.directoryTree.scrollPathToVisible(treePath);
                return bl;
            }
            if (!FileUtils.isAncestor(file, file2)) continue;
            this.removeRoot(file2);
            this.addDirToTree(file);
            this.setExpanded(file2);
            this.setExpanded(file2.getParentFile());
            return true;
        }
        this.addDirToTree(file);
        this.setRootExpanded();
        return true;
    }

    private void addDirToTree(File file) {
        this.roots.add(file);
        this.directoryTreeModel.addSubRoot(file);
    }

    public void removeRoot(File file) {
        if (this.roots.remove(file)) {
            this.directoryTree.cancelEditing();
            this.directoryTreeModel.removeSubRoot(file);
            this.removeFromPath(file);
        }
    }

    static Set<File> retainAncestors(File ... fileArray) {
        if (fileArray == null) {
            return new HashSet<File>();
        }
        for (int i = 0; i < fileArray.length; ++i) {
            for (int j = i + 1; j < fileArray.length && fileArray[i] != null; ++j) {
                if (fileArray[j] == null) continue;
                if (FileUtils.isAncestor(fileArray[i], fileArray[j])) {
                    fileArray[j] = null;
                    continue;
                }
                if (!FileUtils.isAncestor(fileArray[j], fileArray[i])) continue;
                fileArray[i] = null;
            }
        }
        HashSet<File> hashSet = new HashSet<File>(fileArray.length);
        for (File file : fileArray) {
            if (file == null) continue;
            hashSet.add(file);
        }
        return hashSet;
    }

    private JPanel createLegendPanel(JPanel jPanel) {
        JPanel jPanel2;
        if (jPanel != null) {
            jPanel.removeAll();
            jPanel.setLayout(new GridBagLayout());
            jPanel2 = jPanel;
        } else {
            jPanel2 = new JPanel(new GridBagLayout());
        }
        jPanel2.setBorder(BorderFactory.createTitledBorder(I18n.tr("Legend")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 6);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jPanel2.add((Component)this.createIconLabel(jCheckBox), gridBagConstraints);
        MultiLineLabel multiLineLabel = new MultiLineLabel(I18n.tr("Folder and subfolders are included in the Library."), true);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.add((Component)multiLineLabel, gridBagConstraints2);
        jCheckBox.setSelected(false);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.createIconLabel(jCheckBox), gridBagConstraints);
        multiLineLabel = new MultiLineLabel(I18n.tr("Folder is not included and no subfolders are included in the Library."), true);
        gridBagConstraints2.gridy = 1;
        jPanel2.add((Component)multiLineLabel, gridBagConstraints2);
        jCheckBox.setIcon(this.partiallyIncludedIcon);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel2.add((Component)this.createIconLabel(jCheckBox), gridBagConstraints);
        multiLineLabel = new MultiLineLabel(I18n.tr("Folder's files and some subfolders are included in the Library."), true);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints.insets = null;
        jPanel2.add((Component)multiLineLabel, gridBagConstraints2);
        return jPanel2;
    }

    private JLabel createIconLabel(JCheckBox jCheckBox) {
        jCheckBox.setOpaque(false);
        jCheckBox.setSize(jCheckBox.getMinimumSize());
        BufferedImage bufferedImage = new BufferedImage(jCheckBox.getWidth(), jCheckBox.getHeight(), 3);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        jCheckBox.paint(graphics);
        graphics.dispose();
        return new JLabel(new ImageIcon(bufferedImage));
    }

    public Set<File> getRootsToInclude() {
        HashSet<File> hashSet = new HashSet<File>(this.roots);
        hashSet.removeAll(this.deselected);
        return hashSet;
    }

    public Set<File> getFoldersToExclude() {
        HashSet<File> hashSet = new HashSet<File>(this.deselected);
        return hashSet;
    }

    private TreePath getTreePath(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.add(file);
        for (File file2 = file.getParentFile(); file2 != null && !this.directoryTreeModel.isSubRoot(file); file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
            file = file2;
        }
        Object[] objectArray = new Object[linkedList.size() + 1];
        objectArray[0] = this.directoryTreeModel.getRoot();
        System.arraycopy(linkedList.toArray(), 0, objectArray, 1, objectArray.length - 1);
        return new TreePath(objectArray);
    }

    public JTree getTree() {
        return this.directoryTree;
    }

    public void setExpanded(File file) {
        this.directoryTree.expandPath(this.getTreePath(file));
    }

    private static JCheckBox configureCheckBox(JCheckBox jCheckBox) {
        jCheckBox.setHorizontalAlignment(2);
        jCheckBox.setFont(UIManager.getFont("Tree.font"));
        jCheckBox.setBorderPainted(false);
        jCheckBox.setFocusPainted(false);
        jCheckBox.setFocusable(false);
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    private boolean isIncludedOrParentIsIncluded(File file) {
        while (file != null) {
            if (this.deselected.contains(file)) {
                return false;
            }
            file = file.getParentFile();
        }
        return true;
    }

    private boolean isExcluded(File file) {
        for (File file2 : this.deselected) {
            if (!FileUtils.isAncestor(file2, file)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullyIncluded(File file) {
        for (File file2 : this.deselected) {
            if (!FileUtils.isAncestor(file, file2)) continue;
            return false;
        }
        return true;
    }

    private static Icon createDisabledIcon(JCheckBox jCheckBox, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        jCheckBox.setSelected(true);
        icon.paintIcon(jCheckBox, graphics, 0, 0);
        graphics.dispose();
        return UIManager.getLookAndFeel().getDisabledIcon(jCheckBox, new ImageIcon(bufferedImage));
    }

    private String getText(File file) {
        return this.directoryTreeModel.isSubRoot(file) ? file.getAbsolutePath() : file.getName();
    }

    private void removeFromPath(File object) {
        Object object2 = this.deselected.iterator();
        while (object2.hasNext()) {
            File file = object2.next();
            if (!FileUtils.isAncestor((File)object, file)) continue;
            object2.remove();
        }
        while (object != null && !this.roots.contains(object)) {
            object2 = ((File)object).getParentFile();
            if (this.ancestorIsExcluded((File)object2)) {
                this.deselected.remove(object2);
                int n = this.directoryTreeModel.getChildCount(object2);
                for (int i = 0; i < n; ++i) {
                    File file = (File)this.directoryTreeModel.getChild(object2, i);
                    if (file == null || file.equals(object)) continue;
                    this.deselected.add(file);
                }
            }
            object = object2;
        }
    }

    private boolean ancestorIsExcluded(File file) {
        while (file != null) {
            if (this.deselected.contains(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private static class IncludedFolderFilter
    implements FileFilter {
        private IncludedFolderFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (FileUtils.isAncestor(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue(), file)) {
                return false;
            }
            for (File file2 : LibrarySettings.DIRECTORIES_TO_INCLUDE_FROM_FROSTWIRE4.getValue()) {
                if (!FileUtils.isAncestor(file2, file)) continue;
                return false;
            }
            if (FileUtils.isAncestor(LibrarySettings.USER_MUSIC_FOLDER.getValue(), file)) {
                return false;
            }
            return file.isDirectory() && !file.isHidden();
        }
    }

    private static class RootNotEditableTree
    extends JTree {
        private static final long serialVersionUID = 3856730985269585441L;

        public RootNotEditableTree(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public boolean isPathEditable(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof File && object.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                return false;
            }
            return treePath.getPathCount() != 1;
        }
    }

    private class FileTreeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -8422311328409412824L;

        public FileTreeCellEditor() {
            super(RecursiveLibraryDirectoryPanel.configureCheckBox(new JCheckBox()));
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = -7007164079287676831L;

                @Override
                public void setValue(Object object) {
                    File file = (File)object;
                    ((JCheckBox)FileTreeCellEditor.this.editorComponent).setSelected(RecursiveLibraryDirectoryPanel.this.isIncludedOrParentIsIncluded(file));
                    ((JCheckBox)FileTreeCellEditor.this.editorComponent).setText(RecursiveLibraryDirectoryPanel.this.getText(file));
                    this.value = object;
                }

                @Override
                public Object getCellEditorValue() {
                    File file = (File)this.value;
                    if (((JCheckBox)FileTreeCellEditor.this.editorComponent).isSelected()) {
                        RecursiveLibraryDirectoryPanel.this.removeFromPath(file);
                    } else {
                        RecursiveLibraryDirectoryPanel.this.deselected.add(file);
                    }
                    return this.value;
                }
            };
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.delegate.setValue(object);
            return this.editorComponent;
        }
    }

    private class FileTreeCellRenderer
    extends SubstanceDefaultTreeCellRenderer {
        private static final long serialVersionUID = -8299879264709364378L;
        private JCheckBox checkBox = RecursiveLibraryDirectoryPanel.access$200(new JCheckBox());
        private SubstanceDefaultTreeCellRenderer labelRenderer = new SubstanceDefaultTreeCellRenderer();

        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!(object instanceof File)) {
                this.labelRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, false, n, false);
                this.labelRenderer.setIcon(null);
                return this.labelRenderer;
            }
            File file = (File)object;
            this.checkBox.setText(RecursiveLibraryDirectoryPanel.this.getText(file));
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.setForeground(this.getForeground());
            if (RecursiveLibraryDirectoryPanel.this.isExcluded(file)) {
                this.checkBox.setSelected(false);
                this.checkBox.setIcon(null);
            } else if (RecursiveLibraryDirectoryPanel.this.isFullyIncluded(file)) {
                this.checkBox.setSelected(true);
                this.checkBox.setIcon(null);
            } else {
                this.checkBox.setSelected(true);
                this.checkBox.setIcon(RecursiveLibraryDirectoryPanel.this.partiallyIncludedIcon);
            }
            return this.checkBox;
        }
    }
}

