/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.RecursiveLibraryDirectoryPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RemoveLibraryDirectoryAction
extends AbstractAction {
    private static final long serialVersionUID = -6729288511779797455L;
    private final RecursiveLibraryDirectoryPanel recursiveSharingPanel;

    public RemoveLibraryDirectoryAction(RecursiveLibraryDirectoryPanel recursiveLibraryDirectoryPanel) {
        super(I18n.tr("Remove"));
        this.recursiveSharingPanel = recursiveLibraryDirectoryPanel;
        this.setEnabled(false);
        recursiveLibraryDirectoryPanel.getTree().addTreeSelectionListener(new EnablementSelectionListener());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = (File)this.recursiveSharingPanel.getTree().getSelectionPath().getLastPathComponent();
        this.recursiveSharingPanel.removeRoot(file);
    }

    private class EnablementSelectionListener
    implements TreeSelectionListener {
        private EnablementSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = treeSelectionEvent.getPath().getLastPathComponent();
            if (object instanceof File) {
                RemoveLibraryDirectoryAction.this.setEnabled(RemoveLibraryDirectoryAction.this.recursiveSharingPanel.isRoot((File)object));
            } else {
                RemoveLibraryDirectoryAction.this.setEnabled(false);
            }
        }
    }
}

