/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.FileSettingDirectoryHolder;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.limewire.setting.FileSetting;

public class SavedFilesDirectoryHolder
extends FileSettingDirectoryHolder {
    private final MediaType type = MediaType.getAnyTypeMediaType();
    private Set<File> cache = new HashSet<File>();

    public SavedFilesDirectoryHolder(FileSetting fileSetting, String string) {
        super(fileSetting, string);
    }

    @Override
    public Icon getIcon() {
        return GUIMediator.getThemeImage("save");
    }

    @Override
    public boolean accept(File file) {
        return super.accept(file) && this.type.matches(file.getName()) && !file.isDirectory();
    }

    private Set<File> getFilesRecursively(File file, Set<File> set) {
        if (file.isDirectory() && set.contains(file)) {
            return Collections.emptySet();
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File file2 : fileArray) {
            if (!(file2.isDirectory() || this._hideFiles.contains(file2) || file2.getName().toLowerCase().contains(".ds_store"))) {
                hashSet.add(file2);
                continue;
            }
            if (!file2.isDirectory() || set.contains(file2)) continue;
            hashSet.addAll(this.getFilesRecursively(file2, set));
        }
        return hashSet;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public File[] getFiles() {
        if (this.cache != null && this.cache.size() > 0) {
            return this.cache.toArray(new File[0]);
        }
        this._hideFiles = TorrentUtil.getIgnorableFiles();
        Set<File> set = LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue();
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue()));
        HashSet<File> hashSet2 = new HashSet<File>();
        for (File file : hashSet) {
            hashSet2.addAll(this.getFilesRecursively(file, set));
        }
        this.cache = new HashSet<File>(hashSet2);
        return this.cache.toArray(new File[0]);
    }

    public Collection<File> getCache() {
        return this.cache;
    }
}

