/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.Finger;
import com.limegroup.gnutella.gui.I18n;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class UITool {
    private static String[] BYTE_UNITS = new String[]{"b", "KB", "Mb", "Gb", "Tb"};
    private static HashMap<String, Integer> FILE_TYPES;

    public UITool() {
        UITool.initFileTypes();
    }

    public BufferedImage loadImage(String string) {
        String string2 = "images/" + string + ".png";
        if (string.endsWith(".jpg") || string.endsWith(".gif")) {
            string2 = "images/" + string;
        }
        URL uRL = this.getClass().getResource(string2);
        try {
            UITool.initFileTypes();
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("URL? " + uRL);
            System.out.println("PATH? " + string2);
            exception.printStackTrace();
            return null;
        }
    }

    public String getImageNameByFileType(int n) {
        switch (n) {
            case 4: {
                return "application";
            }
            case 3: {
                return "document";
            }
            case 1: {
                return "picture";
            }
            case 2: {
                return "video";
            }
            case 5: {
                return "ringtone";
            }
            case 0: {
                return "audio";
            }
        }
        return "";
    }

    public String getBytesInHuman(long l) {
        int n = 0;
        float f = l;
        n = 0;
        while (l > 1024L) {
            l /= 1024L;
            f /= 1024.0f;
            ++n;
        }
        return String.format("%.2f ", Float.valueOf(f)) + BYTE_UNITS[n];
    }

    public int getFileTypeByExt(String string) {
        if (string == null) {
            return 3;
        }
        Integer n = FILE_TYPES.get(string = string.replace("\\.", "").trim().toLowerCase());
        if (n != null) {
            return n;
        }
        return 3;
    }

    public static String getFileTypeAsString(int n) {
        switch (n) {
            case 4: {
                return I18n.tr("Applications");
            }
            case 0: {
                return I18n.tr("Audio");
            }
            case 3: {
                return I18n.tr("Documents");
            }
            case 1: {
                return I18n.tr("Pictures");
            }
            case 5: {
                return I18n.tr("Ringtones");
            }
            case 2: {
                return I18n.tr("Video");
            }
        }
        return I18n.tr("Unkown file type");
    }

    public static int getNumSharedFiles(Finger finger, byte by) {
        switch (by) {
            case 0: {
                return finger.numSharedAudioFiles;
            }
            case 1: {
                return finger.numSharedPictureFiles;
            }
            case 2: {
                return finger.numSharedVideoFiles;
            }
            case 3: {
                return finger.numSharedDocumentFiles;
            }
            case 4: {
                return finger.numSharedApplicationFiles;
            }
            case 5: {
                return finger.numSharedRingtoneFiles;
            }
        }
        return 0;
    }

    private static void initFileTypes() {
        if (FILE_TYPES != null) {
            return;
        }
        FILE_TYPES = new HashMap();
    }
}

