/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.AudioPlayerListener;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.DeviceAudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.frostwire.gui.player.RepeatMode;
import com.frostwire.gui.player.StreamAudioSource;
import com.frostwire.mp3.Mp3File;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.MPlayer;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.FileUtils;
import org.limewire.util.FilenameUtils;
import org.limewire.util.OSUtils;

public class AudioPlayer
implements RefreshListener {
    private static final String[] PLAYABLE_EXTENSIONS = new String[]{"mp3", "ogg", "wav", "wma", "m4a", "aac", "flac"};
    private List<AudioPlayerListener> listenerList = new CopyOnWriteArrayList<AudioPlayerListener>();
    private MPlayer mplayer;
    private AudioSource currentSong;
    private Playlist currentPlaylist;
    private List<AudioSource> playlistFilesView;
    private RepeatMode repeatMode;
    private boolean shuffle;
    private boolean playNextSong;
    private double volume;
    private Queue<AudioSource> lastRandomFiles = new LinkedList<AudioSource>();
    private final ExecutorService playExecutor = ExecutorsHelper.newProcessingQueue("AudioPlayer-PlayExecutor");
    private static AudioPlayer instance;
    private long durationInSeconds;

    public static AudioPlayer instance() {
        if (instance == null) {
            instance = new AudioPlayer();
        }
        return instance;
    }

    private AudioPlayer() {
        boolean bl;
        String string = "";
        boolean bl2 = bl = !FrostWireUtils.getFrostWireJarPath().contains("frostwire-desktop");
        if (OSUtils.isWindows()) {
            string = bl ? FrostWireUtils.getFrostWireJarPath() + File.separator + "fwplayer.exe" : "lib/native/fwplayer.exe";
            if (!new File(string = AudioPlayer.decode(string)).exists()) {
                string = AudioPlayer.decode("../lib/native/fwplayer.exe");
            }
        } else if (OSUtils.isMacOSX()) {
            String string2 = new File(FrostWireUtils.getFrostWireJarPath()).getParentFile().getParent() + File.separator + "MacOS";
            string = bl ? string2 + File.separator + "fwplayer" : "lib/native/fwplayer";
        } else {
            string = "/usr/bin/mplayer";
        }
        MPlayer.initialise(new File(string));
        this.mplayer = new MPlayer();
        this.mplayer.addPositionListener(new PositionListener(){

            @Override
            public void positionChanged(float f) {
                AudioPlayer.this.notifyProgress(f);
            }
        });
        this.mplayer.addStateListener(new StateListener(){

            @Override
            public void stateChanged(MediaPlaybackState mediaPlaybackState) {
                if (mediaPlaybackState == MediaPlaybackState.Closed) {
                    AudioPlayer.this.handleNextSong();
                }
                if (mediaPlaybackState == MediaPlaybackState.Playing || mediaPlaybackState == MediaPlaybackState.Paused) {
                    AudioPlayer.this.setVolume(AudioPlayer.this.volume);
                }
            }
        });
        this.mplayer.addIcyInfoListener(new IcyInfoListener(){

            @Override
            public void newIcyInfoData(String string) {
                AudioPlayer.this.notifyIcyInfo(string);
            }
        });
        this.repeatMode = PlayerSettings.LOOP_PLAYLIST.getValue() ? RepeatMode.All : RepeatMode.None;
        this.shuffle = PlayerSettings.SHUFFLE_PLAYLIST.getValue();
        this.playNextSong = true;
        this.volume = PlayerSettings.PLAYER_VOLUME.getValue();
        this.notifyVolumeChanged();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                Component component;
                if (!(keyEvent.getID() != 401 || keyEvent.getKeyCode() != 32 || (component = keyEvent.getComponent()) instanceof JTextField || component instanceof JTable && ((JTable)component).isEditing() && !(component instanceof JCheckBox))) {
                    AudioPlayer.this.togglePause();
                    return true;
                }
                return false;
            }
        });
    }

    public AudioSource getCurrentSong() {
        return this.currentSong;
    }

    public Playlist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    public List<AudioSource> getPlaylistFilesView() {
        return this.playlistFilesView;
    }

    public RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    public void setRepeatMode(RepeatMode repeatMode) {
        this.repeatMode = repeatMode;
        PlayerSettings.LOOP_PLAYLIST.setValue(repeatMode == RepeatMode.All);
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void setShuffle(boolean bl) {
        this.shuffle = bl;
        PlayerSettings.SHUFFLE_PLAYLIST.setValue(bl);
    }

    public void addAudioPlayerListener(AudioPlayerListener audioPlayerListener) {
        this.listenerList.add(audioPlayerListener);
    }

    public void removeAudioPlayerListener(AudioPlayerListener audioPlayerListener) {
        this.listenerList.remove(audioPlayerListener);
    }

    public MediaPlaybackState getState() {
        return this.mplayer.getCurrentState();
    }

    public void loadSong(AudioSource audioSource, boolean bl, boolean bl2, Playlist playlist, List<AudioSource> list) {
        this.currentSong = audioSource;
        this.playNextSong = bl2;
        this.currentPlaylist = playlist;
        this.playlistFilesView = list;
        this.notifyOpened(audioSource);
        if (bl) {
            this.durationInSeconds = -1L;
            if (this.currentSong.getFile() != null) {
                LibraryMediator.instance().getLibraryCoverArt().setFile(this.currentSong.getFile());
                this.calculateDurationInSecs(this.currentSong.getFile());
            } else if (this.currentSong.getPlaylistItem() != null) {
                LibraryMediator.instance().getLibraryCoverArt().setFile(new File(this.currentSong.getPlaylistItem().getFilePath()));
                this.durationInSeconds = (long)this.currentSong.getPlaylistItem().getTrackDurationInSecs();
            } else if (this.currentSong instanceof InternetRadioAudioSource) {
                LibraryMediator.instance().getLibraryCoverArt().setDefault();
            } else if (this.currentSong instanceof StreamAudioSource) {
                LibraryMediator.instance().getLibraryCoverArt().setDefault();
            }
            this.playSong();
        }
    }

    private void calculateDurationInSecs(File file) {
        if (FileUtils.getFileExtension(file) == null || !FileUtils.getFileExtension(file).toLowerCase().endsWith("mp3") || !FileUtils.getFileExtension(file).toLowerCase().endsWith("m4a")) {
            this.durationInSeconds = -1L;
            return;
        }
        if (FileUtils.getFileExtension(file).toLowerCase().endsWith("mp3")) {
            this.durationInSeconds = this.getDurationFromMP3(file);
        } else if (FileUtils.getFileExtension(file).toLowerCase().endsWith("m4a")) {
            this.durationInSeconds = this.getDurationFromM4A(file);
        }
    }

    private long getDurationFromMP3(File file) {
        try {
            Mp3File mp3File = new Mp3File(file.getAbsolutePath());
            return mp3File.getLengthInSeconds();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getDurationFromM4A(File file) {
        long l;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            IsoFile isoFile = new IsoFile(fileChannel);
            l = isoFile.getMovieBox().getMovieHeaderBox().getDuration() / isoFile.getMovieBox().getMovieHeaderBox().getTimescale();
            if (fileInputStream == null) return l;
        }
        catch (Throwable throwable) {
            try {
                long l2 = -1L;
                return l2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
        try {
            fileInputStream.close();
            return l;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public void asyncLoadSong(final AudioSource audioSource, final boolean bl, final boolean bl2, final Playlist playlist, final List<AudioSource> list) {
        this.playExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.loadSong(audioSource, bl, bl2, playlist, list);
            }
        });
    }

    public void loadSong(AudioSource audioSource, boolean bl, boolean bl2) {
        this.loadSong(audioSource, bl, bl2, this.currentPlaylist, this.playlistFilesView);
    }

    public void asyncLoadSong(final AudioSource audioSource, final boolean bl, final boolean bl2) {
        this.playExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.loadSong(audioSource, bl, bl2);
            }
        });
    }

    public void loadSong(AudioSource audioSource) {
        this.loadSong(audioSource, false, false, null, null);
    }

    public void playSong() {
        this.mplayer.stop();
        this.setVolume(this.volume);
        if (this.currentSong.getFile() != null) {
            this.mplayer.open(this.currentSong.getFile().getAbsolutePath());
        } else if (this.currentSong.getURL() != null) {
            this.mplayer.open(this.currentSong.getURL().toString());
        } else if (this.currentSong.getPlaylistItem() != null) {
            this.mplayer.open(this.currentSong.getPlaylistItem().getFilePath());
        }
        this.notifyState(this.getState());
    }

    public void togglePause() {
        this.mplayer.togglePause();
        this.notifyState(this.getState());
    }

    public void stop() {
        this.mplayer.stop();
        this.currentSong = null;
        this.notifyState(this.getState());
    }

    public void seek(float f) {
        this.mplayer.seek(f);
        this.notifyState(this.getState());
    }

    public void setVolume(double d) {
        this.volume = d;
        this.mplayer.setVolume((int)(d * 100.0));
        PlayerSettings.PLAYER_VOLUME.setValue((float)this.volume);
        this.notifyVolumeChanged();
    }

    protected void notifyVolumeChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.fireVolumeChanged(AudioPlayer.this.volume);
            }
        });
    }

    public static boolean isPlayableFile(File file) {
        return file.exists() && !file.isDirectory() && AudioPlayer.isPlayableFile(file.getAbsolutePath());
    }

    public static boolean isPlayableFile(String string) {
        return FilenameUtils.hasExtension(string, AudioPlayer.getPlayableExtensions());
    }

    public static String[] getPlayableExtensions() {
        return PLAYABLE_EXTENSIONS;
    }

    public static boolean isPlayableFile(AudioSource audioSource) {
        if (audioSource.getFile() != null) {
            return audioSource.getFile().exists() && AudioPlayer.isPlayableFile(audioSource.getFile());
        }
        if (audioSource.getPlaylistItem() != null) {
            return new File(audioSource.getPlaylistItem().getFilePath()).exists() && AudioPlayer.isPlayableFile(audioSource.getPlaylistItem().getFilePath());
        }
        if (audioSource instanceof InternetRadioAudioSource) {
            return true;
        }
        if (audioSource instanceof StreamAudioSource) {
            return true;
        }
        if (audioSource instanceof DeviceAudioSource) {
            return AudioPlayer.isPlayableFile(((DeviceAudioSource)audioSource).getFileDescriptor().filePath);
        }
        return false;
    }

    protected void notifyOpened(final AudioSource audioSource) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.fireOpened(audioSource);
            }
        });
    }

    protected void notifyState(final MediaPlaybackState mediaPlaybackState) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.fireState(mediaPlaybackState);
            }
        });
    }

    protected void notifyProgress(final float f) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.fireProgress(f);
            }
        });
    }

    protected void notifyIcyInfo(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.fireIcyInfo(string);
            }
        });
    }

    protected void fireOpened(AudioSource audioSource) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.songOpened(this, audioSource);
        }
    }

    protected void fireProgress(float f) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.progressChange(this, f);
        }
    }

    protected void fireVolumeChanged(double d) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.volumeChange(this, d);
        }
    }

    protected void fireState(MediaPlaybackState mediaPlaybackState) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.stateChange(this, mediaPlaybackState);
        }
    }

    protected void fireIcyInfo(String string) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.icyInfo(this, string);
        }
    }

    @Override
    public void refresh() {
        this.notifyState(this.getState());
    }

    private void handleNextSong() {
        if (!this.playNextSong) {
            return;
        }
        if (this.currentPlaylist != null && this.currentPlaylist.isDeleted()) {
            return;
        }
        AudioSource audioSource = null;
        audioSource = this.getRepeatMode() == RepeatMode.Song ? this.currentSong : (this.isShuffle() ? this.getNextRandomSong(this.currentSong) : (this.getRepeatMode() == RepeatMode.All ? this.getNextContinuousSong(this.currentSong) : this.getNextSong(this.currentSong)));
        if (audioSource != null) {
            this.asyncLoadSong(audioSource, true, true, this.currentPlaylist, this.playlistFilesView);
        }
    }

    public boolean isThisBeingPlayed(File file) {
        if (this.getState() == MediaPlaybackState.Stopped) {
            return false;
        }
        AudioSource audioSource = this.getCurrentSong();
        if (audioSource == null) {
            return false;
        }
        File file2 = audioSource.getFile();
        if (file2 != null && file.equals(file2)) {
            return true;
        }
        PlaylistItem playlistItem = audioSource.getPlaylistItem();
        return playlistItem != null && new File(playlistItem.getFilePath()).equals(file);
    }

    public boolean isThisBeingPlayed(String string) {
        if (this.getState() == MediaPlaybackState.Stopped) {
            return false;
        }
        AudioSource audioSource = this.getCurrentSong();
        if (audioSource == null) {
            return false;
        }
        String string2 = audioSource.getURL();
        return string2 != null && string.toLowerCase().equals(string2.toString().toLowerCase());
    }

    public boolean isThisBeingPlayed(PlaylistItem playlistItem) {
        if (this.getState() == MediaPlaybackState.Stopped) {
            return false;
        }
        AudioSource audioSource = this.getCurrentSong();
        if (audioSource == null) {
            return false;
        }
        PlaylistItem playlistItem2 = audioSource.getPlaylistItem();
        return playlistItem2 != null && playlistItem.equals(playlistItem2);
    }

    public synchronized void setPlaylistFilesView(List<AudioSource> list) {
        this.playlistFilesView = list;
    }

    public AudioSource getNextRandomSong(AudioSource audioSource) {
        AudioSource audioSource2;
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = 4;
        while ((audioSource2 = this.findRandomSongFile(audioSource)) == null && n-- > 0) {
        }
        if (n > 0) {
            this.lastRandomFiles.add(audioSource2);
            if (this.lastRandomFiles.size() > 3) {
                this.lastRandomFiles.poll();
            }
        } else {
            audioSource2 = audioSource;
            this.lastRandomFiles.clear();
            this.lastRandomFiles.add(audioSource2);
        }
        return audioSource2;
    }

    public AudioSource getNextContinuousSong(AudioSource audioSource) {
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.size();
        if (n == 1) {
            return this.playlistFilesView.get(0);
        }
        for (int i = 0; i < n; ++i) {
            try {
                AudioSource audioSource2 = this.playlistFilesView.get(i);
                if (!audioSource.equals(audioSource2)) continue;
                for (int j = 1; j < n; ++j) {
                    AudioSource audioSource3 = this.playlistFilesView.get((j + i) % n);
                    if (!AudioPlayer.isPlayableFile(audioSource3) && !(audioSource3 instanceof DeviceAudioSource)) continue;
                    return audioSource3;
                }
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public AudioSource getNextSong(AudioSource audioSource) {
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.size();
        if (n == 1) {
            return this.playlistFilesView.get(0);
        }
        for (int i = 0; i < n; ++i) {
            try {
                AudioSource audioSource2 = this.playlistFilesView.get(i);
                if (!audioSource.equals(audioSource2)) continue;
                for (int j = i + 1; j < n; ++j) {
                    AudioSource audioSource3 = this.playlistFilesView.get(j);
                    if (!AudioPlayer.isPlayableFile(audioSource3)) continue;
                    return audioSource3;
                }
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public AudioSource getPreviousSong(AudioSource audioSource) {
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.size();
        for (int i = 0; i < n; ++i) {
            try {
                AudioSource audioSource2 = this.playlistFilesView.get(i);
                if (!audioSource.equals(audioSource2)) continue;
                for (int j = i - 1; j >= 0; --j) {
                    AudioSource audioSource3 = this.playlistFilesView.get(j);
                    if (!AudioPlayer.isPlayableFile(audioSource3)) continue;
                    return audioSource3;
                }
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private AudioSource findRandomSongFile(AudioSource audioSource) {
        int n;
        if (this.playlistFilesView == null) {
            return null;
        }
        int n2 = this.playlistFilesView.size();
        if (n2 == 1) {
            return this.playlistFilesView.get(0);
        }
        for (int i = n = new Random(System.currentTimeMillis()).nextInt(n2); i < n2; ++i) {
            try {
                AudioSource audioSource2 = this.playlistFilesView.get(i);
                if (this.lastRandomFiles.contains(audioSource2) || audioSource2.equals(audioSource) || !AudioPlayer.isPlayableFile(audioSource2)) continue;
                return audioSource2;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public boolean canSeek() {
        if (this.durationInSeconds != -1L) {
            return this.durationInSeconds > 0L;
        }
        return this.mplayer.getDurationInSecs() > 0.0f;
    }

    public float getDurationInSecs() {
        if (this.durationInSeconds != -1L) {
            return this.durationInSeconds;
        }
        return this.mplayer.getDurationInSecs();
    }

    private static String decode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }
}

