/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioPlayerListener;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.RepeatMode;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.MediaSlider;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.util.FrostWireUtils;
import com.limegroup.gnutella.util.Tagged;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class AudioPlayerComponent
implements AudioPlayerListener,
RefreshListener,
ThemeObserver {
    public static final String STREAMING_AUDIO = "Streaming Audio";
    private final MediaButton PLAY_BUTTON = new MediaButton(I18n.tr("Play"), "play_up", "play_dn");
    private final MediaButton PAUSE_BUTTON = new MediaButton(I18n.tr("Pause"), "pause_up", "pause_dn");
    private JPanel PLAY_PAUSE_BUTTON_CONTAINER;
    private final MediaButton STOP_BUTTON = new MediaButton(I18n.tr("Stop"), "stop_up", "stop_dn");
    private final MediaButton NEXT_BUTTON = new MediaButton(I18n.tr("Next"), "forward_up", "forward_dn");
    private final MediaButton PREV_BUTTON = new MediaButton(I18n.tr("Previous"), "rewind_up", "rewind_dn");
    private final MediaSlider VOLUME = new MediaSlider("volume_labels");
    private final JProgressBar PROGRESS = new JProgressBar();
    private final JLabel progressCurrentTime = new JLabel("--:--:--");
    private final JLabel progressSongLength = new JLabel("--:--:--");
    private final AudioPlayer PLAYER;
    private final Dimension progressBarDimension = new Dimension(180, 5);
    private final Dimension volumeSliderDimension = new Dimension(70, 19);
    private AudioSource currentPlayListItem;
    private JPanel myMediaPanel = null;
    private float _progress;
    private JToggleButton SHUFFLE_BUTTON;
    private JToggleButton LOOP_BUTTON;
    private CardLayout PLAY_PAUSE_CARD_LAYOUT;

    public AudioPlayerComponent() {
        this.PLAYER = AudioPlayer.instance();
        this.PLAYER.addAudioPlayerListener(this);
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
    }

    public JPanel getMediaPanel() {
        return this.getMediaPanel(false);
    }

    public JPanel getMediaPanel(boolean bl) {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel(bl);
        }
        return this.myMediaPanel;
    }

    private JPanel constructMediaPanel(boolean bl) {
        int n = 1;
        n += this.PLAY_BUTTON.getIcon().getIconHeight() + 2;
        this.PROGRESS.setMinimumSize(this.progressBarDimension);
        this.PROGRESS.setMaximumSize(this.progressBarDimension);
        this.PROGRESS.setPreferredSize(this.progressBarDimension);
        this.PROGRESS.setMaximum(3600);
        this.PROGRESS.setEnabled(false);
        this.VOLUME.setMaximumSize(this.volumeSliderDimension);
        this.VOLUME.setPreferredSize(this.volumeSliderDimension);
        this.VOLUME.setMinimum(0);
        this.VOLUME.setValue(50);
        this.VOLUME.setMaximum(100);
        this.VOLUME.setEnabled(true);
        this.VOLUME.setOpaque(false);
        this.registerListeners();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        jPanel.setOpaque(false);
        jPanel.setMinimumSize(new Dimension(300, n));
        jPanel.setPreferredSize(new Dimension(300, n));
        jPanel.setMaximumSize(new Dimension(300, n));
        if (bl) {
            this.initPlaylistPlaybackModeControls();
            jPanel.add(this.SHUFFLE_BUTTON);
            jPanel.add(this.LOOP_BUTTON);
        }
        jPanel.add(this.VOLUME);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.PREV_BUTTON);
        this.PLAY_PAUSE_CARD_LAYOUT = new CardLayout();
        this.PLAY_PAUSE_BUTTON_CONTAINER = new JPanel(this.PLAY_PAUSE_CARD_LAYOUT);
        this.PLAY_PAUSE_BUTTON_CONTAINER.setOpaque(false);
        this.PLAY_PAUSE_BUTTON_CONTAINER.add((Component)this.PLAY_BUTTON, "PLAY");
        this.PLAY_PAUSE_BUTTON_CONTAINER.add((Component)this.PAUSE_BUTTON, "PAUSE");
        jPanel.add(this.PLAY_PAUSE_BUTTON_CONTAINER);
        jPanel.add(this.STOP_BUTTON);
        jPanel.add(this.NEXT_BUTTON);
        jPanel.add(Box.createHorizontalStrut(10));
        Font font = new Font(this.progressCurrentTime.getFont().getFontName(), 0, 10);
        this.progressCurrentTime.setForeground(ThemeMediator.CURRENT_THEME.getCustomUI().getLightForegroundColor());
        this.progressCurrentTime.setFont(font);
        this.progressSongLength.setForeground(ThemeMediator.CURRENT_THEME.getCustomUI().getLightForegroundColor());
        this.progressSongLength.setFont(font);
        Dimension dimension = new Dimension(45, 11);
        this.progressCurrentTime.setMinimumSize(dimension);
        this.progressCurrentTime.setPreferredSize(dimension);
        this.progressSongLength.setPreferredSize(dimension);
        this.progressSongLength.setMinimumSize(dimension);
        jPanel.add(this.progressCurrentTime);
        jPanel.add(this.PROGRESS);
        jPanel.add(this.progressSongLength);
        return jPanel;
    }

    public void initPlaylistPlaybackModeControls() {
        this.SHUFFLE_BUTTON = new JToggleButton();
        this.SHUFFLE_BUTTON.setBorderPainted(false);
        this.SHUFFLE_BUTTON.setContentAreaFilled(false);
        this.SHUFFLE_BUTTON.setBackground(null);
        this.SHUFFLE_BUTTON.setIcon(GUIMediator.getThemeImage("shuffle_off"));
        this.SHUFFLE_BUTTON.setSelectedIcon(GUIMediator.getThemeImage("shuffle_on"));
        this.SHUFFLE_BUTTON.setToolTipText(I18n.tr("Shuffle songs"));
        this.SHUFFLE_BUTTON.setSelected(this.PLAYER.isShuffle());
        this.LOOP_BUTTON = new JToggleButton();
        this.LOOP_BUTTON.setBorderPainted(false);
        this.LOOP_BUTTON.setContentAreaFilled(false);
        this.LOOP_BUTTON.setBackground(null);
        this.LOOP_BUTTON.setIcon(GUIMediator.getThemeImage("loop_off"));
        this.LOOP_BUTTON.setSelectedIcon(GUIMediator.getThemeImage("loop_on"));
        this.LOOP_BUTTON.setToolTipText(I18n.tr("Repeat songs"));
        this.LOOP_BUTTON.setSelected(this.PLAYER.getRepeatMode() == RepeatMode.All);
        this.SHUFFLE_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioPlayerComponent.this.PLAYER.setShuffle(AudioPlayerComponent.this.SHUFFLE_BUTTON.isSelected());
            }
        });
        this.LOOP_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioPlayerComponent.this.PLAYER.setRepeatMode(AudioPlayerComponent.this.LOOP_BUTTON.isSelected() ? RepeatMode.All : RepeatMode.None);
            }
        });
    }

    private void showPauseButton() {
        this.PLAY_PAUSE_CARD_LAYOUT.show(this.PLAY_PAUSE_BUTTON_CONTAINER, "PAUSE");
    }

    private void showPlayButton() {
        this.PLAY_PAUSE_CARD_LAYOUT.show(this.PLAY_PAUSE_BUTTON_CONTAINER, "PLAY");
    }

    public void registerListeners() {
        this.PLAY_BUTTON.addActionListener(new PlayListener());
        this.PAUSE_BUTTON.addActionListener(new PauseListener());
        this.STOP_BUTTON.addActionListener(new StopListener());
        this.NEXT_BUTTON.addActionListener(new NextListener());
        this.PREV_BUTTON.addActionListener(new BackListener());
        this.VOLUME.addChangeListener(new VolumeSliderListener());
        this.PROGRESS.addMouseListener(new ProgressBarMouseAdapter());
    }

    public void unregisterListeners() {
        this.PLAY_BUTTON.removeActionListener(new PlayListener());
        this.PAUSE_BUTTON.removeActionListener(new PauseListener());
        this.STOP_BUTTON.removeActionListener(new StopListener());
        this.NEXT_BUTTON.removeActionListener(new NextListener());
        this.PREV_BUTTON.removeActionListener(new BackListener());
        this.VOLUME.removeChangeListener(new VolumeSliderListener());
        this.PROGRESS.removeMouseListener(new ProgressBarMouseAdapter());
    }

    @Override
    public void refresh() {
        this.PLAYER.refresh();
    }

    @Override
    public void updateTheme() {
        this.PLAY_BUTTON.updateTheme();
        this.PAUSE_BUTTON.updateTheme();
        this.STOP_BUTTON.updateTheme();
        this.NEXT_BUTTON.updateTheme();
        this.PREV_BUTTON.updateTheme();
        this.VOLUME.updateTheme();
    }

    private void setProgressValue(final int n) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayerComponent.this.PROGRESS.setValue(n);
            }
        });
    }

    private void setProgressEnabled(final boolean bl) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayerComponent.this.PROGRESS.setEnabled(bl);
            }
        });
        this.setProgressValue(0);
    }

    private void setVolumeValue() {
        this.VOLUME.repaint();
        this.PLAYER.setVolume((float)this.VOLUME.getValue() / (float)this.VOLUME.getMaximum());
    }

    public void play() {
        if (this.PLAYER.getCurrentSong() != null) {
            if (this.PLAYER.getState() == MediaPlaybackState.Paused || this.PLAYER.getState() == MediaPlaybackState.Playing) {
                this.PLAYER.togglePause();
            }
        } else if (GUIMediator.instance().getSelectedTab() != null && GUIMediator.instance().getSelectedTab().equals((Object)GUIMediator.Tabs.LIBRARY)) {
            LibraryMediator.instance().playCurrentSelection();
        }
    }

    public void pauseSong() {
        this.PLAYER.togglePause();
    }

    public void stopSong() {
        this.PLAYER.stop();
    }

    public void seek(float f) {
        if (this.currentPlayListItem != null && this.currentPlayListItem.getURL() == null && this.PLAYER.canSeek()) {
            float f2 = this.PLAYER.getDurationInSecs() * f;
            this.PLAYER.seek(f2);
        }
    }

    public AudioSource getCurrentSong() {
        return this.currentPlayListItem;
    }

    @Override
    public void songOpened(AudioPlayer audioPlayer, AudioSource audioSource) {
        this.currentPlayListItem = audioSource;
        this.setVolumeValue();
        if (audioSource.getURL() == null && this.PLAYER.canSeek()) {
            this.setProgressEnabled(true);
            this.progressSongLength.setText(LibraryUtils.getSecondsInDDHHMMSS((int)this.PLAYER.getDurationInSecs()));
        } else {
            this.setProgressEnabled(false);
            this.progressSongLength.setText("--:--:--");
        }
    }

    @Override
    public void progressChange(AudioPlayer audioPlayer, float f) {
        this._progress = f;
        this.progressCurrentTime.setText(LibraryUtils.getSecondsInDDHHMMSS((int)this._progress));
        if (this.currentPlayListItem != null && this.currentPlayListItem.getURL() == null) {
            this.progressSongLength.setText(LibraryUtils.getSecondsInDDHHMMSS((int)this.PLAYER.getDurationInSecs()));
        }
        if (this.currentPlayListItem != null && this.currentPlayListItem.getURL() == null && this.PLAYER.canSeek()) {
            this.setProgressEnabled(true);
            float f2 = (float)this.PROGRESS.getMaximum() * f / this.PLAYER.getDurationInSecs();
            this.setProgressValue((int)f2);
        }
    }

    @Override
    public void stateChange(AudioPlayer audioPlayer, MediaPlaybackState mediaPlaybackState) {
        if (mediaPlaybackState == MediaPlaybackState.Opening) {
            this.setVolumeValue();
        } else if (mediaPlaybackState == MediaPlaybackState.Stopped || mediaPlaybackState == MediaPlaybackState.Closed) {
            this.setProgressValue(this.PROGRESS.getMinimum());
            this.progressCurrentTime.setText("--:--:--");
            this.progressSongLength.setText("--:--:--");
            this.showPlayButton();
        } else if (mediaPlaybackState == MediaPlaybackState.Playing) {
            this.showPauseButton();
        } else if (mediaPlaybackState == MediaPlaybackState.Paused) {
            this.showPlayButton();
        }
    }

    String playSong(Map<String, String> map) {
        return "ok";
    }

    String removeFromPlaylist(int n) {
        return "invalid.index: " + n;
    }

    String playIndexInPlaylist(int n) {
        return "invalid.index: " + n;
    }

    String getProgress() {
        String string;
        if (this.isPlaying()) {
            int n = this.PROGRESS.getValue();
            int n2 = this.PROGRESS.getMaximum();
            System.out.println(n + ":" + n2);
            string = n + "\t" + n2;
        } else {
            string = "stopped";
        }
        return string.toString();
    }

    String addToPlaylist(Map<String, String> map) {
        Tagged<String> tagged = FrostWireUtils.getArg(map, "url", "AddToPlaylist");
        if (!tagged.isValid()) {
            return tagged.getValue();
        }
        Tagged<String> tagged2 = FrostWireUtils.getArg(map, "name", "AddtoPlaylist");
        if (!tagged2.isValid()) {
            return tagged2.getValue();
        }
        Tagged<String> tagged3 = FrostWireUtils.getArg(map, "length", "AddtoPlaylist");
        if (!tagged3.isValid()) {
            return tagged3.getValue();
        }
        Tagged<String> tagged4 = FrostWireUtils.getArg(map, "artist", "AddtoPlaylist");
        if (!tagged4.isValid()) {
            return tagged4.getValue();
        }
        Tagged<String> tagged5 = FrostWireUtils.getArg(map, "album", "AddtoPlaylist");
        if (!tagged5.isValid()) {
            return tagged5.getValue();
        }
        return "ok";
    }

    String playURL(Map<String, String> map) {
        Tagged<String> tagged = FrostWireUtils.getArg(map, "url", "PlayURL");
        if (!tagged.isValid()) {
            return tagged.getValue();
        }
        return "ok";
    }

    private boolean isPlaying() {
        return this.PLAYER.getState() != MediaPlaybackState.Stopped && this.PLAYER.getState() != MediaPlaybackState.Uninitialized && this.PLAYER.getState() != MediaPlaybackState.Paused && this.PLAYER.getState() != MediaPlaybackState.Failed;
    }

    public boolean attemptStop() {
        if (this.PLAYER.getState() != MediaPlaybackState.Stopped) {
            this.PLAYER.stop();
            return true;
        }
        return false;
    }

    public void disableControls() {
        this.VOLUME.setEnabled(false);
        this.PAUSE_BUTTON.setEnabled(false);
    }

    public void enableControls() {
        this.VOLUME.setEnabled(true);
        this.PAUSE_BUTTON.setEnabled(true);
    }

    private void next() {
        AudioSource audioSource = this.PLAYER.getCurrentSong();
        if (audioSource != null) {
            AudioSource audioSource2 = null;
            audioSource2 = this.PLAYER.isShuffle() ? this.PLAYER.getNextRandomSong(audioSource) : this.PLAYER.getNextSong(audioSource);
            if (audioSource2 != null) {
                this.PLAYER.asyncLoadSong(audioSource2, true, true);
            }
        }
    }

    private void back() {
        AudioSource audioSource;
        AudioSource audioSource2 = this.PLAYER.getCurrentSong();
        if (audioSource2 != null && (audioSource = this.PLAYER.getPreviousSong(audioSource2)) != null) {
            this.PLAYER.asyncLoadSong(audioSource, true, true);
        }
    }

    @Override
    public void volumeChange(AudioPlayer audioPlayer, double d) {
        VolumeSliderListener volumeSliderListener = (VolumeSliderListener)this.VOLUME.getChangeListeners()[0];
        this.VOLUME.removeChangeListener(volumeSliderListener);
        this.VOLUME.setValue((int)((double)this.VOLUME.getMaximum() * d));
        this.VOLUME.addChangeListener(volumeSliderListener);
    }

    @Override
    public void icyInfo(AudioPlayer audioPlayer, String string) {
    }

    private class VolumeSliderListener
    implements ChangeListener {
        private VolumeSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AudioPlayerComponent.this.setVolumeValue();
        }
    }

    private class ProgressBarMouseAdapter
    extends MouseAdapter {
        private ProgressBarMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            AudioPlayerComponent.this.seek((float)mouseEvent.getX() * 1.0f / (float)((Component)mouseEvent.getSource()).getWidth());
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioPlayerComponent.this.pauseSong();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioPlayerComponent.this.back();
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioPlayerComponent.this.next();
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioPlayerComponent.this.stopSong();
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioPlayerComponent.this.play();
        }
    }
}

