/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.alexandria.PlaylistItem;
import java.io.File;

public class AudioSource {
    private final File file;
    private final String url;
    private final PlaylistItem playlistItem;

    public AudioSource(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.file = file;
        this.url = null;
        this.playlistItem = null;
    }

    public String toString() {
        String string = null;
        string = this.getFile() != null ? this.getFile().getName() : this.url;
        return "[AudioSource@" + this.hashCode() + ": " + string + "]";
    }

    public AudioSource(String string) {
        if (string == null) {
            throw new NullPointerException("Url cannot be null");
        }
        this.file = null;
        this.url = string;
        this.playlistItem = null;
    }

    public AudioSource(PlaylistItem playlistItem) {
        if (playlistItem == null) {
            throw new NullPointerException("PlaylistItem cannot be null");
        }
        this.file = null;
        this.url = null;
        this.playlistItem = playlistItem;
    }

    public File getFile() {
        return this.file;
    }

    public String getURL() {
        return this.url;
    }

    public PlaylistItem getPlaylistItem() {
        return this.playlistItem;
    }

    public boolean equals(Object object) {
        AudioSource audioSource = (AudioSource)object;
        if (this.file != null && audioSource.file != null) {
            return this.file.equals(audioSource.file);
        }
        if (this.url != null && audioSource.url != null) {
            return this.url.equals(audioSource.url);
        }
        if (this.playlistItem != null && audioSource.playlistItem != null) {
            return this.playlistItem.equals(audioSource.playlistItem);
        }
        return false;
    }
}

