/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.tabs;

import com.frostwire.gui.tabs.Tab;
import com.limegroup.gnutella.gui.GUIMediator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractTab
implements Tab {
    private String title;
    private String toolTip;
    private Icon icon;
    private String iconFile;
    private final PropertyChangeSupport propertyChangeSupport;

    public AbstractTab(String string, String string2, String string3) {
        this.title = string;
        this.toolTip = string2;
        this.iconFile = string3;
        this.icon = GUIMediator.getThemeImage(this.iconFile);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public abstract JComponent getComponent();

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.title + " tab";
    }

    void changeTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.propertyChangeSupport.firePropertyChange("title", string2, string);
    }

    void changeTooltip(String string) {
        String string2 = this.toolTip;
        this.toolTip = string;
        this.propertyChangeSupport.firePropertyChange("tooltip", string2, string);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }
}

