/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.AzureusStarter;
import com.frostwire.HttpFetcher;
import com.frostwire.gui.updates.UpdateMessage;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.limewire.util.CommonUtils;
import org.limewire.util.FilenameUtils;
import org.limewire.util.OSUtils;

public class InstallerUpdater
implements Runnable,
DownloadManagerListener {
    private static final Log LOG = LogFactory.getLog(InstallerUpdater.class);
    private DownloadManager _manager = null;
    private UpdateMessage _updateMessage;
    private File _executableFile;
    private static String lastMD5;

    public InstallerUpdater(UpdateMessage updateMessage) {
        this._updateMessage = updateMessage;
    }

    public void start() {
        new Thread((Runnable)this, "InstallerUpdater").start();
    }

    @Override
    public void run() {
        if (!UpdateSettings.AUTOMATIC_INSTALLER_DOWNLOAD.getValue()) {
            return;
        }
        if (this.checkIfDownloaded()) {
            this.showUpdateMessage();
        } else if (this._updateMessage.getTorrent() != null) {
            this.handleTorrentDownload();
        } else if (this._updateMessage.getInstallerUrl() != null) {
            this.handleHttpDownload();
        }
    }

    private void handleTorrentDownload() {
        File file = this.downloadDotTorrent();
        try {
            boolean bl;
            boolean bl2 = bl = file.exists() || file.getAbsoluteFile().exists();
            if (file != null && bl) {
                this._manager = this.startTorrentDownload(file.getAbsolutePath(), UpdateSettings.UPDATES_DIR.getAbsolutePath(), this);
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error starting update torrent download", throwable);
        }
    }

    private void handleHttpDownload() {
        File file = UpdateSettings.UPDATES_DIR;
        int n = this._updateMessage.getInstallerUrl().lastIndexOf(47);
        File file2 = new File(file, this._updateMessage.getInstallerUrl().substring(n + 1));
        if (!file.exists()) {
            file.mkdir();
            file.setWritable(true);
        }
        try {
            new HttpFetcher(new URI(this._updateMessage.getInstallerUrl())).save(file2);
            this.saveMetaData();
            this.cleanupOldUpdates();
            if (this.checkIfDownloaded()) {
                this.showUpdateMessage();
            }
        }
        catch (Throwable throwable) {
            LOG.error("Failed to download installer: " + this._updateMessage.getInstallerUrl(), throwable);
        }
    }

    private final DownloadManager startTorrentDownload(String string, String string2, DownloadManagerListener downloadManagerListener) throws Exception {
        DownloadManager downloadManager = AzureusStarter.getAzureusCore().getGlobalManager().addDownloadManager(string, string2);
        downloadManager.addListener(downloadManagerListener);
        downloadManager.initialize();
        return downloadManager;
    }

    private void showUpdateMessage() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (InstallerUpdater.this._executableFile == null) {
                    return;
                }
                int n = JOptionPane.showConfirmDialog(null, InstallerUpdater.this._updateMessage.getMessageInstallerReady(), I18n.tr("Update"), 0, 1);
                if (n == 0) {
                    try {
                        if (OSUtils.isWindows()) {
                            String[] stringArray = new String[]{"CMD.EXE", "/C", InstallerUpdater.this._executableFile.getAbsolutePath()};
                            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                            processBuilder.start();
                        } else if (OSUtils.isLinux() && OSUtils.isUbuntu()) {
                            String[] stringArray = new String[]{"gdebi-gtk", InstallerUpdater.this._executableFile.getAbsolutePath()};
                            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                            processBuilder.start();
                        } else if (OSUtils.isMacOSX()) {
                            String[] stringArray = new String[]{"hdiutil", "attach", InstallerUpdater.this._executableFile.getAbsolutePath()};
                            String[] stringArray2 = new String[]{"open", "/Volumes/" + FilenameUtils.getBaseName(InstallerUpdater.this._executableFile.getName())};
                            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                            Process process = processBuilder.start();
                            process.waitFor();
                            processBuilder = new ProcessBuilder(stringArray2);
                            processBuilder.start();
                        }
                        GUIMediator.shutdown();
                    }
                    catch (Throwable throwable) {
                        LOG.error("Unable to launch new installer", throwable);
                    }
                }
            }
        });
    }

    private File downloadDotTorrent() {
        File file = UpdateSettings.UPDATES_DIR;
        int n = this._updateMessage.getTorrent().lastIndexOf(47);
        File file2 = new File(file, this._updateMessage.getTorrent().substring(n + 1));
        if (!file.exists()) {
            file.mkdir();
            file.setWritable(true);
        }
        try {
            InstallerUpdater.downloadTorrentFile(this._updateMessage.getTorrent(), file2);
        }
        catch (Throwable throwable) {
            LOG.error("Error downloading update torrent file", throwable);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final InstallerMetaData getLastInstallerMetaData() {
        InstallerMetaData installerMetaData = null;
        try {
            File file = new File(this.getInstallerDatPath());
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            try {
                installerMetaData = (InstallerMetaData)objectInputStream.readObject();
                if (installerMetaData != null) return installerMetaData;
                InstallerMetaData installerMetaData2 = null;
                return installerMetaData2;
            }
            finally {
                fileInputStream.close();
                objectInputStream.close();
            }
        }
        catch (Throwable throwable) {
            LOG.info("Can't read installer meta data");
            return null;
        }
    }

    private boolean checkIfDownloaded() {
        int n;
        InstallerMetaData installerMetaData = this.getLastInstallerMetaData();
        if (installerMetaData == null) {
            return false;
        }
        if (!installerMetaData.frostwireVersion.equals(this._updateMessage.getVersion())) {
            return false;
        }
        String string = null;
        if (this._updateMessage.getTorrent() != null) {
            n = this._updateMessage.getTorrent().lastIndexOf(47) + 1;
            int n2 = this._updateMessage.getTorrent().lastIndexOf(".torrent");
            string = this._updateMessage.getTorrent().substring(n, n2);
        } else if (this._updateMessage.getInstallerUrl() != null) {
            n = this._updateMessage.getInstallerUrl().lastIndexOf(47) + 1;
            string = this._updateMessage.getInstallerUrl().substring(n);
        }
        File file = new File(UpdateSettings.UPDATES_DIR, string);
        if (string == null || !file.exists()) {
            return false;
        }
        this._executableFile = file;
        try {
            return InstallerUpdater.checkMD5(file, this._updateMessage.getRemoteMD5());
        }
        catch (Throwable throwable) {
            LOG.error("Error checking update MD5", throwable);
            return false;
        }
    }

    @Override
    public void completionChanged(DownloadManager downloadManager, boolean bl) {
    }

    @Override
    public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
    }

    @Override
    public void positionChanged(DownloadManager downloadManager, int n, int n2) {
    }

    @Override
    public void stateChanged(DownloadManager downloadManager, int n) {
        if (this._manager == null && downloadManager != null) {
            this._manager = downloadManager;
        }
        InstallerUpdater.printDiskManagerPieces(downloadManager.getDiskManager());
        InstallerUpdater.printDownloadManagerStatus(downloadManager);
        if (this.torrentDataDownloadedToDisk()) {
            return;
        }
        System.out.println("InstallerUpdater.stateChanged() - " + n + " completed: " + downloadManager.isDownloadComplete(false));
        if (n == 60) {
            System.out.println("InstallerUpdater.stateChanged() - SEEDING!");
            return;
        }
        if (n == 100) {
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            System.out.println(this._manager.getErrorDetails());
            System.out.println("InstallerUpdater: ERROR - stopIt, startDownload!");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            try {
                AzureusStarter.getAzureusCore().getGlobalManager().removeDownloadManager(downloadManager, false, true);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                LOG.error("Error removing download manager on error", globalManagerDownloadRemovalVetoException);
            }
        } else if (n == 50) {
            System.out.println("stateChanged(STATE_DOWNLOADING)");
        } else if (n == 40) {
            System.out.println("stateChanged(STATE_READY)");
            downloadManager.startDownload();
        }
    }

    @Override
    public void downloadComplete(DownloadManager downloadManager) {
        System.out.println("InstallerUpdater.downloadComplete()!!!!");
        InstallerUpdater.printDownloadManagerStatus(this._manager);
        this.saveMetaData();
        this.cleanupOldUpdates();
        if (this.checkIfDownloaded()) {
            this.showUpdateMessage();
        }
    }

    private void cleanupOldUpdates() {
        final Pattern pattern = Pattern.compile("^frostwire-([0-9]+[0-9]?\\.[0-9]+[0-9]?\\.[0-9]+[0-9]?)(.*?)(\\.torrent)?$");
        for (File file : UpdateSettings.UPDATES_DIR.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    return !matcher.group(1).equals(InstallerUpdater.this._updateMessage.getVersion());
                }
                return false;
            }
        })) {
            file.delete();
        }
    }

    private final String getInstallerDatPath() {
        return CommonUtils.getUserSettingsDir().getAbsolutePath() + File.separator + "installer.dat";
    }

    private void saveMetaData() {
        try {
            String string = this.getInstallerDatPath();
            InstallerMetaData installerMetaData = new InstallerMetaData();
            installerMetaData.frostwireVersion = this._updateMessage.getVersion();
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(installerMetaData);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            LOG.info("Can't save update meta data");
        }
    }

    private boolean torrentDataDownloadedToDisk() {
        if (this._manager == null || this._manager.getDiskManager() == null) {
            return false;
        }
        String string = UpdateSettings.UPDATES_DIR.getAbsolutePath();
        File file = new File(string);
        DiskManager diskManager = this._manager.getDiskManager();
        int n = diskManager.getPercentDone();
        long l = diskManager.getTotalLength();
        int n2 = diskManager.getCompleteRecheckStatus();
        return file.exists() && file.length() == l && n == 1000 && n2 == -1;
    }

    public static void printDiskManagerPieces(DiskManager diskManager) {
        DiskManagerPiece[] diskManagerPieceArray;
        if (diskManager == null) {
            return;
        }
        for (DiskManagerPiece diskManagerPiece : diskManagerPieceArray = diskManager.getPieces()) {
            System.out.print(diskManagerPiece.isDone() ? "1" : "0");
        }
        System.out.println();
    }

    public static void printDownloadManagerStatus(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Completed:");
        DownloadManagerStats downloadManagerStats = downloadManager.getStats();
        int n = downloadManagerStats.getCompleted();
        stringBuffer.append(n / 10);
        stringBuffer.append('.');
        stringBuffer.append(n % 10);
        stringBuffer.append('%');
        stringBuffer.append(" Seeds:");
        stringBuffer.append(downloadManager.getNbSeeds());
        stringBuffer.append(" Peers:");
        stringBuffer.append(downloadManager.getNbPeers());
        stringBuffer.append(" Downloaded:");
        stringBuffer.append(DisplayFormatters.formatDownloaded(downloadManagerStats));
        stringBuffer.append(" Uploaded:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(downloadManagerStats.getTotalDataBytesSent()));
        stringBuffer.append(" DSpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataReceiveRate()));
        stringBuffer.append(" USpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataSendRate()));
        stringBuffer.append(" TrackerStatus:");
        stringBuffer.append(downloadManager.getTrackerStatus());
        while (stringBuffer.length() < 80) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(" TO:");
        stringBuffer.append(downloadManager.getSaveLocation().getAbsolutePath());
        System.out.println(stringBuffer.toString());
    }

    public static final String getLastMD5() {
        return lastMD5;
    }

    public static final boolean checkMD5(File file, String string) throws Exception {
        String string2;
        if (string == null) {
            throw new Exception("Expected MD5 is null");
        }
        if (string.length() != 32) {
            throw new Exception("Invalid Expected MD5, not 32 chars long");
        }
        lastMD5 = string2 = InstallerUpdater.getMD5(file).trim();
        return string2.equalsIgnoreCase(string.trim());
    }

    public static final String getMD5(File file) throws Exception {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[65536];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        ((InputStream)bufferedInputStream).close();
        String string = new BigInteger(1, messageDigest.digest()).toString(16);
        if (string.length() < 32) {
            int n2 = 32 - string.length();
            for (int i = 0; i < n2; ++i) {
                string = "0" + string;
            }
        }
        System.out.println("MD5: " + string);
        return string;
    }

    public static final void downloadTorrentFile(String string, File file) throws IOException, URISyntaxException {
        byte[] byArray = new HttpFetcher(new URI(string)).fetch();
        if (file != null && byArray != null && byArray.length > 0) {
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            file.createNewFile();
            file.setWritable(true);
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    public static class InstallerMetaData
    implements Serializable {
        private static final long serialVersionUID = -2309399378691373445L;
        public String frostwireVersion;
    }
}

