/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.InstallerUpdater;
import com.frostwire.gui.updates.UpdateMediator;
import com.frostwire.gui.updates.UpdateMessage;
import com.frostwire.gui.updates.UpdateMessageReader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class UpdateManager
implements Serializable {
    private static final long serialVersionUID = -3312314587704399041L;
    private static final int OPTION_OPEN_URL = 1;
    private static final int OPTION_LATER = 0;
    private static final int OPTION_DOWNLOAD_TORRENT = 2;
    private static transient HashSet<UpdateMessage> _seenMessages;
    transient UpdateMessage _updateMessage = null;
    transient HashSet<UpdateMessage> _announcements = null;
    private static UpdateManager INSTANCE;
    private Date _serverTime = null;

    public static void scheduleUpdateCheckTask(final int n, final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UpdateManager updateManager = UpdateManager.getInstance();
                updateManager.checkForUpdates(string);
            }
        };
        new Thread(runnable).start();
    }

    public static void scheduleUpdateCheckTask(int n) {
        UpdateManager.scheduleUpdateCheckTask(n, null);
    }

    private UpdateManager() {
    }

    public void setServerTime(String string) {
        this._serverTime = null;
        try {
            this._serverTime = new Date(Long.parseLong(string));
        }
        catch (Exception exception) {
            System.out.println("Warning: UpdateManager.setServerTime(): Could not set time from server, using local time");
        }
        if (this._serverTime == null) {
            this._serverTime = Calendar.getInstance().getTime();
        }
    }

    public Date getServerTime() {
        return this._serverTime;
    }

    public void checkForUpdates(String string) {
        UpdateMessageReader updateMessageReader = new UpdateMessageReader();
        updateMessageReader.setUpdateURL(string);
        updateMessageReader.readUpdateFile();
        this.handlePossibleUpdateMessage(updateMessageReader);
        if (updateMessageReader.hasAnnouncements()) {
            this.attemptShowAnnouncements(updateMessageReader.getAnnouncements());
        }
    }

    private void handlePossibleUpdateMessage(UpdateMessageReader updateMessageReader) {
        UpdateMessage updateMessage = updateMessageReader.getUpdateMessage();
        if (updateMessage != null) {
            UpdateMediator.instance().setUpdateMessage(updateMessage);
        }
        if (updateMessageReader.hasUpdateMessage() && updateMessage.getVersion() != null && !updateMessage.getVersion().trim().equals("") && UpdateManager.isFrostWireOld(updateMessage.getVersion())) {
            boolean bl;
            boolean bl2 = updateMessage.getUrl() != null;
            boolean bl3 = updateMessage.getTorrent() != null;
            boolean bl4 = bl = updateMessage.getInstallerUrl() != null;
            if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
                if (bl2 && !bl3 && !bl) {
                    this.showUpdateMessage(updateMessage);
                } else if (bl3 || bl) {
                    new InstallerUpdater(updateMessage).start();
                }
            } else if (OSUtils.isLinux()) {
                if (OSUtils.isUbuntu()) {
                    if (bl3 || bl) {
                        new InstallerUpdater(updateMessage).start();
                    } else {
                        this.showUpdateMessage(updateMessage);
                    }
                } else if (bl2) {
                    this.showUpdateMessage(updateMessage);
                }
            }
        }
    }

    public void showUpdateMessage(final UpdateMessage updateMessage) {
        final String string = updateMessage.getMessageType().equals("update") ? "New FrostWire Update Available" : "FrostWire Team Announcement";
        int n = 2;
        if (updateMessage.getUrl() != null && !updateMessage.getUrl().trim().equals("")) {
            System.out.println("\t" + updateMessage.getUrl());
            n |= 0;
        }
        String[] stringArray = new String[3];
        if (updateMessage.getTorrent() != null) {
            stringArray[2] = new String("Download Torrent");
        } else {
            stringArray = new String[]{new String("Thanks, but not now"), new String("Go to webpage")};
        }
        final int n2 = n;
        final String[] stringArray2 = stringArray;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = JOptionPane.showOptionDialog(null, updateMessage.getMessage(), string, n2, 1, null, stringArray2, null);
                if (n == 1) {
                    GUIMediator.openURL(updateMessage.getUrl());
                } else if (n == 2) {
                    UpdateManager.openTorrent(updateMessage.getTorrent());
                }
            }
        });
    }

    public void attemptShowAnnouncements(HashSet<UpdateMessage> hashSet) {
        for (UpdateMessage updateMessage : hashSet) {
            if (updateMessage.isShownOnce() && this.haveShownMessageBefore(updateMessage) || updateMessage.getUrl() == null || updateMessage.getUrl().trim().equals("")) continue;
            this.showUpdateMessage(updateMessage);
        }
    }

    private void loadSeenMessages() {
        File file = new File(CommonUtils.getUserSettingsDir(), "seenMessages.dat");
        _seenMessages = new HashSet();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("UpdateManager.loadSeenMessages() - Cannot create file to deserialize");
            }
            return;
        }
        if (file.length() == 0L) {
            return;
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            _seenMessages = (HashSet)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("UpdateManager.loadSeenMessages() - Cannot deserialize - ");
            System.out.println(exception);
        }
    }

    private void saveSeenMessages() {
        if (_seenMessages == null || _seenMessages.size() < 1) {
            return;
        }
        File file = new File(CommonUtils.getUserSettingsDir(), "seenMessages.dat");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("UpdateManager.saveSeenMessages() cannot create file to serialize seen messages");
            }
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(_seenMessages);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("UpdateManager.saveSeenMessages() - Cannot serialize.");
            exception.printStackTrace();
        }
    }

    public boolean haveShownMessageBefore(UpdateMessage updateMessage) {
        if (!updateMessage.isShownOnce()) {
            return false;
        }
        this.loadSeenMessages();
        if (_seenMessages == null || _seenMessages.size() == 0 || !_seenMessages.contains(updateMessage)) {
            if (_seenMessages == null) {
                _seenMessages = new HashSet();
            }
            _seenMessages.add(updateMessage);
            this.saveSeenMessages();
            return false;
        }
        return true;
    }

    public static boolean isFrostWireOld(String string) {
        if (string == null) {
            return false;
        }
        String string2 = FrostWireUtils.getFrostWireVersion();
        if (string2.equals(string)) {
            return false;
        }
        try {
            String[] stringArray = string2.split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            String[] stringArray2 = string.split("\\.");
            int n4 = Integer.parseInt(stringArray2[0]);
            int n5 = Integer.parseInt(stringArray2[1]);
            int n6 = Integer.parseInt(stringArray2[2]);
            if (n < n4) {
                return true;
            }
            if (n == n4 && n2 < n5) {
                return true;
            }
            if (n == n4 && n2 == n5 && n3 < n6) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static synchronized UpdateManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    public static void openTorrent(String string) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getScheme();
            if (string2 == null || !string2.equalsIgnoreCase("http")) {
                return;
            }
            String string3 = uRI.getAuthority();
            if (string3 == null || string3.equals("") || string3.indexOf(32) != -1) {
                return;
            }
            GUIMediator.instance().openTorrentURI(uRI.toString(), false);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.out.println(uRISyntaxException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    static {
        INSTANCE = null;
    }
}

