/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.InstallerUpdater;
import com.frostwire.gui.updates.UpdateManager;
import com.frostwire.gui.updates.UpdateMessage;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FilenameUtils;
import org.limewire.util.OSUtils;

public final class UpdateMediator {
    private static final Log LOG = LogFactory.getLog(UpdateMediator.class);
    private UpdateMessage latestMsg;
    private static UpdateMediator instance;

    public static UpdateMediator instance() {
        if (instance == null) {
            instance = new UpdateMediator();
        }
        return instance;
    }

    private UpdateMediator() {
    }

    public boolean isUpdated() {
        return this.latestMsg != null && this.latestMsg.getVersion() != null && !this.latestMsg.getVersion().trim().equals("") && !UpdateManager.isFrostWireOld(this.latestMsg.getVersion());
    }

    public String getLatestVersion() {
        return this.latestMsg != null ? this.latestMsg.getVersion() : "";
    }

    public boolean isUpdateDownloading() {
        if (this.latestMsg == null) {
            return false;
        }
        String string = InstallerUpdater.getLastMD5();
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase(this.latestMsg.getRemoteMD5().trim());
    }

    public boolean isUpdateDownloaded() {
        if (this.latestMsg == null) {
            return false;
        }
        String string = InstallerUpdater.getLastMD5();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(this.latestMsg.getRemoteMD5().trim());
    }

    public File getUpdateBinaryFile() {
        try {
            int n;
            if (this.latestMsg == null) {
                return null;
            }
            String string = null;
            if (this.latestMsg.getTorrent() != null) {
                n = this.latestMsg.getTorrent().lastIndexOf(47) + 1;
                int n2 = this.latestMsg.getTorrent().lastIndexOf(".torrent");
                string = this.latestMsg.getTorrent().substring(n, n2);
            } else if (this.latestMsg.getInstallerUrl() != null) {
                n = this.latestMsg.getInstallerUrl().lastIndexOf(47) + 1;
                string = this.latestMsg.getInstallerUrl().substring(n);
            }
            File file = new File(UpdateSettings.UPDATES_DIR, string);
            if (string == null || !file.exists()) {
                return null;
            }
            return file;
        }
        catch (Throwable throwable) {
            LOG.error("Error getting update binary path", throwable);
            return null;
        }
    }

    public void startUpdate() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                File file = UpdateMediator.this.getUpdateBinaryFile();
                if (file == null || UpdateMediator.this.latestMsg == null) {
                    return;
                }
                try {
                    if (OSUtils.isWindows()) {
                        String[] stringArray = new String[]{"CMD.EXE", "/C", file.getAbsolutePath()};
                        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                        processBuilder.start();
                    } else if (OSUtils.isLinux() && OSUtils.isUbuntu()) {
                        String[] stringArray = new String[]{"gdebi-gtk", file.getAbsolutePath()};
                        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                        processBuilder.start();
                    } else if (OSUtils.isMacOSX()) {
                        String[] stringArray = new String[]{"hdiutil", "attach", file.getAbsolutePath()};
                        String[] stringArray2 = new String[]{"open", "/Volumes/" + FilenameUtils.getBaseName(file.getName())};
                        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                        Process process = processBuilder.start();
                        process.waitFor();
                        processBuilder = new ProcessBuilder(stringArray2);
                        processBuilder.start();
                    }
                    GUIMediator.shutdown();
                }
                catch (Throwable throwable) {
                    LOG.error("Unable to launch new installer", throwable);
                }
            }
        });
    }

    public void checkForUpdate() {
        this.latestMsg = null;
        UpdateManager.scheduleUpdateCheckTask(0);
    }

    public void setUpdateMessage(UpdateMessage updateMessage) {
        this.latestMsg = updateMessage;
    }

    public void showUpdateMessage() {
        if (this.latestMsg == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, this.latestMsg.getMessageInstallerReady(), I18n.tr("Update"), 0, 1);
        if (n == 0) {
            this.startUpdate();
        }
    }
}

